! Copyright (C) 2013, Thomas M. Melvin and Keith R. Briffa, see 
! the GNU General Public License.
      MODULE  yamal2    
      USE crustutil
      IMPLICIT NONE
      CHARACTER(30),DIMENSION(fin) :: y2nam
      CONTAINS   
!--------------------------------------------------------
      SUBROUTINE yam2_val()  
      IMPLICIT NONE                 
      y2nam(1:30)= &
       (/"Exit end align                ", &
         "Save this plot                ", &
         "( 3)                          ", &
         "( 4)                          ", &
         "( 5)                          ", &
         "( 6)                          ", &
         "( 7)                          ", &
         "( 8)                          ", &
         "( 9)                          ", &
         "(10)                          ", &
         "(11)                          ", &
         "(12)                          ", &
         "(13)                          ", &
         "(14)                          ", &
         "(15)                          ", &
         "(16)                          ", &
         "(17)                          ", &
         "(18)                          ", &
         "(19)                          ", &
         "(20)                          ", &
         "(21)                          ", &
         "(22)                          ", &
         "(23)                          ", &
         "(24)                          ", &
         "(25)                          ", &
         "(26)                          ", &
         "(27)                          ", &
         "(28)                          ", & 
         "(29)                          ", &
         "(30)                          "/)
      y2nam(31:60)= &
       (/"(31) E1 Fig1 Num Pol-Yam      ", &
         "(32) E3 Yamal TRW - tree/crn  ", &
         "(33) E4 Polar TRW - tree/crn  ", &
         "(34) E5 Polar MXD - tree/crn  ", &
         "(35) E6 Yamalia - tree/crn    ", &
         "(36) E7 EPS Polar TRW         ", &
         "(37) E8 EPS Polar MXD         ", &
         "(38) E9 EPS Yamal TRW         ", &
         "(39) E10 EPS Yamal (2000)     ", &
         "(40) E11 EPS Polar TRW Norm   ", &
         "(41) E12 EPS Polar MXD Norm   ", &
         "(42) E13 EPS Yamal Norm       ", &
         "(43)                          ", &
         "(44)                          ", &
         "(45) R02 poluroot.raw         ", &
         "(46) R03 poluroot.mxd         ", &
         "(47) R04 pou_la_mod.raw       ", &
         "(48) R05 pou_la_mod.mxd       ", &
         "(49) R06 polustem.raw         ", &
         "(50) R07 polustem.mxd         ", &
         "(51) R08 purlax.raw           ", &
         "(52) R09 purlax.mxd           ", &
         "(53) R10 polurulax.raw        ", &
         "(54) R11 polurulax.mxd        ", &
         "(55) R12 purlasi_scm.raw      ", &
         "(56) R13 purlasi_scm.mxd      ", &
         "(57) R14 polar.raw            ", &
         "(58)                          ", &
         "(59)                          ", & 
         "(60)                          "/) 
      y2nam(61:90)= &
       (/"(61) U1 Boot Urals RCS        ", &
         "(62) U2 Boot Urals CRN        ", &
         "(63) U3 Boot Urals CRN 1.0    ", &
         "(64) U4 -Esper with/no root   ", &
         "(65) U5 -Urals with/no root   ", &
         "(66) U6 - EPS Urals           ", &
         "(67) U7 - EPS Urals no root   ", &
         "(68) U8 - EPS Polar           ", &
         "(69) U9 - EPS Polar no root   ", &
         "(70) UTab1 - Urals Xcorr      ", &
         "(71)                          ", &
         "(72)                          ", &
         "(73)                          ", &
         "(74) PY03 Yam/Pol U Curves    ", &
         "(75) PY04 Yamal Distrib       ", &
         "(76) PY05 Polar TRW Distrib   ", &
         "(77) PY06 Polar MXD Distrib   ", &
         "(78) PY07 Yamal Norm Distrib  ", &
         "(79) PY08 Polar TRW Normal    ", &
         "(80) PY09 Polar MXD Normal    ", &
         "(81)                          ", &
         "(82)                          ", &
         "(83)                          ", &
         "(84)                          ", &
         "(85)                          ", &
         "(86)                          ", &
         "(87)                          ", &
         "(88)                          ", &
         "(89)                          ", &
         "(90) Select Fist Yamal Menu   "/)
      RETURN 
      END SUBROUTINE yam2_val
!--------------------------------------------------------
      SUBROUTINE yam2v(ref1,plot)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1  ! Chosen action
      INTEGER,INTENT(IN) :: plot  ! Plot number
      INTEGER            :: i
      CALL ERASE()
      SELECT CASE (ref1)
      CASE (2)                    ! Save plot as .ps file
        figm="yamal/ym20"
        CALL open_ps(plot,10)
        SELECT CASE (plot)
          CASE (31) ; CALL Yam_numd()
          CASE (32:35) ; CALL py_sitsd(plot-31)
          CASE (36:42) ; CALL EPS_prepd()
          CASE (45:60) ; CALL rescale_pold()
          CASE (61) ; CALL boot_urd() 
          CASE (62) ; CALL boot_ucd() 
          CASE (63) ; CALL boot_uc1d() 
          CASE (64:65) ; CALL polu_errd()
          CASE (66:69) ; CALL EPS_prepd()
          CASE (74) ; CALL ucurved()
          CASE (75:80) ; CALL Yam_SDevd(plot-74)
        END SELECT
        CALL plot_psend()
      CASE (31) ; CALL Yam_num()  ; CALL Yam_numd()   ! Pol-Yam Counts
      CASE (32:35) ; CALL py_cols() ; CALL py_sitsd(ref1-31)  ! Write Columns
      CASE (36:42) ; CALL urals_eps(ref1-31) ; CALL EPS_prepd() ! EPS root/not
      CASE (45:60) ; CALL rescale_pol(ref1-44) ; CALL rescale_pold()
      CASE (61) ; CALL boot_u() ; CALL boot_urd()     ! boot urals/polar
      CASE (62) ; CALL boot_u() ; CALL boot_ucd()     ! boot urals/polar
      CASE (63) ; CALL boot_u() ; CALL boot_uc1d()    ! boot urals/polar
      CASE (64:65) ; CALL polu_err(ref1-63)  ; CALL polu_errd() ! Polar root/not
      CASE (66:69) ; CALL urals_eps(ref1-65) ; CALL EPS_prepd() ! EPS root/not
      CASE (70) ; CALL urals_xc()    ! Urals cross correlation table
      CASE (74) ; CALL ucurve() ; CALL ucurved() ! Yam/Pol - U Curves 
      CASE (75:80) ; CALL Yam_SDev(ref1-74)
                     CALL Yam_SDevd(ref1-74)    ! Yamal Stand Dev
      CASE (90) ; srcok=TR
      END SELECT
      b(272)%ok=TR
      IDO: DO i=1,50
        b(271)%on=TR ; CALL but_draw(272,"")
        CALL mouse_click(3,272,272) ; IF (mous.EQ.272) EXIT IDO
      ENDDO IDO
      b(272)%ok=FA
      RETURN 
      END SUBROUTINE yam2v
!----------------------------------------------------------------
      SUBROUTINE ucurved()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER                :: i=1,r
      r=1001 ; wka(1:r)=(/(DBLE(i)/100.D0,i=-500,500)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL LABELS('NONE','X')
      CALL NAME('','X')               ! Axis name
      CALL NAME('Count of Values','Y')   ! Axis name
      CALL tombox(-3,+3,1.D0,550.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(4) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; CALL CURVE(wka(1:r),crn(1:r,6),r)
      CALL SETCLR(red) ; CALL CURVE(wka(1:r),crn(1:r,7),r)
      CALL SETCLR(blue) ; CALL CURVE(wka(1:r),crn(1:r,5),r)
      CALL SETCLR(silver)
      DO i=1,r-2,5 ; CALL CURVE(wka(i:i+2),crn(i:i+2,8),3) ; ENDDO
      CALL SETCLR(cyan) ; CALL LINWID(1)
      CALL MESSAG("One RCS Indices",grl+500,grt-40)
      CALL SETCLR(red)
      CALL MESSAG("Two RCS Indices",grl+900,grt-40)
      CALL SETCLR(blue)
      CALL MESSAG("30yr Spline",grl+1300,grt-40)
      CALL SETCLR(silver)
      CALL MESSAG("Normal Distribution",grl+1700,grt-40)
      CALL SETCLR(black)
      CALL MESSAG(wnam(20),grl+100,grt-40)
      CALL MESSAG("a) Yamal TRW",grl+100,grt+30)
      CALL ENDGRF() 

      grt=560 ; grb=960
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL NAME('Count of Values','Y')   ! Axis name
      CALL tombox(-3,+3,1.D0,120.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(4) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; CALL CURVE(wka(1:r),crn(1:r,10),r)
      CALL SETCLR(red) ; CALL CURVE(wka(1:r),crn(1:r,11),r)
      CALL SETCLR(blue) ; CALL CURVE(wka(1:r),crn(1:r,9),r)
      CALL SETCLR(silver)
      DO i=1,r-2,5 ; CALL CURVE(wka(i:i+2),crn(i:i+2,12),3) ; ENDDO
      CALL SETCLR(black) ; CALL LINWID(1) 
      CALL MESSAG("b) Polar TRW",grl+100,grt+30)
      CALL ENDGRF()

      grt=970 ; grb=1370
      CALL LABELS('FLOAT','X')
      CALL NAME('Standard Deviation','X') ! Axis name
      CALL NAME('Count of Values','Y')    ! Axis name
      CALL tombox(-3,+3,1.D0,120.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(4) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; CALL CURVE(wka(1:r),crn(1:r,14),r)
      CALL SETCLR(red) ; CALL CURVE(wka(1:r),crn(1:r,15),r)
      CALL SETCLR(blue) ; CALL CURVE(wka(1:r),crn(1:r,13),r)
      CALL SETCLR(silver)
      DO i=1,r-2,5 ; CALL CURVE(wka(i:i+2),crn(i:i+2,16),3) ; ENDDO
      CALL SETCLR(black) ; CALL LINWID(1) 
      CALL MESSAG("c) Polar MXD",grl+100,grt+30)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE ucurved
!-------------------------------------------------------------------
      SUBROUTINE ucurve()  ! Distribution of various indices 
      IMPLICIT NONE
      INTEGER  :: i,j,k,m,n,p
      REAL(8)  :: rr,mn,sd
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      crn(1:1000,5:16)=0.D0 
      CALL det_default() ; ind=1 ; itn=1      ! Ratios
      wnam(20)="Ratios"
      DO n=1,3               ! For each site
        cf=n ; nc=0 ; CALL read_rft(cnam(n))
        m=ad(nc)+yr(nc)-1 ; rr=DBLE(m)     
        DO i=1,4
          p=n*4+i
          IF (i.EQ.1) THEN
            idt=30 ; CALL detrend()   ! Spline detrend
          ELSEIF (i.EQ.2) THEN
            idt=-2 ; src=1 ; srcno=1  ! 1 curve RCS detrend
            CALL detrend()             
          ELSEIF (i.EQ.3) THEN
            idt=-2 ; src=2 ; srcno=2  ! 2 curve RCS detrend
            CALL detrend()             
          ELSEIF (i.EQ.4) THEN
            CALL randnorm(m,dx)    ! Random number sequence 
          ENDIF 
          mn=SUM(dx(1:m))/rr       ! Normalise indices
          sd=SQRT(SUM((dx(1:m)-mn)**2)/(rr-1.D0))
          dx(1:m)=(dx(1:m)-mn)/sd
          DO k=1,m                 ! Accumulate distribution
            j=NINT(dx(k)*100.D0)+501 ; j=MAX(1,MIN(1000,j))
            crn(j,p)=crn(j,p)+1.D0
          ENDDO                    ! Smooth distribution curve
          CALL splinet(1000,crn(1:1000,p),60,crn(1:1000,p))    
        ENDDO
      ENDDO
      CALL det_default()
      RETURN
      END SUBROUTINE ucurve
!--------------------------------------------------------------
      SUBROUTINE Yam_SDevd(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1    ! Choice of data to use
      CHARACTER(20),DIMENSION(3:7) :: lab
      REAL(8),DIMENSION(mxy)       :: wka
      INTEGER :: i=1,j,k,r,ra
      lab=(/"b) By Calendar Year","c) Sorted on Index ", &
            "d) Scaled by Index ","e) Sorted on count ", &
            "e) Scaled to 20    "/)
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grl=200 ; grr=2400 ; ra=140 ; grt=ra ; grb=ra+240
      CALL plot_trees(r,num(1:r,2))  
      CALL LABELS('NONE','X')
      CALL NAME('','X')               ! Axis name
      CALL NAME('Index Values','Y')   ! Axis name
      IF (ref1.GE.4) THEN  
        CALL tombox(cfy(1),cly(1),-2.5D0,2.5D0)
        k=4
      ELSEIF (ref1.EQ.3) THEN  
        CALL tombox(cfy(1),cly(1),0.6D0,1.3D0)
        k=5
      ELSE
        CALL tombox(cfy(1),cly(1),0.1D0,2.6D0)
        k=5
      ENDIF
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black)
      CALL CURVE(wka(1:r),crn(1:r,2),r)
      CALL MESSAG(cnam(21),grl+900,grt-45)
      CALL MESSAG(wnam(21),grl+100,grt-45)
      CALL ENDGRF() ; CALL LINWID(1) 
      CALL NAME('S.Dev.','Y')   ! Axis name
      ra=ra+10
      DO j=3,k
        ra=ra+240 ; grt=ra ; grb=ra+230
        IF (j.EQ.k) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')               ! Axis name
        ENDIF
        IF (ref1.EQ.3) THEN  
          CALL tombox(cfy(1),cly(1),0.D0,0.4D0)
        ELSE
          CALL tombox(cfy(1),cly(1),0.D0,1.5D0)
        ENDIF
        CALL LINWID(4) ; CALL SETCLR(silver)
        DO i=1,r
          CALL RLINE(wka(i),0.D0,wka(i),crn(i,j))
        ENDDO
        CALL LINWID(1) ; CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        CALL HEIGHT(22) ; CALL SETCLR(black)
        CALL MESSAG(lab(j),grl+900,grt+30)
        CALL ENDGRF() 
      ENDDO
      RETURN 
      END SUBROUTINE Yam_SDevd
!-------------------------------------------------------------------
      SUBROUTINE Yam_SDev(ref1)   
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ref1    ! Choice of data to use
      INTEGER            :: i,j,p,q,r,u,v
      IF (ref1.EQ.1.OR.ref1.EQ.4) THEN
        cnam(1)="../../raw/yam/yml-all.raw"
        wnam(21)="Yamal TRW"
      ELSEIF (ref1.EQ.2.OR.ref1.EQ.5) THEN
        cnam(1)="../../raw/polar/polar.raw"
        wnam(21)="Polar TRW"
      ELSEIF (ref1.EQ.3.OR.ref1.EQ.6) THEN
        cnam(1)="../../raw/polar/polarxs.mxd"
        wnam(21)="Polar MXD"
      ENDIF
      nc=0 ; CALL read_rft(cnam(1))
      CALL det_default() ; idt=-2 ; cf=1 
      src=2 ; srcno=2    ! 2 RCS curves
      IF (ref1.GE.4) THEN
        idb=2  ! Normal index distribution 
        cnam(21)="a) Two-curve RCS, Normal Distribution "
      ELSE
        idb=1  ! Fractional deviations 
        cnam(21)="a) Two-curve RCS Chronology"
      ENDIF
      CALL detrend() ; r=cyr(1)
      crn(1:r,2:8)=0.D0 ; num(1:r,2)=0
      DO i=1,nc              ! Simple RCS
        p=ad(i) ; j=yr(i) ; q=p+j-1 ; u=fy(i)-cfy(1)+1 ; v=u+j-1
        WHERE (xok(p:q))
          num(u:v,2)=num(u:v,2)+1
          crn(u:v,3)=crn(u:v,3)+dx(p:q)
          crn(u:v,4)=crn(u:v,4)+dx(p:q)**2
        END WHERE
      ENDDO                  ! Ignore counts < 4
      JD: DO j=1,r ; IF (num(j,2).GE.4) EXIT JD ; ENDDO JD
      crn(1:r-j+1,1:4)=crn(j:r,1:4) ; num(1:r-j+1,2)=num(j:r,2)  
      cfy(1)=cfy(1)+j-1 ; r=r-j+1 ; cyr(1)=r
      crn(1:r,2)=crn(1:r,3)/DBLE(num(1:r,2))      ! CRN
      crn(1:r,3)=SQRT(MAX(crn(1:r,4)-crn(1:r,2)* &  
        crn(1:r,3),0.001D0)/DBLE(num(1:r,2)-1))   ! SDev 
      tso(1:r)=crn(1:r,2)              ! Sort by index value
      CALL pair_sort(r,tso(1:r),tre(1:r)) 
      DO j=1,r
        p=tre(j) ; crn(j,4)=crn(p,3)   ! Sorted errors
        crn(p,5)=crn(p,3)/crn(p,2)     ! Not sorted, scaled errors
      ENDDO
      tso(1:r)=DBLE(num(1:r,2))        ! Sort by sample count
      CALL pair_sort(r,tso(1:r),tre(1:r)) 
      DO j=1,r
        p=tre(j) ; crn(j,6)=crn(p,5)   ! Sorted errors
        crn(p,7)=crn(p,5)*SQRT(DBLE(num(p,2)))/SQRT(30.D0)
      ENDDO    ! Not sorted, scaled errors
      idb=1   ! Normal index distribution off
      RETURN
      END SUBROUTINE Yam_SDev
!--------------------------------------------------------------
      SUBROUTINE read_urals(sit)  ! Reads five regions
      IMPLICIT NONE
      INTEGER,DIMENSION(0:17) :: sit    ! Separate sites
      INTEGER                 :: j=1
      cnam(1)="../../raw/ural/NONBLASI.raw"
      cnam(2)="../../raw/ural/KEDVLANO.raw"
      cnam(3)="../../raw/ural/SHCHLA.raw"
      cnam(4)="../../raw/ural/russ002.rwl"
      cnam(5)="../../raw/ural/KOZHLASI.raw"
      cnam(6)="../../raw/ural/MUZYLASI.raw"
      cnam(7)="../../raw/ural/russ001.rwl"
      cnam(8)="../../raw/polar/poula/pou_la.raw"
      cnam(9)="../../raw/polar/poula/polurula.raw"
      cnam(10)="../../raw/ural/PLL.rwl"
      cnam(11)="../../raw/yam/yamalad.raw"
      cnam(12)="../../raw/ural/KHADYTLA.raw"
      cnam(13)="../../raw/ural/PLR.rwl"
      cnam(14)="../../raw/ural/PDP.rwl"
      cnam(15)="../../raw/ural/PLO.rwl"
      cnam(16)="../../raw/ural/NADILASI.raw"
      cnam(17)="../../raw/ural/KHEYLANA.raw"
      wnam(21)="NONBLASI"
      wnam(22)="KEDVLANO"
      wnam(23)="SHCHLA"
      wnam(24)="russ002"
      wnam(25)="KOZHLASI"
      wnam(26)="MUZYLASI"
      wnam(27)="russ001"
      wnam(28)="POU_LA"
      wnam(29)="POLURULA"
      wnam(30)="PLL"
      wnam(31)="yamalad"
      wnam(32)="KHADYTLA"
      wnam(33)="PLR"
      wnam(34)="PDP"
      wnam(35)="PLO"
      wnam(36)="NADILASI"
      wnam(37)="KHEYLANA"
      nc=0 ; sit(0)=0
      DO j=1,17
        CALL read_rft(cnam(j)) ; sit(j)=nc
      ENDDO  ! Read cores
      RETURN
      END SUBROUTINE read_urals
!-------------------------------------------------------------------
      SUBROUTINE urals_xc()          ! Region analysis
      IMPLICIT NONE
      INTEGER,PARAMETER        :: st=17   ! No of sites
      INTEGER,DIMENSION(0:st)  :: sit     ! Start/end sites
      REAL(8),DIMENSION(st,st) :: utab    ! Xcorr table
      LOGICAL                  :: corok
      INTEGER                  :: i=1,j=1,p,q,r,s,t,u,v
      OPEN(71,FILE="UTab1.prn",IOSTAT=ios,STATUS="REPLACE")
      CALL read_urals(sit)                ! Read raw data
      CALL det_default() ; sfo=2 ; idt=30 ! 30-yr spline 
      utab=0.D0
      DO i=1,st
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend()   
        r=cyr(i) ; okc(1:r,i)=cok(1:r,mx)
        PD: DO p=1,cyr(i) ; IF (num(p,i).GT.4) EXIT PD ; ENDDO PD        
        QD: DO q=cyr(i),p+1,-1 ; IF (num(q,i).GT.4) EXIT QD ; ENDDO QD        
        cfy(20+i)=p+cfy(i)-1
        cly(20+i)=q+cfy(i)-1  ! Usable part of CRN
      ENDDO
      WRITE(71,'("  X  Y  From    To Years")')  
      DO i=1,st-1
        DO j=i+1,st
          p=MAX(cfy(20+i),cfy(20+j))
          q=MIN(cly(20+i),cly(20+j)) ; r=q-p+1
          IF (r.GE.100) THEN  ! 100 year overlap needed
            u=p-cfy(i)+1 ; v=u+r-1
            s=p-cfy(j)+1 ; t=s+r-1
            CALL covmiss(crn(u:v,i),crn(s:t,j),okc(u:v,i) &
                   .AND.okc(s:t,j),r,utab(i,j),corok)
            utab(j,i)=utab(i,j)
            WRITE(71,'(2I3,3I6,2X,2A10)') &
              i,j,p,q,r,wnam(i+20)(1:10),wnam(j+20)(1:10)
          ENDIF
        ENDDO
      ENDDO
      WRITE(71,*)
      WRITE(71,'(3X,17I7)') (/(i,i=1,st)/)
      DO i=1,st
        WRITE(71,'(I3,17F7.2,2X,A20)') i,utab(i,1:17),wnam(i+20)
      ENDDO
      CLOSE(71)
      RETURN
      END SUBROUTINE urals_xc
!----------------------------------------------------------------
      SUBROUTINE RLsolid(cnt,trees,years)
      IMPLICIT NONE             ! Shaded graph area
      INTEGER,INTENT(IN)                 :: cnt     ! Data count
      INTEGER,DIMENSION(cnt),INTENT(IN)  :: trees   ! Tree counts
      REAL(8),DIMENSION(cnt),INTENT(IN)  :: years   ! Year
      REAL(8),DIMENSION(0:cnt+1)         :: zz4,zz5
      zz4(1:cnt)=DBLE(trees)
      zz5(1:cnt)=years
      zz4(0)=0.D0 ; zz5(0)=zz5(1)  
      zz4(cnt+1)=0.D0 ; zz5(cnt+1)=zz5(cnt)  
      CALL RLAREA(zz5,zz4,cnt+2)
      RETURN
      END SUBROUTINE RLsolid
!--------------------------------------------------------------------
     SUBROUTINE Yam_numd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,k,p,q,r,ra
      wka(1:cyr(10))=(/(DBLE(i),i=cfy(10),cly(10))/) 
      p=MAX(601-cfy(10)+1,cfy(5)) ; q=cly(5) ; r=q-p+1
      grl=200 ; grr=2000 ; ra=110 ; grt=ra ; grb=ra+200
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL LABDIG(-2,'Y')
      CALL LABELS('NONE','X')
      CALL NAME('','X')        ! Axis name
      CALL NAME('Count','Y')   ! Axis name
      CALL tombox(601,cly(10),0.D0,40.D0)
      CALL tombox(601,cly(10),0.D0,40.D0)
      CALL SETCLR(silver) ; CALL RLsolid(r,num(p:q,5),wka(p:q))
      CALL SETCLR(cyan)   ; CALL RLsolid(r,num(p:q,6),wka(p:q))
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black)
      CALL MESSAG("a) "//cnam(25),grl+50,grt+28)
      CALL ENDGRF() 
      ra=ra+210 ; grt=ra ; grb=ra+200  
      p=MAX(601-cfy(10)+1,cfy(3)) ; q=cly(3) ; r=q-p+1
      CALL tombox(601,cly(10),0.D0,40.D0)
      CALL SETCLR(silver) ; CALL RLsolid(r,num(p:q,3),wka(p:q))
      CALL SETCLR(cyan)   ; CALL RLsolid(r,num(p:q,4),wka(p:q))
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black)
      CALL MESSAG("b) "//cnam(23),grl+50,grt+28)
      CALL ENDGRF() 
      ra=ra+210 ; grt=ra ; grb=ra+200  
      p=MAX(601-cfy(10)+1,cfy(7)) ; q=cly(7) ; r=q-p+1
      CALL tombox(601,cly(10),0.D0,40.D0)
      CALL SETCLR(cyan) ; CALL RLsolid(r,num(p:q,7),wka(p:q))
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black)
      CALL MESSAG("c) "//cnam(27),grl+50,grt+28)
      CALL ENDGRF()  
      ra=ra+210 ; grt=ra ; grb=ra+200  
      p=MAX(601-cfy(10)+1,cfy(8)) ; q=cly(8) ; r=q-p+1
      CALL tombox(601,cly(10),0.D0,40.D0)
      CALL SETCLR(silver) ; CALL RLsolid(r,num(p:q,8),wka(p:q))
      CALL SETCLR(cyan)   ; CALL RLsolid(r,num(p:q,9),wka(p:q))
      CALL SETCLR(red) ; j=p-1     ! Start
      K2: DO k=1,50  ! Number of segments < 10 
        I2: DO i=j+1,q ; IF (num(i,9).LT.10) EXIT I2 ; ENDDO I2
        IF (i.GT.q) EXIT K2
        J2: DO j=i,q-1 ; IF (num(j+1,9).GE.10) EXIT J2 ; ENDDO J2
        CALL RLsolid(j-i+1,num(i:j,9),wka(i:j))
      ENDDO K2
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(red)   ; CALL MESSAG("< 10 trees",grl+800,grt+28)
      CALL SETCLR(black) ; CALL MESSAG("d) "//cnam(28),grl+50,grt+28)
      CALL ENDGRF()  

      ra=ra+210 ; grt=ra ; grb=ra+200  
      p=MAX(601-cfy(10)+1,cfy(1)) ; q=cly(1) ; r=q-p+1
      CALL tombox(601,cly(10),0.D0,40.D0)
      CALL SETCLR(silver) ; CALL RLsolid(r,num(p:q,1),wka(p:q))
      CALL SETCLR(cyan)   ; CALL RLsolid(r,num(p:q,2),wka(p:q))
      CALL SETCLR(red) ; j=p-1     ! Start
      K3: DO k=1,50  ! Number of segments < 10 
        I3: DO i=j+1,q ; IF (num(i,2).LT.10) EXIT I3 ; ENDDO I3
        IF (i.GT.q) EXIT K3
        J3: DO j=i,q-1 ; IF (num(j+1,2).GE.10) EXIT J3 ; ENDDO J3
        CALL RLsolid(j-i+1,num(i:j,2),wka(i:j))
      ENDDO K3
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(red)   ; CALL MESSAG("< 10 trees",grl+800,grt+28)
      CALL SETCLR(black) ; CALL MESSAG("e) "//cnam(21),grl+50,grt+28)
      CALL ENDGRF()

      ra=ra+210 ; grt=ra ; grb=ra+400  
      p=601-cfy(10)+1 ; q=cyr(10) ; r=q-p+1
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar year','X')     ! Axis name
      CALL tombox(601,cly(10),0.D0,80.D0)
      CALL SETCLR(cyan) ; CALL RLsolid(r,num(p:q,10),wka(p:q))
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black)
      CALL MESSAG("f) "//cnam(30),grl+50,grt+28)
      CALL LABDIG(1,'Y') ; CALL TICKS(5,'Y')   
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE Yam_numd
!-------------------------------------------------------------------
      SUBROUTINE Yam_num() 
      IMPLICIT NONE                 
      INTEGER  :: j,p,q,r
      cnam(1)="../../raw/yam/yamalad.raw"
      cnam(21)="YamalAD"
      cnam(2)="../../raw/yam/yamaladm.raw"
      cnam(22)="YamalAD Mean"
      cnam(3)="../../raw/polar/poula/pou_la_modc.raw"
      cnam(23)="Polar Recent"
      cnam(4)="../../raw/polar/poula/pou_la_mod.raw"
      cnam(24)="Polar Recent Mean"
      cnam(5)="../../raw/polar/poula/pou_la_subc.raw"
      cnam(25)="Polar Sub-fossil"
      cnam(6)="../../raw/polar/poula/pou_la_sub.raw"
      cnam(26)="Polar Sub-fossil Mean"
      cnam(7)="../../raw/polar/poula/polurula.raw"
      cnam(27)="Polurula Sub-fossil"
      cnam(8)="../../raw/polar/poula/larch.raw"
      cnam(28)="Polar Larch"
      cnam(9)="../../raw/polar/poula/larchm.raw"
      cnam(29)="Polar Larch Mean"
      cnam(10)="../../raw/yam/yml-all.raw"
      cnam(30)="Yamal 2012"
      OPEN(74,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      CALL det_default() ; idt=-2
      DO j=1,10
        nc=0 ; cf=j ; CALL read_rft(cnam(j))
        CALL det_crnfy()
        WRITE(74,'(I2,2X,A20,2X,A40)') j,wnam(j+20),cnam(j)
      ENDDO
      DO j=1,9  ! Align on yml-all
        p=cfy(j)-cfy(10)+1 ; r=cyr(j) ; q=p+r-1
        num(p:q,j)=num(1:r,j) ; num(1:p-1,j)=0
        num(q+1:cyr(10),j)=0 ; cfy(j)=p ; cly(j)=q
      ENDDO
      WRITE(74,*)
      WRITE(74,'(5X,10I5)') (/(j,j=1,10)/)
      DO j=1,cyr(1)
        WRITE(74,'(11I5)') cfy(1)-1+j,num(j,1:10)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Yam_num
!------------------------------------------------------------------------
      SUBROUTINE rescale_pold()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      REAL(8)                :: ra,rb,rc,rd
      INTEGER                :: i=1,p,q,r
      r=MAX(cyr(23),cyr(24))
      ra=MIN(MINVAL(crn(1:r,23),MASK=okc(1:r,23)), &
             MINVAL(crn(1:r,24),MASK=okc(1:r,24)), &
             MINVAL(crn(1:r,27),MASK=okc(1:r,23)), &
             MINVAL(crn(1:r,28),MASK=okc(1:r,24))) 
      rb=MAX(MAXVAL(crn(1:r,23),MASK=okc(1:r,23)), &
             MAXVAL(crn(1:r,24),MASK=okc(1:r,24)), &
             MAXVAL(crn(1:r,27),MASK=okc(1:r,23)), &
             MAXVAL(crn(1:r,28),MASK=okc(1:r,24))) 
      r=cyr(1)
      rc=MIN(MINVAL(crn(1:r,25),MASK=okc(1:r,25)), &
             MINVAL(crn(1:r,26),MASK=okc(1:r,26)), &
             MINVAL(crn(1:r,29),MASK=okc(1:r,25)), &
             MINVAL(crn(1:r,30),MASK=okc(1:r,26))) 
      rd=MAX(MAXVAL(crn(1:r,25),MASK=okc(1:r,25)), &
             MAXVAL(crn(1:r,26),MASK=okc(1:r,26)), &
             MAXVAL(crn(1:r,29),MASK=okc(1:r,25)), &
             MAXVAL(crn(1:r,30),MASK=okc(1:r,26))) 
      CALL NAME('','X') ! Axis name
      CALL LABELS('NONE','X')
      grl=200 ; grr=2400 ; grt=140 ; grb=540
      wka(1:1000)=(/(DBLE(i),i=1,1000)/)
      p=1 ; q=MINVAL(cly(23:24)) ; r=q-p+1
      CALL plot_trees(r,num(1:q,23))  
      CALL NAME(wnam(4),'Y') ! Axis name
      CALL tombox(1,q,ra,rb)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(blue)
      p=cfy(23) ; q=cly(23) ; r=cyr(23)
      CALL thickthin(r,wka(p:q),crn(p:q,23),num(p:q,23),3)
      CALL MESSAG(TRIM(wnam(1))//" (counts)",grl+800,grb-45)
      CALL SETCLR(red)
      p=cfy(24) ; q=cly(24) ; r=cyr(24)
      CALL thickthin(r,wka(p:q),crn(p:q,24),num(p:q,24),3)
      CALL MESSAG(wnam(2),grl+1500,grt+25)
      CALL SETCLR(black)
      CALL MESSAG("Original RCS Curves",grl+100,grb-45)
      CALL ENDGRF() 

      CALL NAME('Ring Age','X') ! Axis name
      CALL LABELS('FLOAT','X')
      grt=550 ; grb=950
      wka(1:1000)=(/(DBLE(i),i=1,1000)/)
      p=1 ; q=MINVAL(cly(23:24)) ; r=q-p+1
      CALL plot_trees(r,num(1:q,24))  
      CALL NAME('Mean MXD','Y') ! Axis name
      CALL tombox(1,q,ra,rb)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(blue)
      p=cfy(23) ; q=cly(23) ; r=cyr(23)
      CALL thickthin(r,wka(p:q),crn(p:q,27),num(p:q,23),3)
      CALL MESSAG(wnam(3),grl+800,grb-45)
      CALL SETCLR(red)
      p=cfy(24) ; q=cly(24) ; r=cyr(24)
      CALL thickthin(r,wka(p:q),crn(p:q,28),num(p:q,24),3)
      CALL MESSAG(TRIM(wnam(2))//" (counts)",grl+1500,grt+25)
      CALL SETCLR(black)
      CALL MESSAG("Adjusted RCS Curves",grl+100,grb-45)
      CALL ENDGRF()

      CALL NAME('MXD Indices','Y') ! Axis name
      CALL NAME('','X') ! Axis name
      CALL LABELS('NONE','X')
      grt=1060 ; grb=1460
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/)
      CALL plot_trees(r,num(1:r,25))  
      CALL NAME('Index Value','Y') ! Axis name
      CALL tombox(cfy(1),cly(1),rc,rd)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue)
      p=cfy(25) ; q=cly(25) ; r=cyr(25)
      CALL thickthin(r,wka(p:q),crn(p:q,25),num(p:q,25),3)
      CALL MESSAG(TRIM(wnam(1))//" (counts)",grl+800,grt+25)
       CALL SETCLR(red)
      p=cfy(26) ; q=cly(26) ; r=cyr(26)
      CALL thickthin(r,wka(p:q),crn(p:q,26),num(p:q,26),3)
      CALL MESSAG(wnam(2),grl+1500,grt+25)
      CALL SETCLR(black)
      CALL MESSAG("Original Chronologies",grl+100,grt+25)
      CALL ENDGRF()

      CALL NAME('Calendar Year','X') ! Axis name
      CALL LABELS('FLOAT','X')
      grt=1470 ; grb=1870
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/)
      CALL plot_trees(r,num(1:r,26))  
      CALL NAME('Index Value','Y') ! Axis name
      CALL tombox(cfy(1),cly(1),rc,rd)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue)
      p=cfy(25) ; q=cly(25) ; r=cyr(25)
      CALL thickthin(r,wka(p:q),crn(p:q,29),num(p:q,25),3)
      CALL MESSAG(wnam(3),grl+800,grt+25)
      CALL SETCLR(red)
      p=cfy(26) ; q=cly(26) ; r=cyr(26)
      CALL thickthin(r,wka(p:q),crn(p:q,30),num(p:q,26),3)
      CALL MESSAG(TRIM(wnam(2))//" (counts)",grl+1500,grt+25)
      CALL SETCLR(black)
      CALL MESSAG("Adjusted Chronologies",grl+100,grt+25)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE rescale_pold
!-----------------------------------------------------------------------
      SUBROUTINE resc2_pol(ref1,nc1,mna,sda)  ! Test signal free RCS
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)  :: ref1   ! MXD=1, TRW=2
      INTEGER,INTENT(IN)  :: nc1    ! Trees in first file
      REAL(8),INTENT(OUT) :: mna    ! Mean adjustment
      REAL(8),INTENT(OUT) :: sda    ! SDev adjustment
      REAL(8)  :: mn1,mn2,sd1,sd2,rr1,rr2,rb 
      INTEGER  :: i,r,u,v,s,t,nr1,nr2
      rr1=0.D0 ; rr2=0.D0 ; sd1=0.D0 ; sd2=0.D0
      nr1=0 ; nr2=0 ; r=cyr(cf)
      DO i=1,nc                     ! Use signal-free indices      
        u=ad(i) ; v=u+yr(i)-1
        s=fy(i)-cfy(cf)+1 ; t=s+yr(i)-1
        IF (i.LE.nc1) THEN
          rr1=rr1+SUM(dx(u:v)/crn(s:t,cf),MASK=xok(u:v))
          sd1=sd1+SUM((dx(u:v)/crn(s:t,cf))**2,MASK=xok(u:v))
          nr1=nr1+COUNT(xok(u:v))
        ELSE
          rr2=rr2+SUM(dx(u:v)/crn(s:t,cf),MASK=xok(u:v))
          sd2=sd2+SUM((dx(u:v)/crn(s:t,cf))**2,MASK=xok(u:v))
          nr2=nr2+COUNT(xok(u:v))
        ENDIF
      ENDDO
      mn1=rr1/DBLE(nr1)
      mn2=rr2/DBLE(nr2)
      sd1=SQRT((sd1-mn1*rr1)/DBLE(nr1-1))   ! SDev 
      sd2=SQRT((sd2-mn2*rr2)/DBLE(nr2-1))   ! SDev 
      WRITE(19,'(2I6,2F9.5)') nr1,nc1,mn1,sd1
      WRITE(19,'(2I6,2F9.5,2I7)') nr2,nc-nc1,mn2,sd2,cf
      r=ad(nc1)+yr(nc1)-1
      mna=1.D0+(mn2-1.D0)*DBLE(nr1+nr2)/DBLE(nr1)
      IF (ref1.EQ.1) THEN  ! Only adjust SDev for MXD 
        rb=SUM(x(1:r),MASK=xok(1:r))/DBLE(COUNT(xok(1:r)))
        x(1:r)=(x(1:r)-rb)*sd2/sd1+rb
        sda=sd2/sd1
      ELSE
        sda=1.D0           ! No adjustment TRW SDev
      ENDIF 
      WHERE (xok(1:r)) x(1:r)=x(1:r)*mna  ! Reset Mean
      RETURN 
      END SUBROUTINE resc2_pol
!-----------------------------------------------------------------------
      SUBROUTINE resc_pol(ref1)  ! Test signal free RCS
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1   ! MXD=1, TRW=2
      REAL(8)            :: mna    ! Mean adjustment
      REAL(8)            :: sda    ! SDev adjustment
      REAL(8)            :: mn,sd  ! Accumulated values
      INTEGER            :: i,p,q,s,t,u,v,nc1
      CHARACTER(20)      :: znam 
      znam="Rescale_Pol.prn"
      INQUIRE(FILE=znam,EXIST=fileok)  
      IF (fileok) THEN
        OPEN(19,FILE=znam,IOSTAT=ios,STATUS="OLD",POSITION="APPEND")
        IF (io_err("Open App",znam)) STOP
        WRITE(19,*)
      ELSE
        OPEN(19,FILE=znam,IOSTAT=ios,STATUS="REPLACE")
        IF (io_err("Open Replace",znam)) STOP
      ENDIF
      i=LEN_TRIM(cnam(1))
      cnam(3)=cnam(1)(1:i-4)//"adj"//cnam(1)(i-3:i)
      cnam(4)=cnam(3)(1:i)//"pth"
      i=LEN_TRIM(wnam(1))
      wnam(3)=wnam(1)(1:i-4)//"adj"//wnam(1)(i-3:i)
      WRITE(19,*) TRIM(cnam(1))
      WRITE(19,*) TRIM(cnam(2))
      WRITE(19,*) TRIM(cnam(3))
      CALL det_default() ; nc=0 ;cf=1
      CALL read_rft(cnam(1)) ; nc1=nc
      CALL read_rft(cnam(2)) 
      sfo=2 ; idt=-2 ; CALL detrend()
      cfy(23)=MINVAL(fy(1:nc1)-pth(1:nc1))        ! First by age
      cly(23)=MAXVAL(ly(1:nc1)-pth(1:nc1))
      cyr(23)=cly(23)-cfy(23)+1
      cfy(24)=MINVAL(fy(nc1+1:nc)-pth(nc1+1:nc))  ! Second by age
      cly(24)=MAXVAL(ly(nc1+1:nc)-pth(nc1+1:nc))
      cyr(24)=cly(24)-cfy(24)+1
      cfy(25)=MINVAL(fy(1:nc1))-cfy(cf)+1         ! First by year
      cly(25)=MAXVAL(ly(1:nc1))-cfy(cf)+1
      cyr(25)=cly(25)-cfy(25)+1
      cfy(26)=MINVAL(fy(nc1+1:nc))-cfy(cf)+1      ! Second by year
      cly(26)=MAXVAL(ly(nc1+1:nc))-cfy(cf)+1 
      cyr(26)=cly(26)-cfy(26)+1
      num(1:mxy,23:26)=0 ; crn(1:mxy,23:30)=0.D0
      DO i=1,nc          
        p=fy(i)-pth(i) ; q=p+yr(i)-1 ; u=ad(i) ; v=u+yr(i)-1
        s=fy(i)-cfy(cf)+1 ; t=s+yr(i)-1
        IF (i.LE.nc1) THEN
          WHERE (xok(u:v))
            crn(p:q,23)=crn(p:q,23)+fx(u:v)   ! By age
            num(p:q,23)=num(p:q,23)+1
            crn(s:t,25)=crn(s:t,25)+dx(u:v)   ! By year
            num(s:t,25)=num(s:t,25)+1
          END WHERE 
        ELSE
          WHERE (xok(u:v))
            crn(p:q,24)=crn(p:q,24)+fx(u:v)   ! By age
            num(p:q,24)=num(p:q,24)+1
            crn(s:t,26)=crn(s:t,26)+dx(u:v)   ! By year
            num(s:t,26)=num(s:t,26)+1
          END WHERE 
        ENDIF
      ENDDO
      okc(1:mxy,23:26)=num(1:mxy,23:26).GE.1
      DO i=23,26
        p=cfy(i) ; q=cly(i)
        WHERE(okc(p:q,i)) &
          crn(p:q,i)=crn(p:q,i)/DBLE(num(p:q,i))
      ENDDO
      WRITE(19,'(" Rings Cores  Mean SF     SDev   Iter")')
      CALL resc2_pol(ref1,nc1,mna,sda) ; mn=mna ; sd=sda
      cf=2 ; CALL detrend()
      CALL resc2_pol(ref1,nc1,mna,sda) ; mn=mn*mna ; sd=sd*sda
      cf=3 ; CALL detrend()
      CALL resc2_pol(ref1,nc1,mna,sda) ; mn=mn*mna ; sd=sd*sda
      WRITE(19,'("Mean adj",F9.4,"  SDev adj",F9.4)') mn,sd
      nc=nc1
      tre(1:nc)=(/(i,i=1,nc)/)
      CALL write_raw(cnam(3),x)   ! Save adjusted file    
      CALL write_pith(cnam(4))  
      nc=0 ; cf=4
      CALL read_rft(cnam(3))
      CALL read_rft(cnam(2))
      CALL detrend()
      DO i=1,nc          
        p=fy(i)-pth(i) ; q=p+yr(i)-1 ; u=ad(i) ; v=u+yr(i)-1
        s=fy(i)-cfy(cf)+1 ; t=s+yr(i)-1
        IF (i.LE.nc1) THEN
          WHERE (xok(u:v))
            crn(p:q,27)=crn(p:q,27)+fx(u:v)   ! By age
            crn(s:t,29)=crn(s:t,29)+dx(u:v)
          END WHERE 
        ELSE
          WHERE (xok(u:v))
            crn(p:q,28)=crn(p:q,28)+fx(u:v)   ! By year
            crn(s:t,30)=crn(s:t,30)+dx(u:v)
          END WHERE 
        ENDIF
      ENDDO
      DO i=27,30
        p=cfy(i-4) ; q=cly(i-4)
        WHERE(okc(p:q,i-4)) &
          crn(p:q,i)=crn(p:q,i)/DBLE(num(p:q,i-4))
      ENDDO
      CLOSE(19)
      RETURN 
      END SUBROUTINE resc_pol
!-------------------------------------------------------------------
      SUBROUTINE rescale_pol(ref1) 
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1   ! number of sites
      SELECT CASE(ref1)
      CASE(1)  
        cnam(1)="../../raw/polar/poula/poluroot.raw"
        cnam(2)="../../raw/polar/poula/polustem.raw"
        wnam(1)="poluroot.raw"
        wnam(2)="polustem.raw"
        wnam(3)="polurootadj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      CASE(2)  
        cnam(1)="../../raw/polar/poula/poluroot.mxd"
        cnam(2)="../../raw/polar/poula/polustem.mxd"
        wnam(1)="poluroot.mxd"
        wnam(2)="polustem.mxd"
        wnam(3)="polurootadj.mxd"
        wnam(4)="Mean MXD"
        CALL resc_pol(1)
      CASE(3)  
        cnam(1)="../../raw/polar/poula/pou_la_mod.raw"
        cnam(2)="../../raw/polar/poula/pou_la_stem.raw"
        wnam(1)="pou_la_mod.raw"
        wnam(2)="pou_la_stem.raw"
        wnam(3)="pou_la_modadj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      CASE(4)  
        cnam(1)="../../raw/polar/poula/pou_la_mod.mxd"
        cnam(2)="../../raw/polar/poula/pou_la_stem.mxd"
        wnam(1)="pou_la_mod.mxd"
        wnam(2)="pou_la_stem.mxd"
        wnam(3)="pou_la_modadj.mxd"
        wnam(4)="Mean MXD"
        CALL resc_pol(1)
      CASE(5)  
        cnam(1)="../../raw/polar/poula/polustem.raw"
        cnam(2)="../../raw/polar/poula/pou_la_stem.raw"
        wnam(1)="polustem.raw"
        wnam(2)="pou_la_stem.raw"
        wnam(3)="polustemadj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      CASE(6)  
        cnam(1)="../../raw/polar/poula/polustem.mxd"
        cnam(2)="../../raw/polar/poula/pou_la_stem.mxd"
        wnam(1)="polustem.mxd"
        wnam(2)="pou_la_stem.mxd"
        wnam(3)="polustemadj.mxd"
        wnam(4)="Mean MXD"
        CALL resc_pol(1)
      CASE(7)  
        cnam(1)="../../raw/polar/purla/purlax.raw"
        cnam(2)="../../raw/polar/poula/poupolux.raw"
        wnam(1)="purlax.raw"
        wnam(2)="poupolux.raw"
        wnam(3)="purlaxadj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      CASE(8)  
        cnam(1)="../../raw/polar/purla/purlax.mxd"
        cnam(2)="../../raw/polar/poula/poupolux.mxd"
        wnam(1)="purlax.mxd"
        wnam(2)="poupolux.mxd"
        wnam(3)="purlaxadj.mxd"
        wnam(4)="Mean MXD"
        CALL resc_pol(1)
      CASE(9)  
        cnam(1)="../../raw/polar/poula/polurulax.raw"
        cnam(2)="../../raw/polar/poula/pou_la_stem.raw"
        wnam(1)="polurulax.raw"
        wnam(2)="pou_la_stem.raw"
        wnam(3)="polurulaxadj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      CASE(10)  
        cnam(1)="../../raw/polar/poula/polurulax.mxd"
        cnam(2)="../../raw/polar/poula/pou_la_stem.mxd"
        wnam(1)="polurulax.mxd"
        wnam(2)="pou_la_stem.mxd"
        wnam(3)="polurulaxadj.mxd"
        wnam(4)="Mean MXD"
        CALL resc_pol(1)
      CASE(11)  
         cnam(1)="../../raw/polar/purla/purlasi_scm.raw"
        cnam(2)="../../raw/polar/purla/purlasim.raw"
        wnam(1)="purlasi_scm.raw"
        wnam(2)="purlasim.raw"
        wnam(3)="purlasi_scmadj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      CASE(12)  
        cnam(1)="../../raw/polar/purla/purlasi_scm.mxd"
        cnam(2)="../../raw/polar/purla/purlasim.mxd"
        wnam(1)="purlasi_scm.mxd"
        wnam(2)="purlasim.mxd"
        wnam(3)="purlasi_scmadj.mxd"
        wnam(4)="Mean MXD"
        CALL resc_pol(1)
      CASE(13)  
        cnam(1)="../../raw/polar/polar.raw"
        cnam(2)="../../raw/yam/yml-all.raw"
        wnam(1)="polar.raw"
        wnam(2)="yml-all.raw"
        wnam(3)="polaradj.raw"
        wnam(4)="Mean TRW"
        CALL resc_pol(2)
      ENDSELECT 
      RETURN 
      END SUBROUTINE rescale_pol
!------------------------------------------------------------------------
      SUBROUTINE polu_errd()  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=120 ; grb=520
      CALL NAME('z Score','Y')   ! Axis name
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL plot_trees(r,num(1:r,1))  
      CALL tombox(p,q,-2.6D0,6.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue)
      CALL MESSAG("With Roots (count)",grl+700,grt+30)
      CALL thickthin(r,wka(1:r),crn(1:r,1),num(1:r,1),3)
       CALL SETCLR(red)
      CALL MESSAG("No roots",grl+1500,grt+30)
      CALL thickthin(r,wka(1:r),crn(1:r,2),num(1:r,2),3)
      CALL SETCLR(black) ;  CALL ENDGRF() 
      grt=530 ; grb=930
      CALL plot_trees(r,num(1:r,2))  
      CALL tombox(p,q,-2.6D0,6.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue)
      CALL MESSAG("With Roots",grl+700,grt+30)
      CALL thickthin(r,wka(1:r),crn(1:r,7),num(1:r,1),3)
       CALL SETCLR(red)
      CALL MESSAG("No roots (count)",grl+1500,grt+30)
      CALL thickthin(r,wka(1:r),crn(1:r,8),num(1:r,2),3)
      CALL SETCLR(black) ;  CALL ENDGRF() 
      grt=940 ; grb=1340
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      CALL tombox(p,q,0.D0,5.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue)
      CALL MESSAG("StdErr With Roots",grl+700,grt+30)
      CALL thickthin(r,wka(1:r),crn(1:r,5),num(1:r,1),3)
       CALL SETCLR(red)
      CALL MESSAG("StdErr No Roots",grl+1500,grt+30)
      CALL thickthin(r,wka(1:r),crn(1:r,6),num(1:r,2),3)
      CALL SETCLR(black) ;  CALL ENDGRF() 
      RETURN 
      END SUBROUTINE polu_errd 
!-------------------------------------------------------------------
      SUBROUTINE polu_err(ref1)  ! Save output series
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ref1  
      REAL(8)            :: mn,sd
      INTEGER            :: j,p,q,r
      IF (ref1.EQ.1) THEN   ! Mean tree
        cnam(1)="../../raw/ural/polaresp.raw"
        cnam(2)="../../raw/ural/polaresp_nor.raw"
      ELSE                  ! Not mean tree
        cnam(1)="../../raw/ural/urals.raw"
        cnam(2)="../../raw/ural/urals_nor.raw"
      ENDIF 
      DO j=1,2
        nc=0 ; CALL read_rft(cnam(j))
        CALL det_default() ; idt=-2 ; src=1
        cf=j ; CALL detrend()
        p=1600-cfy(j)+1 ; q=cyr(j) ; r=q-p+1
        mn=SUM(crn(p:q,cf))/DBLE(r)    ! Normalise 1600+
        sd=SQRT(SUM((crn(p:q,cf)-mn)**2)/DBLE(r-1))
        r=cyr(cf) ; crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
        crn(1:r,cf+2)=xcsd(1:r,mx)/sd  ! Scaled standard deviation
        WHERE (num(1:r,cf).GE.3) 
          crn(1:r,cf+4)=crn(1:r,cf+2)/(SQRT(DBLE(num(1:r,cf)))/2.D0)
        ELSEWHERE
          crn(1:r,cf+4)=0.D0
        END WHERE
        CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+6))    
      ENDDO
      p=cfy(2)-cfy(1)+1 ; r=cyr(2) ; q=p+r-1
      crn(p:q,2)=crn(1:r,2) ; crn(1:p-1,2)=0.D0
      num(p:q,2)=num(1:r,2) ; num(1:p-1,2)=0
      crn(p:q,4)=crn(1:r,4) ; crn(1:p-1,4)=0.D0
      crn(p:q,6)=crn(1:r,6) ; crn(1:p-1,6)=0.D0
      crn(p:q,8)=crn(1:r,8) ; crn(1:p-1,8)=0.D0
      OPEN(74,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      DO j=1,r
        WRITE(74,'(3I6,6F8.3)') cfy(1)+j-1,num(j,1:2),crn(j,1:6)
      ENDDO
      CLOSE(74)
      RETURN
      END SUBROUTINE polu_err
!--------------------------------------------------------------
      SUBROUTINE Boot_urd()  ! Plots Bootstrap mean and SD
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8),DIMENSION(4)   :: boxx,boxy 
      INTEGER                :: i=1,j=1,k,p,q,r
      grl=200 ; grr=2400 ; grt=150 ; grb=450
      r=cyr(22) ; wka(1:r)=(/(DBLE(i),i=1,r)/) 
      CALL LABELS('NONE','X')
      CALL NAME('','X')            ! Axis name
      CALL NAME('Ring Width','Y')  ! Axis name
      DO j=1,4 
        k=15+j*6
        IF (j.EQ.4) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Ring Age','X')        ! Axis name
        ELSEIF (j.EQ.1) THEN
          CALL MESSAG("RCS curve and Error Range",grl+200,grt-45)
        ENDIF
        CALL plot_treesq(r,num(1:r,k+1),800)  
        CALL tombox(1,cyr(22),0.D0,1.2D0)
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(4) ; CALL HEIGHT(22)
        CALL SETCLR(cyan)
        p=cfy(k+1) ; q=cly(k+1)
        DO i=p,q
           boxx=(/wka(i)-0.5D0,wka(i)+0.5D0,wka(i)+0.5D0,wka(i)-0.5D0/)
           boxy=(/crn(i,k+5),crn(i,k+5),crn(i,k+4),crn(i,k+4)/)
           CALL RLAREA(boxx,boxy,4)
        ENDDO
        CALL LINWID(1) ; CALL SETCLR(red)
        CALL CURVE(wka(p:q),crn(p:q,k+1),q-p+1)
        CALL SETCLR(black)
        CALL MESSAG(wnam(j+10),grl+600,grt+30)
        CALL ENDGRF() ; CALL LINWID(1)
        grt=grt+310 ; grb=grb+310
      ENDDO
      RETURN 
      END SUBROUTINE Boot_urd
!-------------------------------------------------------------------
      SUBROUTINE Boot_ucd()  ! Plots Bootstrap mean and SD
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8),DIMENSION(4)   :: boxx,boxy 
      INTEGER                :: i=1,j=1,k,p,q,r
      grl=200 ; grr=2400 ; grt=150 ; grb=450
      CALL LABELS('NONE','X')
      CALL NAME('','X')            ! Axis name
      CALL NAME('Index value','Y')  ! Axis name
      DO j=1,4 
        k=15+j*6
        IF (j.EQ.4) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')        ! Axis name
        ELSEIF (j.EQ.1) THEN
          CALL MESSAG("Chronology and Error Range",grl+200,grt-45)
        ENDIF
        IF (cfy(k).LT.600) THEN 
          p=600-cfy(k)+1 ; q=cyr(k) ; r=q-p+1
          CALL plot_treesq(1398,num(p:q,k),440)  
          wka(p:q)=(/(DBLE(i),i=600,1996)/) 
        ELSE
          num(1:1398,19)=0
          p=cfy(k)-600+1 ; q=cly(k)-600+1 ; r=cyr(k)
          num(p:q,19)=num(1:r,k)
          CALL plot_treesq(1398,num(1:1398,19),440)  
          p=1 ; q=r
          wka(1:r)=(/(DBLE(i),i=cfy(k),cly(k))/) 
        ENDIF
        CALL tombox(600,1996,0.D0,2.9D0)
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(4) ; CALL HEIGHT(22)
        CALL SETCLR(cyan)
        DO i=p,q
           boxx=(/wka(i)-0.5D0,wka(i)+0.5D0,wka(i)+0.5D0,wka(i)-0.5D0/)
           boxy=(/crn(i,k+3),crn(i,k+3),crn(i,k+2),crn(i,k+2)/)
           CALL RLAREA(boxx,boxy,4)
        ENDDO
        CALL LINWID(1) ; CALL SETCLR(red)
        CALL CURVE(wka(p:q),crn(p:q,k),r)
        CALL SETCLR(black)
        CALL MESSAG(wnam(j+10),grl+600,grt+30)
        CALL ENDGRF() ; CALL LINWID(1)
        grt=grt+310 ; grb=grb+310
      ENDDO
      RETURN 
      END SUBROUTINE Boot_ucd
!-------------------------------------------------------------------
      SUBROUTINE Boot_uc1d()  ! Plots Bootstrap mean and SD
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8),DIMENSION(4)   :: boxx,boxy 
      INTEGER                :: i=1,j=1,k,p,q,r
      grl=200 ; grr=2400 ; grt=150 ; grb=450
      CALL LABELS('NONE','X')
      CALL NAME('','X')            ! Axis name
      CALL NAME('Index value','Y')  ! Axis name
      DO j=1,4 
        k=15+j*6
        IF (j.EQ.4) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')        ! Axis name
        ELSEIF (j.EQ.1) THEN
          CALL MESSAG("Chronology and 1.0 +/- Error Range",grl+200,grt-45)
        ENDIF
        IF (cfy(k).LT.600) THEN 
          p=600-cfy(k)+1 ; q=cyr(k) ; r=q-p+1
          CALL plot_treesq(1398,num(p:q,k),440)  
          wka(p:q)=(/(DBLE(i),i=600,1996)/) 
        ELSE
          num(1:1398,19)=0
          p=cfy(k)-600+1 ; q=cly(k)-600+1 ; r=cyr(k)
          num(p:q,19)=num(1:r,k)
          CALL plot_treesq(1398,num(1:1398,19),440)  
          p=1 ; q=r
          wka(1:r)=(/(DBLE(i),i=cfy(k),cly(k))/) 
        ENDIF
        CALL tombox(600,1996,0.D0,2.9D0)
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(4) ; CALL HEIGHT(22)
        CALL SETCLR(cyan)
        DO i=p,q
           boxx=(/wka(i)-0.5D0,wka(i)+0.5D0,wka(i)+0.5D0,wka(i)-0.5D0/)
           boxy=(/crn(i,k+3)-crn(i,k)+1.D0,crn(i,k+3)-crn(i,k)+1.D0, &
                  crn(i,k+2)-crn(i,k)+1.D0,crn(i,k+2)-crn(i,k)+1.D0/)
           CALL RLAREA(boxx,boxy,4)
        ENDDO
        CALL LINWID(1) ; CALL SETCLR(red)
        CALL CURVE(wka(p:q),crn(p:q,k),r)
        CALL SETCLR(black)
        CALL MESSAG(wnam(j+10),grl+600,grt+30)
        CALL ENDGRF() ; CALL LINWID(1)
        grt=grt+310 ; grb=grb+310
      ENDDO
      RETURN 
      END SUBROUTINE Boot_uc1d
!-------------------------------------------------------------------
      SUBROUTINE Boot_u() ! Bootstrap RCS 
      IMPLICIT NONE                 
      INTEGER               :: w1,w2,st
      INTEGER,DIMENSION(12) :: seed
      INTEGER               :: i,j,k
      seed=12848 ; st=cf
      CALL RANDOM_SEED(put=seed) ! Initialise random sequence
      cnam(11)="../../raw/ural/urals.raw"
      wnam(11)="a) Urals.raw"
      cnam(12)="../../raw/ural/urals_nor.raw"
      wnam(12)="b) Urals_Nor.raw"
      cnam(13)="../../raw/ural/polaresp.raw"
      wnam(13)="c) Polar_Esp.raw"
      cnam(14)="../../raw/ural/polaresp_nor.raw"
      wnam(14)="d) Polar_Esp_Nor.raw"
      OPEN(77,FILE="Urals.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open","Urals.col")) RETURN
      DO j=1,4
        k=15+j*6
        nc=0 ; CALL read_rft(cnam(j+10))       ! Read chronology
        cf=k ; CALL det_crnfy() ; w1=cyr(k) 
        w2=MAXVAL(ly(1:nc)-pth(1:nc)+1)        ! Max RCS years
        cfy(k+1)=MINVAL(fy(1:nc)-pth(1:nc)+1)  ! Min RCS years
        cyr(k+1)=w2 ; cly(k+1)=w2
        CALL Boot_u1(w1,w2,k) 
        WRITE(77,'(A16)') wnam(j+10)(4:20)
        WRITE(77,'("First Age",I4,", Last",I5)') cfy(k+1),cly(k+1)
        WRITE(77,'("Ring Age")')
        WRITE(77,'("RCS Counts")')
        WRITE(77,'("Full Chronology RCS Value")')
        WRITE(77,'("Bootstrap RCS Counts")')
        WRITE(77,'("2.5% Low RCS Value")')
        WRITE(77,'("2.5% High RCS Value")')
        DO i=cfy(k+1),w2
          WRITE (77,'(2I6,F8.3,I6,2F8.3)') &
            i,num(i,k+1),crn(i,k+1),num(i,k+4),crn(i,k+4:k+5)
        ENDDO
        WRITE(77,*)
        WRITE(77,'(A16)') wnam(j+10)(4:20)
        WRITE(77,'("Start",I6,", End",I6,", Years",I6)') &
          cfy(k),cly(k),cyr(k)
        WRITE(77,'("Calendar year")')
        WRITE(77,'("Full Chronology Value")')
        WRITE(77,'("Bootstrap Chronology Counts")')
        WRITE(77,'("2.5% Low Chronology Value")')
        WRITE(77,'("2.5% High Chronology Value")')
        DO i=1,w1
          WRITE (77,'(2I6,F8.3,I6,2F8.3)') &
            cfy(k)-1+i,num(i,k),crn(i,k),num(i,k+2),crn(i,k+2:k+3)
        ENDDO
        WRITE(77,*)
      ENDDO
      CLOSE(77) ; cf=st
      RETURN 
      END SUBROUTINE Boot_u
!------------------------------------------------------------------------
      SUBROUTINE Boot_u1(w1,w2,k) 
      IMPLICIT NONE  ! Bootstrap core selection with replacement               
      INTEGER,INTENT(IN)           :: w1     ! Chronology length
      INTEGER,INTENT(IN)           :: w2     ! RCS curve length
      INTEGER,INTENT(IN)           :: k      ! chronology offset
      REAL(8),DIMENSION(1:w1,25,2) :: bcrn   ! Chronology
      REAL(8),DIMENSION(1:w2,25,2) :: brcs   ! RCS 
      REAL(8),DIMENSION(nc)        :: rrn
      INTEGER,DIMENSION(nc)        :: t1
      REAL(8)                      :: rnc
      INTEGER                      :: i,j,n,p,q,r,s,t,u,v
      rnc=DBLE(nc)
      bcrn(1:w1,1:25,1)=-10.D0 ; bcrn(1:w1,1:25,2)= 10.D0
      brcs(1:w2,1:25,1)=-10.D0 ; brcs(1:w2,1:25,2)= 10.D0
      num(1:w1,k+2)=0 ; num(1:w1,k+4)=0
      DO n=1,1001        !  1000 chronologies with replacement
        IF (n.LT.1001) THEN 
          CALL RANDOM_NUMBER(rrn)  ! Random Uniform
          t1=INT(rrn*rnc)+1
        ELSE
          t1(1:nc)=(/(i,i=1,nc)/)  ! Finallly use all trees
        ENDIF 
        crn(1:w1,k)=0.D0 ; num(1:w1,k)=0 
        crn(1:w2,k+1)=0.D0 ; num(1:w2,k+1)=0 
        DO i=1,nc                  ! Accumulate RCS curve values
          j=t1(i) ; r=yr(j) ; p=ad(j) ; q=p+r-1
          u=fy(j)-pth(j)+1 ; v=u+r-1
          WHERE (xok(p:q))
            crn(u:v,k+1)=crn(u:v,k+1)+x(p:q)
            num(u:v,k+1)=num(u:v,k+1)+1
          END WHERE
        ENDDO
        WHERE (num(1:w2,k+1).GE.1) &   ! Mean and smooth RCS curve
          crn(1:w2,k+1)=crn(1:w2,k+1)/DBLE(num(1:w2,k+1))  
        PD: DO p=1,w2 ; IF (num(p,k+1).GE.1) EXIT PD ; ENDDO PD
        CALL spline3(w2-p+1,crn(p:w2,k+1),num(p:w2,k+1),4,crn(p:w2,k+1),FA)  
        DO i=1,nc       ! Accumulate CRN values
          j=t1(i) ; r=yr(j) ; p=ad(j) ; q=p+r-1   ! Ring address
          u=fy(j)-cfy(k)+1 ; v=u+r-1              ! CRN address 
          s=fy(j)-pth(j)+1 ; t=s+r-1              ! RCS address
          WHERE (xok(p:q))
            crn(u:v,k)=crn(u:v,k)+x(p:q)/crn(s:t,k+1)
            num(u:v,k)=num(u:v,k)+1
          END WHERE
        ENDDO
        WHERE (num(1:w1,k).GT.0)   ! Mean CRN
          crn(1:w1,k)=crn(1:w1,k)/DBLE(num(1:w1,k)) 
        ELSEWHERE
          crn(1:w1,k)=0.D0
        END WHERE
        IF (n.LT.1001) THEN 
          DO i=1,w1      ! CRN values in each year
            IF (num(i,k).GE.1) THEN
              num(i,k+2)=num(i,k+2)+1       ! Count of values
              IF (crn(i,k).GT.bcrn(i,1,1)) THEN  ! High 25
                J1: DO j=2,25
                  IF (crn(i,k).LT.bcrn(i,j,1)) EXIT J1
                ENDDO J1
                IF (j.GT.2) bcrn(i,1:j-2,1)=bcrn(i,2:j-1,1) 
                bcrn(i,j-1,1)=crn(i,k)
              ENDIF
              IF (crn(i,k).LT.bcrn(i,1,2)) THEN ! Low 25
                J2: DO j=2,25
                  IF (crn(i,k).GT.bcrn(i,j,2)) EXIT J2
                ENDDO J2
                IF (j.GT.2) bcrn(i,1:j-2,2)=bcrn(i,2:j-1,2) 
                bcrn(i,j-1,2)=crn(i,k)
              ENDIF
            ENDIF
          ENDDO
          DO i=1,w2      ! RCS values in each year
            IF (num(i,k+1).GE.1) THEN
              num(i,k+4)=num(i,k+4)+1     ! Count of values
              IF (crn(i,k+1).GT.brcs(i,1,1)) THEN  ! High 25
                J3: DO j=2,25
                  IF (crn(i,k+1).LT.brcs(i,j,1)) EXIT J3
                ENDDO J3
                IF (j.GT.2) brcs(i,1:j-2,1)=brcs(i,2:j-1,1) 
                brcs(i,j-1,1)=crn(i,k+1)
              ENDIF
              IF (crn(i,k+1).LT.brcs(i,1,2)) THEN ! Low 25
                J4: DO j=2,25
                  IF (crn(i,k+1).GT.brcs(i,j,2)) EXIT J4
                ENDDO J4
                IF (j.GT.2) brcs(i,1:j-2,2)=brcs(i,2:j-1,2) 
                brcs(i,j-1,2)=crn(i,k+1)
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDDO
      DO i=1,w1
        IF (num(i,k+2).EQ.0) THEN
          crn(i,k+2:k+3)=crn(i,k)
        ELSE
          u=NINT(DBLE(num(i,k+2))/40.D0)
          u=MAX(u,1) ; u=MIN(25,u) ; u=26-u
          crn(i,k+2)=bcrn(i,u,2) ; crn(i,k+3)=bcrn(i,u,1)
        ENDIF
      ENDDO 
      DO i=1,w2
        IF (num(i,k+4).EQ.0) THEN
          crn(i,k+4:k+5)=crn(i,k+1)
        ELSE
          u=NINT(DBLE(num(i,k+4))/40.D0)
          u=MAX(u,1) ; u=MIN(25,u) ; u=26-u
          crn(i,k+4)=brcs(i,u,2) ; crn(i,k+5)=brcs(i,u,1)
        ENDIF
      ENDDO 
      RETURN 
      END SUBROUTINE Boot_u1
!------------------------------------------------------------------------
      SUBROUTINE EPS_prepd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER                :: i=1,p,q,r,u,v
      p=cfy(2) ; q=cly(2)-1 ; r=q-p+1
      u=cfy(1)+p-1 ; v=cfy(1)+q-1
      wka(1:r)=(/(DBLE(i),i=u,v)/) 
      grl=200 ; grr=2400 ; grt=140 ; grb=440
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME('RBar Values','Y')   ! Axis name
      CALL tombox(u,v,0.1D0,0.8D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black)
      CALL line_miss(r,wka(1:r),crn(p:q,8),okc(p:q,8))
      CALL MESSAG("Spline RBar",grl+800,grt+30)
      CALL SETCLR(red)
      CALL line_miss(r,wka(1:r),crn(p:q,11),okc(p:q,8))
      CALL MESSAG("RCS RBar",grl+1300,grt+30)
      CALL SETCLR(black)
      CALL MESSAG(cnam(60),grl+300,grt-45)
      CALL MESSAG(cnam(61),grl+1200,grt-45)
      CALL ENDGRF() 
      grt=450 ; grb=1050
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')               ! Axis name
      CALL NAME('EPS Values','Y')   ! Axis name
      CALL plot_trees(r,num(p:q,1))  
      CALL tombox(u,v,0.7D0,1.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL line_miss(r,wka(1:r),crn(p:q,16),okc(p:q,8))
      CALL MESSAG("Spline EPS",grl+1000,grb-45)
      CALL SETCLR(red) 
      CALL line_miss(r,wka(1:r),crn(p:q,17),okc(p:q,8))
      CALL MESSAG("RCS EPS",grl+1400,grb-45)
      CALL SETCLR(blue)
      CALL line_miss(r,wka(1:r),crn(p:q,19),okc(p:q,8))
      CALL MESSAG("RCS adj eff EPS",grl+1800,grb-45)
      CALL SETCLR(black) ; CALL ENDGRF() 
      RETURN 
      END SUBROUTINE EPS_prepd
!-------------------------------------------------------------------
      SUBROUTINE urals_eps(ref1) ! Urals/Polar/Yamal EPS 
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1
      INTEGER            :: cfs
      cf=21 ; CALL det_default() ; sfo=2 ; idt=-2 
      SELECT CASE (ref1)
      CASE (1) ; cnam(cf)="../../raw/ural/urals.raw"
        wnam(cf)="Urals_TRW" 
      CASE (2) ; cnam(cf)="../../raw/ural/urals_nor.raw"
        wnam(cf)="Urals_TRW_nor" 
      CASE (3) ; cnam(cf)="../../raw/ural/polaresp.raw"
        wnam(cf)="Polar_Esp" 
      CASE (4) ;  cnam(cf)="../../raw/ural/polaresp_nor.raw"
        wnam(cf)="Polar_Esp_nor" 
      CASE (5) ; cnam(cf)="../../raw/polar/polar.raw"
        wnam(cf)="Polar TRW Ratio" 
      CASE (6) ; cnam(cf)="../../raw/polar/polar.mxd"
        wnam(cf)="Polar MXD Ratio"  
      CASE (7) ;  cnam(cf)="../../raw/yam/yml-all.raw"
        wnam(cf)="Yamal TRW ratio"
      CASE (8) ;cnam(cf)="../../raw/yam/yamalad.raw"
        wnam(cf)="Yamal (Briffa 2000)"
      CASE (9) ; cnam(cf)="../../raw/polar/polar.raw"
        wnam(cf)="Polar TRW Norm" 
      CASE (10) ; cnam(cf)="../../raw/polar/polar.mxd"
        wnam(cf)="Polar MXD Norm"  
      CASE (11) ;  cnam(cf)="../../raw/yam/yml-all.raw"
        wnam(cf)="Yamal TRW norm"
     ENDSELECT
      nc=0 ; cfs=cf                ! Store selection
      CALL read_rft(cnam(cf))      ! Read raw data
      cnam(60)=wnam(cf)      
      cnam(62)="EPS_"//TRIM(wnam(cf))//".prn"      
      OPEN(71,FILE=TRIM(cnam(62)),IOSTAT=ios,STATUS="REPLACE")
      IF     (ref1.GE.9.AND.ref1.LE.11) THEN
        src=2 ; srcno=2 ; idb=2    ! Two-curve Normal RCS 
        cnam(61)="Two-Curve, Signal-Free, Normal RCS"      
      ELSEIF (ref1.GE.1.AND.ref1.LE.4) THEN
        src=1 ; srcno=1 ; idb=1    ! Single RCS curve 
        cnam(61)="One-Curve, Signal-Free, Ratio RCS"      
      ELSEIF (ref1.GE.5.AND.ref1.LE.8) THEN
        src=2 ; srcno=2 ; idb=1    ! Two-curve Ratio RCS 
        cnam(61)="Two-Curve, Signal-Free, Ratio RCS"      
      ENDIF
      cf=1 ; CALL EPS_prep1(50)    ! Process data
      CLOSE(71) ; cf=cfs ; idb=1
      RETURN 
      END SUBROUTINE urals_eps
!------------------------------------------------------------------------
      SUBROUTINE py_sitsd(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER                :: i=1,j=1,n,p,q,r
      wnam(31)="All Frequencies"
      wnam(32)="15-yr High Pass"
      wnam(33)="100-15yr Band Pass"
      wnam(34)="100-yr Low Pass"
      grt=180 ; grb=580 ;  grl=240 ; grr=2400 
      r=cyr(ref1) ; p=cfy(ref1) ; q=cly(ref1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      CALL LABELS('NONE','X')
      CALL NAME('','X')        ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL TICKS(0,'X')        ! Y ticks 
      DO j=1,4                 ! Each Figure
        IF (j.EQ.4) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')  ! Axis name
        ENDIF
        CALL NAME(wnam(j+30),'Y')         ! Axis name
        CALL tombox(p,q,-1.9D0,+1.9D0)  
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(blue) ; n=ref1+j*4
        CALL CURVE(wka(1:r),crn(1:r,n),r)
        IF (j.EQ.1) CALL MESSAG("Tree Filter",grl+800,grt-45)
        CALL SETCLR(red)
        IF (j.GT.1) n=ref1+j*4+28
        CALL CURVE(wka(1:r),crn(1:r,n),r)
        IF (j.EQ.1) CALL MESSAG("CRN Filter",grl+1400,grt-45)
        CALL SETCLR(black)
        IF (j.EQ.1) CALL MESSAG(wnam(20+ref1),grl+200,grt-45)
        CALL MESSAG(wnam(24+j),grl+20,grt+30)
        CALL ENDGRF() ; CALL LINWID(1) 
        grt=grt+410 ; grb=grb+410
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL TICKS(10,'X')       ! Y ticks 
      RETURN 
      END SUBROUTINE py_sitsd
!-------------------------------------------------------------------
      SUBROUTINE py_cols()  ! Save output series
      IMPLICIT NONE
      REAL(8),DIMENSION(mxd) :: zx
      INTEGER                :: i,j,k,n,m
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="Yamal TRW"  ; wnam(25)="a)"
      wnam(22)="Polar TRW"  ; wnam(26)="b)"
      wnam(23)="Polar MXD"  ; wnam(27)="c)"
      wnam(24)="Yamalia TRW" ; wnam(28)="d)"
      CALL det_default() ; idt=-2 ; isb=1 ; sfo=2 ; tst=4
      src=2 ; srcno=2 ; idb=2    ! 2 curve RCS detrend - normal dist
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend()
        CALL py_cols2(4)         ! Uses dx 
        IF (i.EQ.1) THEN
          n=ad(nc)+yr(nc)-1      ! Yamal indices added to Yamalia
          zx(1:n)=dx(1:n)
        ELSEIF (i.EQ.2) THEN
          m=ad(nc)+yr(nc)-1      ! Polar indices added to Yamalia
          zx(n+1:n+m)=dx(1:m)
        ENDIF 
      ENDDO
      nc=0 ; CALL read_rft(cnam(1)) 
      CALL read_rft(cnam(2))     ! Read tree data
      cf=4 ; CALL det_crnfy()    ! Set up chronology
      dx(1:n+m)=zx(1:n+m)        ! Use previously saved tree indices  
      CALL arith_mean(dx)        ! Create chronology
      k=cyr(cf) ; crn(1:k,cf)=xcrn(1:k,mx)
      CALL py_cols2(4)           ! Uses dx 
      OPEN(19,FILE="PY_Chrons.prn",IOSTAT=ios,STATUS="REPLACE")
      DO i=1,4
        WRITE(19,'(A12,4A14,"  Filtered Chronology")') &
          wnam(20+i)(1:12),"    Chronology", &
          "    High Pass","    Band Pass","     Low Pass"
        WRITE(19,'("  Year Count",4("  Index   2*SE"),A21)') &
          "   High   Band    Low"
        DO j=1,cyr(i)
          WRITE(19,'(2I6,12F7.3)') j-1+cfy(i),num(j,i),crn(j,4+i), &
            crn(j,20+i),crn(j,8+i),crn(j,24+i),crn(j,12+i), &
            crn(j,28+i),crn(j,16+i),crn(j,32+i), &
            crn(j,36+i),crn(j,40+i),crn(j,44+i)
        ENDDO 
        WRITE(19,*)
      ENDDO
      CLOSE(19) ; idb=1
      RETURN
      END SUBROUTINE py_cols
!--------------------------------------------------------------
      SUBROUTINE py_cols2(off)  ! Save output series
      IMPLICIT NONE
      INTEGER,INTENT(IN)     :: off         ! Offset for derivations
      REAL(8),DIMENSION(mxd) :: zx
      INTEGER,PARAMETER      :: wk=70       ! Working storage offset  
      REAL(8)                :: sd,mn 
      INTEGER                :: i,p,q,r,u,v
      p=off
      crn(1:mxy,wk:wk+12)=0.D0
      num(1:mxy,wk:wk+12)=0
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1   ! Ring address
        u=fy(i)-cfy(cf)+1 ; v=u+r-1   ! Chronology address 
        IF (idb.EQ.1) THEN     ! Ratios
          CALL splinet(r,dx(p:q),100,zx(p:q))      ! 100yr Low Pass   
          tx(p:q)=dx(p:q)/zx(p:q)                  ! Ratio 100yr High Pass
          CALL splinet(r,tx(p:q),15,cx(p:q))       ! 100-15yr Band Pass   
          ax(p:q)=tx(p:q)/cx(p:q)                  ! Ratio 15yr HP
        ELSE                    ! Normal distribution (differences)
          CALL splinet(r,dx(p:q),100,zx(p:q))      ! 100yr Low Pass   
          tx(p:q)=dx(p:q)-zx(p:q)                  ! Difference 100yr High Pass
          CALL splinet(r,tx(p:q),15,cx(p:q))       ! 100-15yr Band Pass   
          ax(p:q)=tx(p:q)-cx(p:q)                  ! Difference 15yr HP
        ENDIF
        WHERE (xok(p:q))
          crn(u:v,wk+1)=crn(u:v,wk+1)+dx(p:q)      ! Full CRN 
          crn(u:v,wk+2)=crn(u:v,wk+2)+dx(p:q)**2
          crn(u:v,wk+4)=crn(u:v,wk+4)+ax(p:q)      ! 15yr High pass 
          crn(u:v,wk+5)=crn(u:v,wk+5)+ax(p:q)**2
          crn(u:v,wk+7)=crn(u:v,wk+7)+cx(p:q)      ! 100-15 Band pass 
          crn(u:v,wk+8)=crn(u:v,wk+8)+cx(p:q)**2
          crn(u:v,wk+10)=crn(u:v,wk+10)+zx(p:q)    ! 100yr Low pass 
          crn(u:v,wk+11)=crn(u:v,wk+11)+zx(p:q)**2
        END WHERE
      ENDDO
      r=cyr(cf)
      WHERE (num(1:r,cf).GE.1) 
        crn(1:r,cf+4)=crn(1:r,wk+1)/DBLE(num(1:r,cf))   ! Chronology  
        crn(1:r,cf+8)=crn(1:r,wk+4)/DBLE(num(1:r,cf))   ! 15yr High pass  
        crn(1:r,cf+12)=crn(1:r,wk+7)/DBLE(num(1:r,cf))  ! 100-15 Band pass  
        crn(1:r,cf+16)=crn(1:r,wk+10)/DBLE(num(1:r,cf)) ! 100yr Low pass   
      END WHERE
      WHERE (num(1:r,cf).GT.3) 
        crn(1:r,cf+20)=SQRT(MAX(crn(1:r,wk+2)-crn(1:r,cf+4)* &  
          crn(1:r,wk+1),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
        crn(1:r,cf+24)=SQRT(MAX(crn(1:r,wk+5)-crn(1:r,cf+8)* &  
          crn(1:r,wk+4),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
        crn(1:r,cf+28)=SQRT(MAX(crn(1:r,wk+8)-crn(1:r,cf+12)* &  
          crn(1:r,wk+7),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
        crn(1:r,cf+32)=SQRT(MAX(crn(1:r,wk+11)-crn(1:r,cf+16)* &  
          crn(1:r,wk+10),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
      END WHERE
      crn(1:r,wk+1)=SQRT(DBLE(num(1:r,cf)))/2.D0
      WHERE (num(1:r,cf).GE.3) 
        crn(1:r,cf+20)=crn(1:r,cf+20)/crn(1:r,wk+1) ! Standard Error
        crn(1:r,cf+24)=crn(1:r,cf+24)/crn(1:r,wk+1) ! Standard Error
        crn(1:r,cf+28)=crn(1:r,cf+28)/crn(1:r,wk+1) ! Standard Error
        crn(1:r,cf+32)=crn(1:r,cf+32)/crn(1:r,wk+1) ! Standard Error
      ELSEWHERE
        crn(1:r,cf+20)=0.D0
        crn(1:r,cf+24)=0.D0
        crn(1:r,cf+28)=0.D0
        crn(1:r,cf+32)=0.D0
      END WHERE
      r=cyr(cf) ; mn=SUM(crn(1:r,cf))/DBLE(r)    ! Normalise full period
      sd=SQRT(SUM((crn(1:r,cf)-mn)**2)/DBLE(r-1))
      IF (idb.EQ.1) THEN     ! Ratios
        CALL splinet(r,crn(1:r,cf),100,crn(1:r,cf+44)) ! 100yr Low Pass   
        crn(1:r,wk)=crn(1:r,cf)/crn(1:r,cf+44)         ! Ratio 100yr High Pass
        CALL splinet(r,crn(1:r,wk),15,crn(1:r,cf+40))  ! 100-15yr Band Pass   
        crn(1:r,cf+36)=crn(1:r,wk)/crn(1:r,cf+40)      ! Ratio 15yr HP
        crn(1:r,cf)=(crn(1:r,cf)-mn)/sd                 
        mn=SUM(crn(1:r,cf+44))/DBLE(r)                 
        crn(1:r,cf+44)=(crn(1:r,cf+44)-mn)/sd          ! Remove mean, rescale by SDev
        mn=SUM(crn(p:q,cf+40))/DBLE(r)                 
        crn(1:r,cf+40)=(crn(1:r,cf+40)-mn)/sd          ! Remove mean, rescale by SDev
        mn=SUM(crn(p:q,cf+36))/DBLE(r)
        crn(1:r,cf+36)=(crn(1:r,cf+36)-mn)/sd          ! Remove mean, rescale by SDev
      ELSE                    ! Differences
        CALL splinet(r,crn(1:r,cf),100,crn(1:r,cf+44)) ! 100yr Low Pass   
        crn(1:r,wk)=crn(1:r,cf)-crn(1:r,cf+44)         ! 100yr High Pass
        CALL splinet(r,crn(1:r,wk),15,crn(1:r,cf+40))  ! 100-15yr Band Pass   
        crn(1:r,cf+36)=crn(1:r,wk)-crn(1:r,cf+40)      ! 15yr HP
      ENDIF
      RETURN
      END SUBROUTINE py_cols2
!--------------------------------------------------------------
      END MODULE yamal2 
