! Copyright (C) 2013, Thomas M. Melvin and Keith R. Briffa, see 
! the GNU General Public License.
      MODULE yamal1    
      USE crustutil
      IMPLICIT NONE
      CHARACTER(30),DIMENSION(fin) :: y1nam
      CONTAINS   
!--------------------------------------------------------
      SUBROUTINE yam1_val()  
      IMPLICIT NONE                 
      y1nam(1:30)= &
       (/"Exit end align                ", &
         "Save this plot                ", &
         "( 3) Fig2 Yamal Sites         ", &
         "( 4) Fig3 2 RCS reset/not     ", &
         "( 5) Fig4 Yamal 1-2-norm      ", &
         "( 6) Fig5 Root or Not         ", &
         "( 7) Fig6 Polar TRW 1-2-norm  ", &
         "( 8) Fig7 Polar Density       ", &
         "( 9) Fig8 All Three detail    ", &
         "(10) Fig9 RCS 1-2-3 Normal    ", &
         "(11) Fig10 Yamal History      ", &
         "(12)                          ", &
         "(13)                          ", &
         "(14)                          ", &
         "(15)                          ", &
         "(16)                          ", &
         "(17)                          ", &
         "(18) PY01 Pol/Yam RCS curve   ", &
         "(19) PY02 End Align Dip       ", &
         "(20) PY10 100yr PY compare    ", &
         "(21) PY11 RCS 1-2-3 Ratio     ", &
         "(22) PY12 Yamal TRW Normal    ", &
         "(23) PY13 Polar TRW Normal    ", &
         "(24) PY14 Polar MXD Normal    ", &
         "(25) PY15  RCS Correlations   ", &
         "(26) PY16  Norm Correlations  ", &
         "(27) PY17 Yam v Pol TRW Norm  ", &
         "(28) PY18 Yam v Pol MXD Norm  ", &
         "(29) PY19 Pol TRW v MXD Norm  ", & 
         "(30) PY20 Filter Trees Cols   "/)
      y1nam(31:60)= &
       (/"(31) P01 Polar Sites 100_yr   ", &
         "(32) P02 Polar 100_yr MXD/TRW ", &
         "(33) P03 Polar Sites RCS      ", &
         "(34) P04 Polar RCS MXD/TRW    ", &
         "(35) P08 Polar Indiv trees    ", &
         "(36) P09 - Individual MXD     ", &
         "(37) P10 TRW 100-yr/sep RCS   ", &
         "(38) P11 MXD 100-yr/sep RCS   ", &
         "(39) P12 sep/1/2 RCS no root  ", &
         "(40) P13 sep/1/2 CRN no root  ", &
         "(41) P14 MXD RCS curves       ", &
         "(42) P15 MXD Chronologies     ", &
         "(43) P16 MXD pou_la_Mod       ", &
         "(44)                          ", &
         "(45)                          ", &
         "(46)                          ", &
         "(47)                          ", & 
         "(48) PC Rep Climate Data      ", &
         "(49) PC1 Climate Figure       ", &
         "(50) PC2 Yam/Pol Filt Ratio   ", &
         "(51) PC3 Yam/Pol Filt Norm    ", &
         "(52) PC4 Yam/Pol Clim Ratio   ", &
         "(53) PC5 Yam/Pol Clim Normal  ", &
         "(54) PC Explain Var Report    ", &
         "(55) PC Climate Data          ", &
         "(56) PC6 Season Plot          ", &
         "(57)                          ", &
         "(58)                          ", &
         "(59)                          ", &
         "(60) E2 Trees - St.Error      "/) 
      y1nam(61:90)= &
       (/"(61) Y1 Yamal Sites 100-yr    ", &
         "(62) Y2 Yamal Separate        ", &
         "(63) Y3 Yamal Sites RCS CRN   ", &
         "(64) Y4 Yamal Indiv Curves    ", &
         "(65) Y5 Khad in RCS curves    ", &
         "(66) Y6 Khad in chrons        ", &
         "(67) Y7 Khad problems         ", &
         "(68) Y9 Yamal 1/2 Site RCS    ", &
         "(69) Y10 Yamal 1/2 Site CRN   ", &
         "(70) Y11 Yamal Stitch 1 RCS   ", &
         "(71) Y12 Yamal Stitch 2 RCS   ", &
         "(72) Y13 Yamal Stitch 3 RCS   ", &
         "(73) Y14 Yamal Grow 3 RCs     ", &
         "(74)                          ", &
         "(75) PY21 Running mean        ", &
         "(76) PY22 Running St.Dev      ", &
         "(77) PY23 Early Yamal detail  ", &
         "(78) PY24 Yamal TRW           ", &
         "(79) PY25 Polar TRW           ", &
         "(80) PY26 Polar MXD           ", &
         "(81) PY27 Fig9 3-Curve RCS    ", &
         "(82) PY30 Yamal Old           ", &
         "(83) PY31 Polar Old           ", &
         "(84)                          ", &
         "(85)                          ", &
         "(86)                          ", &
         "(87)                          ", &
         "(88)                          ", &
         "(89)                          ", &
         "(90) Select Second Yamal Menu "/)
      RETURN 
      END SUBROUTINE yam1_val
!--------------------------------------------------------
      SUBROUTINE yam1v(ref1,plot)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1   ! Chosen action
      INTEGER,INTENT(IN) :: plot   ! Plot number
      INTEGER            :: i
      CALL ERASE() 
      SELECT CASE (ref1)
      CASE (2)    ! Save plot as .ps file
        figm="yamal/ym10"
        CALL open_ps(plot,10)
        SELECT CASE (plot)
          CASE ( 3) ; CALL Fig2d()
          CASE ( 4) ; CALL Fig3d()
          CASE ( 5) ; CALL Fig4d()
          CASE ( 6) ; CALL Fig5d()
          CASE ( 7) ; CALL Fig6d()
          CASE ( 8) ; CALL Fig7d()
          CASE ( 9) ; CALL Fig8d()
          CASE (10) ; CALL Fig9d(1)
          CASE (11) ; CALL Fig10d()
          CASE (18) ; CALL rcs_compd()
          CASE (19) ; CALL end_dipd()
          CASE (20) ; CALL py100_compd()
          CASE (21) ; CALL pol_compd()
          CASE (22:24) ; CALL compnormd() 
          CASE (25:26) ; CALL PY_corrd()
          CASE (27:29) ; CALL pycrnsd(plot-26)
          CASE (30) ; CALL py_colsd()
          CASE (31) ; CALL PU_sep100d()
          CASE (32) ; CALL PU_sep2d()
          CASE (33) ; CALL PU_sepd()
          CASE (34) ; CALL PU_sep2d()
          CASE (35) ; CALL PU_indivd(1)
          CASE (36) ; CALL PU_indivd(2)
          CASE (37) ; CALL UU_sepd(1)
          CASE (38) ; CALL UU_sepd(2)
          CASE (39) ; CALL FigUUrd(1)
          CASE (40) ; CALL FigUUcd(1)
          CASE (41) ; CALL FigUUrd(2)
          CASE (42) ; CALL FigUUcd(2)
          CASE (43) ; CALL FigUUzd()
          CASE (49) ; CALL py_statd()
          CASE (50:51) ; CALL expvard(plot-49)
          CASE (52:53) ; CALL climexpd()
          CASE (54) ; CALL expvrepd()
          CASE (56) ; CALL yseasond()
          CASE (60) ; CALL py_sits2d()
          CASE (61) ; CALL yml_sepd()
          CASE (62) ; CALL yml_sepr3d()
          CASE (63) ; CALL yml_sepd()
          CASE (64) ; CALL yml_seprd()
          CASE (65) ; CALL FigYad(12)
          CASE (66) ; CALL FigYd(12)
          CASE (67) ; CALL yml_khadd()
          CASE (68) ; CALL yml_sepr1d()
          CASE (69) ; CALL yml_sepr2d()
          CASE (70:72) ; CALL yml_stitd()
          CASE (73) ; CALL yml_growthd()
          CASE (75) ; CALL Runmnd()
          CASE (76) ; CALL Runmn1d()
          CASE (77) ; CALL PY25d()
          CASE (78:80) ; CALL PY28d()
          CASE (81) ; CALL Fig9d(2)
          CASE (82) ; CALL yam_oldd()
          CASE (83) ; CALL pol_oldd()
        END SELECT
        CALL plot_psend()
      CASE ( 3) ; CALL Fig2()  ; CALL Fig2d()       ! Yamal Sites
      CASE ( 4) ; CALL Fig3()  ; CALL Fig3d()       ! Yamal 2 RCS curves
      CASE ( 5) ; CALL Fig4()  ; CALL Fig4d()       ! Yamal 1-2-norm
      CASE ( 6) ; CALL Fig5()  ; CALL Fig5d()       ! Root or Not
      CASE ( 7) ; CALL Fig6()  ; CALL Fig6d()       ! Polar Density
      CASE ( 8) ; CALL Fig7()  ; CALL Fig7d()       ! Polar TRW 1-2-norm
      CASE ( 9) ; CALL Fig8() ; CALL Fig8d()        ! Compar 1-2-3-Normal 
      CASE (10) ; CALL Fig9() ; CALL Fig9d(1)       ! Compar 1-2-3-Normal 
      CASE (11) ; CALL Fig10() ; CALL Fig10d()      ! Previous Yamal Fig10
      CASE (18) ; CALL rcs_comp() ; CALL rcs_compd()     ! Compare RCS curves
      CASE (19) ; CALL end_dip()  ; CALL end_dipd()      ! End align dip
      CASE (20) ; CALL py100_comp() ; CALL py100_compd() ! 100yr Spline CRNs
      CASE (21) ; CALL pol_comp() ; CALL pol_compd()     ! Compar 1-2-3 RCS, Ratio 
      CASE (22:24) ; CALL compnorm(ref1-21) ; CALL compnormd()  ! Normal/not compare
      CASE (25:26) ; CALL PY_corr(ref1-24) ; CALL PY_corrd() ! Correlations
      CASE (27:29) ; CALL pycrns() ; CALL pycrnsd(ref1-26)   ! Yam/Pol - climate
      CASE (30) ; CALL py_cols() ; CALL py_colsd()      ! Write Columns
      CASE (31) ; CALL PU_sep100() ; CALL PU_sep100d()  ! Polar separate 100yr 
      CASE (32) ; CALL PU_sep102() ; CALL PU_sep2d()    ! Polar separate 100yr 
      CASE (33) ; CALL PU_sep()    ; CALL PU_sepd()     ! Polar separate means 
      CASE (34) ; CALL PU_sep2()   ; CALL PU_sep2d()    ! Polar separate means 
      CASE (35) ; CALL PU_indiv(1)  ; CALL PU_indivd(1) ! Polar individuals 
      CASE (36) ; CALL PU_indiv(2)  ; CALL PU_indivd(2) ! Polar individuals 
      CASE (37) ; CALL UU_sep100(1) ; CALL UU_sepd(1)   ! Polar TRW sites 
      CASE (38) ; CALL UU_sep100(2) ; CALL UU_sepd(2)   ! Polar TRW sites 
      CASE (39) ; CALL FigUU(1)  ; CALL FigUUrd(1)      ! Polar TRW Sites  
      CASE (40) ; CALL FigUU(1)  ; CALL FigUUcd(1)      ! Polar TRW Sites 
      CASE (41) ; CALL FigUU(2)  ; CALL FigUUrd(2)      ! Polar MXD Sites  
      CASE (42) ; CALL FigUU(2)  ; CALL FigUUcd(2)      ! Polar MXD Sites 
      CASE (43) ; CALL FigUUz()  ; CALL FigUUzd()       ! Polar MXD Sites 
      CASE (48) ; CALL grid_comp()                      ! PY Climate data
      CASE (49) ; CALL py_stat() ; CALL py_statd()      ! Climate data plot
      CASE (50:51) ; CALL expvar(ref1-49) ; CALL expvard(ref1-49) ! Yam/Pol/clim Filter
      CASE (52:53) ; CALL climexp(ref1-51) ; CALL climexpd() ! Yam/Pol - climate
      CASE (54) ; CALL expvrep() ; CALL expvrepd()      ! Explained variance report
      CASE (55) ; CALL climdat()   ! Save JJ and JJA filtered climate data
      CASE (56) ; CALL yseason() ; CALL yseasond()        ! Season plot
      CASE (60) ; CALL py_cols() ; CALL py_sits2d()     ! Write Columns
      CASE (61) ; CALL yml_sep100() ; CALL yml_sepd()   ! Yamal sites 
      CASE (62) ; CALL yml_sep3r() ; CALL yml_sepr3d() ! Yamal Site RCS  
      CASE (63) ; CALL yml_sep()    ; CALL yml_sepd()   ! Yamal sites 
      CASE (64) ; CALL yml_sepr()  ; CALL yml_seprd()   ! Yamal RCS curves 
      CASE (65) ; CALL FigY(12)  ; CALL FigYad(12)      ! Figure 3a
      CASE (66) ; CALL FigY(12)  ; CALL FigYd(12)       ! Figure 3 with KHAD
      CASE (67) ; CALL yml_khad() ; CALL yml_khadd()    ! Yamal - KHAD site 
      CASE (68) ; CALL yml_sep1r() ; CALL yml_sepr1d()  ! Yamal 1/2 RCS curves 
      CASE (69) ; CALL yml_sep1r() ; CALL yml_sepr2d()  ! Yamal 1/2 RCS CRNs 
      CASE (70:72) ; CALL yml_stit(ref1-69) ; CALL yml_stitd() ! Yamal Stiched 
      CASE (73) ; CALL yml_growth()  ; CALL yml_growthd() ! Yamal CRNs by growth rate
      CASE (75) ; CALL Runmn() ; CALL Runmnd()       ! Running Mean 
      CASE (76) ; CALL Runmn() ; CALL Runmn1d()      ! Running Std Dev
      CASE (77) ; CALL PY25() ; CALL PY25d()         ! Yamal details
      CASE (78:80) ; CALL PY28(ref1-77) ; CALL PY28d()
      CASE (81) ; CALL Fig9() ; CALL Fig9d(2)        ! Compar 1-2-3-Normal 
      CASE (82) ; CALL yam_old() ; CALL yam_oldd()   ! Previous Yamal chronologies
      CASE (83) ; CALL pol_old() ; CALL pol_oldd()   ! Previous Polar chronologies
      CASE (90) ; srcok=FA
      END SELECT
      b(272)%ok=TR
      IDO: DO i=1,50
        b(271)%on=TR ; CALL but_draw(272,"")
        CALL mouse_click(3,272,272) ; IF (mous.EQ.272) EXIT IDO
      ENDDO IDO
      b(272)%ok=FA
      RETURN 
      END SUBROUTINE yam1v
!----------------------------------------------------------------
      SUBROUTINE PU_sepx() 
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,r,u,v
      cnam(1)="../../raw/polar/poula/pou_la_mod.raw"
      cnam(21)="TRW Polar Modern"
      cnam(2)="../../raw/polar/poula/pou_la_sub.raw"
      cnam(22)="TRW Polar Sub_fos"
      cnam(3)="../../raw/polar/poula/polurula.raw"
      cnam(23)="TRW Polar Update"
      cnam(4)="../../raw/polar/poula/pou_la_mod.mxd"
      cnam(24)="MXD Polar Modern"
      cnam(5)="../../raw/polar/poula/pou_la_sub.mxd"
      cnam(25)="MXD Polar Sub_fos"
      cnam(6)="../../raw/polar/poula/polurula.mxd"
      cnam(26)="MXD Polar Update"
      nc=0    ! Process TRW
      DO i=1,3
        CALL read_rft(cnam(i)) ; num(i,2)=nc
      ENDDO
      cf=1 ; CALL detrend() ; r=cyr(1) 
      crn(1:r,3:6)=0.D0 ; num(1:r,3:6)=0
      cfy(3:6)=3000 ; cly(3:6)=-1000
      DO i=1,nc
        p=ad(i) ; q=p+yr(i)-1
        u=fy(i)-cfy(1)+1 ; v=u+yr(i)-1
        cfy(3)=MIN(cfy(3),u)
        cly(3)=MAX(cly(3),v)
        WHERE (xok(p:q))         ! Full chronology
          crn(u:v,3)=crn(u:v,3)+dx(p:q)
          num(u:v,3)=num(u:v,3)+1
        END WHERE
        IF (i.LE.num(1,2)) THEN
          WHERE (xok(p:q))       ! Polar Modern
            crn(u:v,4)=crn(u:v,4)+dx(p:q)
            num(u:v,4)=num(u:v,4)+1
          END WHERE
          cfy(4)=MIN(cfy(4),u)
          cly(4)=MAX(cly(4),v)
        ELSEIF (i.LE.num(2,2)) THEN
          WHERE (xok(p:q))       ! Polar Sub-fos
            crn(u:v,5)=crn(u:v,5)+dx(p:q)
            num(u:v,5)=num(u:v,5)+1
          END WHERE
          cfy(5)=MIN(cfy(5),u)
          cly(5)=MAX(cly(5),v)
        ELSE
          WHERE (xok(p:q))       ! Polar update
            crn(u:v,6)=crn(u:v,6)+dx(p:q)
            num(u:v,6)=num(u:v,6)+1
          END WHERE
          cfy(6)=MIN(cfy(6),u)
          cly(6)=MAX(cly(6),v)
        ENDIF
      ENDDO
      cyr(3:6)=cly(3:6)-cfy(3:6)+1
      okc(1:r,3:6)=num(1:r,3:6).GE.1
      DO i=3,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        WHERE (okc(p:q,i)) &
          crn(p:q,i)=crn(p:q,i)/DBLE(num(p:q,i)) 
      ENDDO
      nc=0   ! Process MXD
      DO i=4,6
        CALL read_rft(cnam(i)) ; num(i,2)=nc
      ENDDO
      cf=11 ; CALL detrend()
      r=cyr(11) 
      crn(1:r,13:16)=0.D0 ; num(1:r,13:16)=0
      cfy(13:16)=3000 ; cly(13:16)=-1000
      DO i=1,nc
        p=ad(i) ; q=p+yr(i)-1
        u=fy(i)-cfy(11)+1 ; v=u+yr(i)-1
        cfy(13)=MIN(cfy(13),u)
        cly(13)=MAX(cly(13),v)
        WHERE (xok(p:q))         ! Full chronology
          crn(u:v,13)=crn(u:v,13)+dx(p:q)
          num(u:v,13)=num(u:v,13)+1
        END WHERE
        IF (i.LE.num(1,2)) THEN
          WHERE (xok(p:q))       ! Polar Modern
            crn(u:v,14)=crn(u:v,14)+dx(p:q)
            num(u:v,14)=num(u:v,14)+1
          END WHERE
          cfy(14)=MIN(cfy(14),u)
          cly(14)=MAX(cly(14),v)
        ELSEIF (i.LE.num(2,2)) THEN
          WHERE (xok(p:q))       ! Polar Sub-fos
            crn(u:v,15)=crn(u:v,15)+dx(p:q)
            num(u:v,15)=num(u:v,15)+1
          END WHERE
          cfy(15)=MIN(cfy(15),u)
          cly(15)=MAX(cly(15),v)
        ELSE
          WHERE (xok(p:q))       ! Polar update
            crn(u:v,16)=crn(u:v,16)+dx(p:q)
            num(u:v,16)=num(u:v,16)+1
          END WHERE
          cfy(16)=MIN(cfy(16),u)
          cly(16)=MAX(cly(16),v)
        ENDIF
      ENDDO
      cyr(13:16)=cly(13:16)-cfy(13:16)+1
      okc(1:r,13:16)=num(1:r,13:16).GE.1
      DO i=13,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        WHERE (okc(p:q,i)) &
          crn(p:q,i)=crn(p:q,i)/DBLE(num(p:q,i)) 
      ENDDO
      RETURN 
      END SUBROUTINE PU_sepx
!------------------------------------------------------------------------
      SUBROUTINE PU_sep2d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r
      p=cfy(4)+cfy(1)-1 ; q=cly(4)+cfy(1)-1 ; r=cyr(4)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=600
      CALL plot_trees(r,num(cfy(4):cly(4),4))  
      CALL NAME('','X')
      CALL NAME('z-score','Y')   ! Axis name
      CALL tombox(p,q,-2.4D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      p=cfy(4) ; q=cly(4) ; r=cyr(4)
      CALL MESSAG("(Polar Modern counts)",grl+1500,grt+30)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(p:q,24),num(p:q,4),3)
      CALL MESSAG("a) "//cnam(21),grl+100,grt+30)
      CALL SETCLR(red)
      CALL thickthin(r,wka(1:r),crn(p:q,34),num(p:q,14),3)
      CALL MESSAG(cnam(24),grl+800,grt+30)
      CALL SETCLR(black)
      CALL MESSAG(cnam(30),grl+600,grt-40)
      CALL ENDGRF() 

      p=cfy(5)+cfy(1)-1 ; q=cly(5)+cfy(1)-1 ; r=cyr(5)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=700 ; grb=1150
      CALL plot_trees(r,num(cfy(5):cly(5),5))  
      CALL tombox(p,q,-2.4D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      p=cfy(5) ; q=cly(5) ; r=cyr(5)
      CALL MESSAG("(Polar Sub-fossil counts)",grl+1500,grt+30)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(p:q,25),num(p:q,5),3)
      CALL MESSAG("b) "//cnam(22),grl+100,grt+30)
      CALL SETCLR(red)
      CALL thickthin(r,wka(1:r),crn(p:q,35),num(p:q,15),3)
      CALL MESSAG(cnam(25),grl+800,grt+30)
      CALL SETCLR(black) ; CALL ENDGRF() 

      p=cfy(6)+cfy(1)-1 ; q=cly(6)+cfy(1)-1 ; r=cyr(6)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=1250 ; grb=1700
      CALL plot_trees(r,num(cfy(6):cly(6),6))  
      CALL NAME('Calendar Year','X')
      CALL tombox(p,q,-2.4D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      p=cfy(6) ; q=cly(6) ; r=cyr(6)
      CALL MESSAG("(Polar Update counts)",grl+1500,grt+30)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(p:q,26),num(p:q,6),3)
      CALL MESSAG("c) "//cnam(23),grl+100,grt+30)
      CALL SETCLR(red)
      CALL thickthin(r,wka(1:r),crn(p:q,36),num(p:q,16),3)
      CALL MESSAG(cnam(26),grl+800,grt+30)
      CALL SETCLR(black) ; CALL ENDGRF()
      RETURN 
      END SUBROUTINE PU_sep2d
!-------------------------------------------------------------------
      SUBROUTINE PU_sep2() 
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,r
      REAL(8)  :: mn,sd,nr
      cnam(30)="One-curve Signal-free RCS" 
      CALL det_default()
      sfo=1 ; idt=-2  ! RCS - Sig free OFF
      CALL PU_sepx()
      DO i=4,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        nr=DBLE(COUNT(okc(p:q,i)))
        mn=SUM(crn(p:q,i),MASK=okc(p:q,i))/nr                 
        sd=SQRT(SUM((crn(p:q,i)-mn)**2,MASK=okc(p:q,i))/(nr-1.D0))
        crn(p:q,i+20)=(crn(p:q,i)-mn)/sd
        CALL spline_miss(r,crn(p:q,i+20),10,crn(p:q,i+20),okc(p:q,i))
      ENDDO
      DO i=14,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        nr=DBLE(COUNT(okc(p:q,i)))
        mn=SUM(crn(p:q,i),MASK=okc(p:q,i))/nr                 
        sd=SQRT(SUM((crn(p:q,i)-mn)**2,MASK=okc(p:q,i))/(nr-1.D0))
        crn(p:q,i+20)=(crn(p:q,i)-mn)/sd
        CALL spline_miss(r,crn(p:q,i+20),10,crn(p:q,i+20),okc(p:q,i))
      ENDDO
      RETURN 
      END SUBROUTINE PU_sep2
!------------------------------------------------------------------------
      SUBROUTINE PU_sep100d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r
      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(p,q,0.3D0,2.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(4) ; q=cly(4) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,4),num(p:q,4),3)
      CALL MESSAG(cnam(21)(5:20),grl+500,grt-45)
      CALL SETCLR(blue) ; p=cfy(5) ; q=cly(5) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,5),num(p:q,5),3)
      CALL MESSAG(cnam(22)(5:20),grl+1000,grt-45)
      CALL SETCLR(red) ; p=cfy(6) ; q=cly(6) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,6),num(p:q,6),3)
      CALL MESSAG(cnam(23)(5:20),grl+1500,grt-45)
      CALL SETCLR(black)
      CALL MESSAG("a) TRW 100-year Spline",grl+1000,grt+30)
      CALL ENDGRF() 
 
      p=cfy(11) ; q=cly(11) ; r=cyr(11)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grt=560 ; grb=960
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      CALL tombox(p,q,0.68D0,1.2D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(14) ; q=cly(14) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,14),num(p:q,14),3)
      CALL SETCLR(blue) ; p=cfy(15) ; q=cly(15) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,15),num(p:q,15),3)
      CALL SETCLR(red) ; p=cfy(16) ; q=cly(16) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,16),num(p:q,16),3)
      CALL SETCLR(black)
      CALL MESSAG("b) MXD 100-year Spline",grl+1000,grt+30)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE PU_sep100d
!-------------------------------------------------------------------
      SUBROUTINE PU_sep100() 
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,r
      cnam(30)="100-year Spline, Sig free ON" 
      CALL det_default()
      sfo=2 ; idt=100    ! 100-yr spline, sig-free ON
      CALL PU_sepx()
      DO i=3,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL spline_miss(r,crn(p:q,i),10,crn(p:q,i),okc(p:q,i))
      ENDDO
      DO i=13,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL spline_miss(r,crn(p:q,i),10,crn(p:q,i),okc(p:q,i))
      ENDDO
      RETURN 
      END SUBROUTINE PU_sep100
!------------------------------------------------------------------------
      SUBROUTINE PU_sep102() 
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,r
      REAL(8)  :: mn,sd,nr
      cnam(30)="100-year Spline, Sig free ON" 
      CALL det_default()
      sfo=2 ; idt=100  ! 100-yr spline, sig-free on
      CALL PU_sepx()
      DO i=4,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        nr=DBLE(COUNT(okc(p:q,i)))
        mn=SUM(crn(p:q,i),MASK=okc(p:q,i))/nr                 
        sd=SQRT(SUM((crn(p:q,i)-mn)**2,MASK=okc(p:q,i))/(nr-1.D0))
        crn(p:q,i+20)=(crn(p:q,i)-mn)/sd
        CALL spline_miss(r,crn(p:q,i+20),10,crn(p:q,i+20),okc(p:q,i))
      ENDDO
      DO i=14,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        nr=DBLE(COUNT(okc(p:q,i)))
        mn=SUM(crn(p:q,i),MASK=okc(p:q,i))/nr                 
        sd=SQRT(SUM((crn(p:q,i)-mn)**2,MASK=okc(p:q,i))/(nr-1.D0))
        crn(p:q,i+20)=(crn(p:q,i)-mn)/sd
        CALL spline_miss(r,crn(p:q,i+20),10,crn(p:q,i+20),okc(p:q,i))
      ENDDO
      RETURN 
      END SUBROUTINE PU_sep102
!------------------------------------------------------------------------
      SUBROUTINE yml_sep100() 
      IMPLICIT NONE                 
      INTEGER,PARAMETER :: st=12  ! number of sites
      INTEGER  :: i,p,q,r
      cnam(30)="a) 100-year Spline, Sig free ON" 
      CALL det_default()
      sfo=2 ; idt=100    ! 100-yr spline, sig-free OFF
      CALL yml_sepx(st)
      DO i=1,st
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL spline_miss(r,crn(p:q,i),10,crn(p:q,i+2*st),okc(p:q,i))
      ENDDO
      RETURN 
      END SUBROUTINE yml_sep100
!------------------------------------------------------------------------
      SUBROUTINE yml_growthd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      INTEGER,DIMENSION(4) :: col
      col=(/blue,red,cyan,black/)
      w=cly(5) ; wka(1:w)=(/(DBLE(i),i=1,w)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL NAME('Ring Age','X')
      CALL NAME('Ring Width','Y')    ! Axis name
      CALL plot_trees(w,mcnt(1:w,mx))  
      CALL tombox(1,w,0.D0,1.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=2,5
        CALL SETCLR(col(i-1))
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),7)
        CALL MESSAG(wnam(i),grl+i*550-1000,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("a) Three-curve RCS, Sig-free",grl+1000,grt+30)
      CALL ENDGRF() 

      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grt=700 ; grb=1050
      p=1-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')    ! Axis name
      CALL plot_trees(r,num(p:q,1))  
      CALL tombox(1,cly(1),0.3D0,2.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=6,8
        CALL SETCLR(col(i-5))
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),7)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) Chronology means 1.0",grl+1000,grt+30)
      CALL ENDGRF() 

      grt=1060 ; grb=1410
      p=1-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 
      CALL NAME('Index Value','Y')    ! Axis name
      CALL plot_trees(r,num(p:q,1))  
      CALL tombox(1,cly(1),0.3D0,2.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=6,8
        CALL SETCLR(col(i-5))
        CALL thickthin(r,wka(p:q),crn(p:q,i+10),num(p:q,i),7)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("c) Chronology Means Reset",grl+1000,grt+30)
      CALL ENDGRF()

      grt=1420 ; grb=1770
      p=1-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 
      CALL LABELS('FLOAT','X')
      CALL LABDIG(-1,'Y')
      CALL NAME('Calendar Year','X')
      CALL NAME('Index Value','Y')    ! Axis name
      CALL tombox(1,cly(1),0.D0,70.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=6,8
        CALL SETCLR(col(i-5))
!        CALL CURVE(wka(p:q),DBLE(num(p:q,i)),r)
        CALL thickthin(r,wka(p:q),DBLE(num(p:q,i+10)),num(p:q,i),7)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("d) Sample Counts Each RCS Curve",grl+1000,grt+28)
      CALL LABDIG(-1,'Y')
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE yml_growthd
!-------------------------------------------------------------------
      SUBROUTINE yml_growth() 
      IMPLICIT NONE                 
      INTEGER  :: i,j,k,p,q,r,w
      cnam(30)="R" 
      cnam(1)="../../raw/yam/yml-all.raw" ; cnam(26)="Yamal Long"
      wnam(2)="Slowest Growth"
      wnam(3)="Medium Growth"
      wnam(4)="Fastest Growth"
      wnam(5)="All trees"
      wnam(6)="Slowest Growth"
      wnam(7)="Medium Growth"
      wnam(8)="Fastest Growth"
      CALL det_default() 
      CDsp=50                    ! Chronology Smoothing
      tst=4 ; sfo=2              ! Sort on growth rate 
      idt=-2 ; src=2 ; srcno=3   ! 3 curve RCS, SF=on  
      nc=0 ; CALL read_rft(cnam(1)) 
      DO k=1,11,10
        IF (k.NE.1) gtr=2        ! Reset means
        cf=k ; CALL detrend()  
        w=cyr(k) ; crn(1:w,k+1:k+7)=0.D0 ; num(1:w,k+1:k+7)=0
        DO j=2,5
          IF (j.EQ.5) THEN 
            i=mx
          ELSE
            i=j-1
          ENDIF
          p=sfy(i) ; q=sly(i) ; r=q-p+1
          cfy(j+k-1)=p ; cly(j+k-1)=q ; cyr(j+k-1)=r 
          crn(1:q,j+k-1)=mval(1:q,i)  ! Store RCS curves and counts
          num(1:q,j+k-1)=mcnt(1:q,i)
          okc(1:q,j+k-1)=mok(1:q,i)
          IF (j.LT.5) THEN
            crn(1:w,j+3+k)=xcsm(1:w,i)  ! Store Smoothed CRN and counts
            num(1:w,j+3+k)=xnum(1:w,i)
            okc(1:w,j)=cok(1:w,i)
          ENDIF
        ENDDO
      ENDDO 
      RETURN 
      END SUBROUTINE yml_growth
!------------------------------------------------------------------------
      SUBROUTINE yml_sepd()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=12  ! number of sites
      INTEGER,PARAMETER      :: fr=1601, to=2005
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r
      p=cfy(st+1) ; q=cly(st+1) ; r=cyr(st+1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')        ! Axis name
      CALL tombox(fr,to,0.D0,3.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i+20)(1:3),grl+i*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(30),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=560 ; grb=960
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')    ! Axis name
      CALL tombox(fr,to,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) As above but 10-year Smoothed",grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE yml_sepd
!-------------------------------------------------------------------
      SUBROUTINE yml_sepx(st) 
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)      :: st     ! number of sites
      INTEGER,DIMENSION(0:st) :: sit    ! site tree address
      INTEGER  :: i,j,p,q,r,u,v
      CALL read_yml(st,sit)
      cf=st+1 ; CALL detrend() ; r=cyr(st+1)   ! st+1 = full chronology
      crn(1:r,1:st)=0.D0 ; num(1:r,1:st)=0
      cfy(1:st)=3000 ; cly(1:st)=-1000
      DO j=1,st                      ! For each site
        DO i=sit(j-1)+1,sit(j)       ! For each tree at site 
          p=ad(i) ; q=p+yr(i)-1
          u=fy(i)-cfy(cf)+1 ; v=u+yr(i)-1
          cfy(j)=MIN(cfy(j),u)
          cly(j)=MAX(cly(j),v)
          WHERE (xok(p:q))         ! Full chronology
            crn(u:v,j)=crn(u:v,j)+dx(p:q)
            num(u:v,j)=num(u:v,j)+1
          END WHERE
        ENDDO
      ENDDO
      cyr(1:st)=cly(1:st)-cfy(1:st)+1
      okc(1:r,1:st)=num(1:r,1:st).GE.1
      DO j=1,st
        p=cfy(j) ; q=cly(j) ; r=q-p+1
        WHERE (okc(p:q,j)) &
          crn(p:q,j)=crn(p:q,j)/DBLE(num(p:q,j)) 
      ENDDO
      RETURN 
      END SUBROUTINE yml_sepx
!------------------------------------------------------------------------
      SUBROUTINE yml_sep() 
      IMPLICIT NONE                 
      INTEGER,PARAMETER :: st=12  ! number of sites
      INTEGER  :: i,p,q,r
      cnam(30)="a) One-curve Signal-free RCS" 
      CALL det_default()
      sfo=2 ; idt=-2              ! RCS - Sig free ON 
      CALL yml_sepx(st)
      DO i=1,st
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL spline_miss(r,crn(p:q,i),20,crn(p:q,i+2*st),okc(p:q,i))
      ENDDO
      RETURN 
      END SUBROUTINE yml_sep
!------------------------------------------------------------------------
      SUBROUTINE yml_seprd()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=12  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      w=MAXVAL(cly(1:st)) ; wka(1:w)=(/(DBLE(i),i=1,w)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=650
      CALL LABELS('FLOAT','X')
      CALL NAME('Ring Age','X')
      CALL NAME('Sample Counts','Y')      ! Axis name
      CALL tombox(1,400,0.D0,30.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=MIN(cly(i),400) ; r=q-p+1
        CALL thickthin(r,wka(p:q),DBLE(num(p:q,i)),num(p:q,i),3)
        CALL MESSAG(wnam(i+20)(1:3),grl+i*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) Counts by Age",grl+600,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=800 ; grb=1300
      wka(1:cyr(35))=(/(DBLE(i),i=cfy(35),cly(35))/) 
      CALL NAME('Calendar Year','X')
      CALL NAME('Sample Counts','Y')        ! Axis name
      CALL tombox(1600,2006,0.D0,30.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=st+1,st+st
        CALL SETCLR(i-st)
        p=MAX(cfy(i),1600-cfy(35)+1) ; q=cly(i) ; r=q-p+1
        CALL thickthin(r,wka(p:q),DBLE(num(p:q,i)),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("c) Counts by Year",grl+600,grt+30)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE yml_seprd
!-------------------------------------------------------------------
      SUBROUTINE yml_sepr() 
      IMPLICIT NONE                 
      INTEGER,PARAMETER       :: st=12  ! number of sites
      INTEGER,DIMENSION(0:st) :: sit    ! site tree address
      INTEGER  :: i,p,q,r
      CALL read_yml(st,sit)
      CALL det_default()
      sfo=2 ; idt=-2 ; src=1 ! Simple RCS - Sig free ON
      crn(1:3000,1:st)=0.D0 ; num(1:3000,1:st)=0  
      DO i=1,st               ! Process each site separately
        nc=0 ; cf=st+i                 
        CALL read_rft(cnam(i))
        CALL detrend()  
        p=sfy(mx) ; q=sly(mx) ; r=q-p+1
        cfy(i)=p ; cly(i)=q ; cyr(i)=r
        crn(p:q,i)=msmo(p:q,mx)       ! Smoothed RCS curve
        num(p:q,i)=mcnt(p:q,mx)       ! RCS Counts
      ENDDO
      cfy(35)=MINVAL(cfy(st+1:st+st))
      cly(35)=MAXVAL(cly(st+1:st+st))
      cyr(35)=cly(35)-cfy(35)+1

      DO i=st+1,st+st
        r=cyr(i) ; p=cfy(i)-cfy(35)+1 ; q=p+r-1
        num(p:q,i)=num(1:r,i)
        num(1:p-1,i)=0
        cfy(i)=p ; cly(i)=q
      ENDDO
      OPEN(19,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      WRITE(19,'("Name    Start  End")')
      DO i=1,st
        WRITE(19,'(A8,2I5)') wnam(i+20)(1:8),cfy(i),cly(i)
      ENDDO 
      WRITE(19,*) 
      WRITE(19,'("Column 1     = Ring Age")')
      WRITE(19,'("Column 2-13  = Site RCS sample counts")')

      WRITE(19,'("Column 14-25 = Site smoothed RCS curve")')
      r=MAXVAL(cly(1:st))
      DO i=1,r
        WRITE(19,'(13I4,22F7.3)') i,num(i,1:st),crn(i,1:st)
      ENDDO
      WRITE(19,*) 
      WRITE(19,'("Column 1     = Calendar Year")')
      WRITE(19,'("Column 2-13  = Site sample counts")')
      r=cyr(35)
      WRITE(19,'(4I6)') cfy(35),cly(35),cyr(35),r
      DO i=1,r
        WRITE(19,'(I6,12I4)') i+cfy(35)-1,num(i,st+1:st+st)
      ENDDO
      RETURN 
      END SUBROUTINE yml_sepr
!------------------------------------------------------------------------
      SUBROUTINE yml_sepr1d()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=11  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      w=MAXVAL(cly(1:st))
      wka(1:w)=(/(DBLE(i),i=1,w)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME('Ring Width','Y')    ! Axis name
      CALL tombox(1,w,0.D0,1.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i+20)(1:3),grl+i*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("a) One-curve RCS Site Curves",grl+800,grt+50)
      CALL ENDGRF()

      grt=560 ; grb=960
      CALL LABELS('FLOAT','X')
      CALL NAME('Ring Age','X')
      CALL tombox(1,w,0.D0,1.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) Two-curve Site RCS Curves",grl+800,grt+50)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE yml_sepr1d
!-------------------------------------------------------------------
      SUBROUTINE yml_sep1r()   ! 1 RCS curve
      IMPLICIT NONE                 
      INTEGER,PARAMETER        :: st=11  ! number of sites
      INTEGER,DIMENSION(0:st)  :: sit    ! site tree address
      REAL(8),DIMENSION(mxd)   :: qx     ! Raw data storage
      REAL(8),DIMENSION(mxd)   :: yx     ! Raw data storage
      INTEGER  :: i,j,k1,k2,k3,p,q,r,s,t,u,v,w
      CALL read_yml(st,sit)
      CALL det_default()
      cf=80 ; sfo=2 ; idt=-2     ! RCS - Sig free ON
      src=1 ; srcno=1
      CALL detrend()             ! 1 RCS curve   
      j=ad(nc)+yr(nc)-1       
      yx(1:j)=dx(1:j)
      qx(1:j)=fx(1:j)
      src=2 ; srcno=2
      CALL detrend()             ! 2 RCS curve   
      w=cyr(cf)
      crn(1:w,1:st*4)=0.D0 ; num(1:w,1:st*4)=0  
      cfy(1:st*2)=w ; cly(1:st*2)=-w  
      DO i=1,st                          ! Each sites
        k1=i+st ; k2=k1+st ; k3=k2+st
        DO j=sit(i-1)+1,sit(i)           ! Each tree at site
          p=ad(j) ; r=yr(j) ; q=p+r-1    ! Ring address 
          u=fy(j)-cfy(cf)+1 ; v=u+r-1    ! Chronology address
          s=fy(j)-pth(j)+1  ; t=s+r-1    ! RCS address
          cfy(i)=MIN(cfy(i),s)
          cly(i)=MAX(cly(i),t)
          cfy(k1)=MIN(cfy(k1),u)
          cly(k1)=MAX(cly(k1),v)
          WHERE (xok(p:q))
            crn(s:t,i)=crn(s:t,i)+qx(p:q)    ! Signal-free measures
            crn(s:t,k2)=crn(s:t,k2)+fx(p:q)  ! Signal-free measures
            num(s:t,i)=num(s:t,i)+1
            crn(u:v,k1)=crn(u:v,k1)+yx(p:q)  ! Tree indices
            crn(u:v,k3)=crn(u:v,k3)+dx(p:q)  ! Tree indices
            num(u:v,k1)=num(u:v,k1)+1
          END WHERE
        ENDDO
      ENDDO
      cyr(1:st*2)=cly(1:st*2)-cfy(1:st*2)+1 
      WHERE (num(1:w,1:st).GT.1)           ! Mean vaues
        crn(1:w,1:st)=crn(1:w,1:st)/DBLE(num(1:w,1:st))
        crn(1:w,1+st*2:st*3)=crn(1:w,1+st*2:st*3)/DBLE(num(1:w,1:st))
      END WHERE
      WHERE (num(1:w,st+1:2*st).GT.1)           ! Mean vaues
        crn(1:w,st+1:2*st)=crn(1:w,st+1:2*st)/DBLE(num(1:w,st+1:2*st))
        crn(1:w,1+st*3:4*st)=crn(1:w,1+st*3:4*st)/DBLE(num(1:w,st+1:2*st))
      END WHERE
      DO i=1,st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! Age-dep RCS smoothing
        CALL spline3(r,crn(p:q,i),num(p:q,i),10,crn(p:q,i),FA)  
        CALL spline3(r,crn(p:q,i+2*st),num(p:q,i),10,crn(p:q,i+2*st),FA)  
      ENDDO 
      DO i=st+1,2*st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! 20-year spline smoothing
        CALL splinet(r,crn(p:q,i),20,crn(p:q,i))
        CALL splinet(r,crn(p:q,i+2*st),20,crn(p:q,i+2*st))
      ENDDO 
      OPEN(19,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      r=cyr(cf) 
      WRITE(19,'("Name    Start  End")')
      DO i=1,20
        WRITE(19,'(A8,2I5)') cnam(i+20)(1:8),cfy(i),cly(i)
      ENDDO 
      WRITE(19,*) 
      WRITE(19,'("Column 1     = Ring Age")')
      WRITE(19,'("Column 2-11  = Site sample counts")')
      WRITE(19,'("Column 12-21 = Site mean ring width by age")')
      WRITE(19,'("Column 22-31 = Site smoothed RCS curve")')
      DO i=1,r
        WRITE(19,'(I6,11I4,22F7.3)') i,num(i,1:st),crn(i,1:2*st)
      ENDDO
      WRITE(19,*) 
      DO i=1,r
        WRITE(19,'(I6,11I4,22F7.3)') i,num(i,1:st),crn(i,1+2*st:4*st)
      ENDDO
      CLOSE(19)
      RETURN 
      END SUBROUTINE yml_sep1r
!------------------------------------------------------------------------
      SUBROUTINE yml_sepr2d()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=11  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      w=cyr(cf)
      wka(1:w)=(/(DBLE(i),i=cfy(cf),cly(cf))/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=st+1,st+st
        CALL SETCLR(i-st)
        p=MAX(cfy(i),1600-cfy(cf)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i+20-st)(1:3),grl+(i-st)*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("a) One-curve RCS Site Chronologies",grl+200,grt+30)
      CALL ENDGRF()
      grt=560 ; grb=960
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=st+1,st+st
        CALL SETCLR(i-st)
        p=MAX(cfy(i),1600-cfy(cf)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) Two-curve RCS Site Chronologies",grl+200,grt+30)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE yml_sepr2d
!-------------------------------------------------------------------
      SUBROUTINE yml_sepr3d()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=12  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,s,t,w
      w=MAXVAL(cly(1:st))
      wka(1:w)=(/(DBLE(i),i=1,w)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL NAME('Ring Age','X')
      CALL NAME('Ring Width','Y')    ! Axis name
      CALL tombox(1,w,0.D0,1.8D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i+20)(1:3),grl+i*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(41),grl+500,grt+30)
      CALL ENDGRF() 

      w=2006-1600+1 ; wka(1:w)=(/(DBLE(i),i=1600,2006)/) 
      grt=700 ; grb=1100
      CALL NAME('Calendar Year','X')
      CALL NAME('Index Values','Y')    ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=st+1,st+st
        CALL SETCLR(i-st)
        p=MAX(1600,cfy(i))-cfy(i)+1 ; q=cyr(i) ; r=q-p+1
        s=cfy(i)-1600+p ; t=s+r-1
        CALL thickthin(r,wka(s:t),crn(p:q,i),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl+500,grt+30)
      CALL MESSAG(cnam(43),grl+1200,grt+30)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE yml_sepr3d
!-------------------------------------------------------------------
      SUBROUTINE yml_sep3r() 
      IMPLICIT NONE                 
      INTEGER,PARAMETER       :: st=12  ! number of sites
      INTEGER,DIMENSION(0:st) :: sit    ! site tree address
      INTEGER                 :: i,p,q,r
      CALL read_yml(st,sit)
      cnam(43)="Sig-free On "
      cnam(41)="a) Separate RCS Curves" 
      cnam(40)="b) Separate Chronologies" 
      CALL det_default()
      sfo=2 ; idt=-2 ; src=1  ! One-curve RCS - Sig free ON
      DO i=1,st               ! Process each site separately
        nc=0 ; cf=st+i                 
        CALL read_rft(cnam(i))
        CALL detrend()  
        p=sfy(mx) ; q=sly(mx) ; r=cyr(cf)
        cfy(i)=p ; cly(i)=q ; cyr(i)=q-p+1
        crn(1:q,i)=msmo(1:q,mx)      ! RCS curve
        num(1:q,i)=mcnt(1:q,mx)      ! RCS count
        CALL splinet(r,crn(1:r,cf),20,crn(1:r,cf))  ! 20-yr smooth
      ENDDO
      OPEN(19,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      WRITE(19,'("Name    Start  End")')
      DO i=1,2*st
        WRITE(19,'(A8,3I6)') wnam(i)(1:8),cfy(i),cly(i),cyr(i)
      ENDDO 
      CLOSE(19)
      RETURN 
      END SUBROUTINE yml_sep3r
!------------------------------------------------------------------------
      SUBROUTINE yml_stitd()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=11  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      w=cyr(35)
      wka(1:w)=(/(DBLE(i),i=cfy(35),cly(35))/) 
      grl=200 ; grr=2400 ; grt=200 ; grb=600
      CALL LABELS('NONE','X')
      CALL NAME('','X')               ! Axis name
      CALL NAME('Index Values','Y')   ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=MAX(cfy(i),1600-cfy(35)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),5)
        CALL MESSAG(wnam(i+20)(1:3),grl+i*150,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl+800,grt+30)
      CALL MESSAG("a) Not Scaled",grl+100,grt+60)
      CALL ENDGRF() 
      grt=610 ; grb=1010
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')               ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=MAX(cfy(i),1600-cfy(35)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i+st),num(p:q,i),5)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) Scaled to Fit",grl+100,grt+60)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE yml_stitd
!-------------------------------------------------------------------
      SUBROUTINE yml_stit(ref1)   ! 1 RCS curve
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)       :: ref1
      INTEGER,PARAMETER        :: st=11  ! Number of sites
      INTEGER,DIMENSION(0:st)  :: sit    ! Site tree address
      REAL(8),DIMENSION(mxd)   :: qx       ! Raw data storage
      INTEGER  :: i,j,k,p,q,r,u,v,w
      CALL read_yml(st,sit)
      CALL det_default()
      cf=35 ; sfo=2 ; idt=-2       ! RCS - Sig free ON
      IF (ref1.EQ.1) THEN
        src=1 ; srcno=1
        cnam(40)="One-curve RCS" 
      ELSEIF (ref1.EQ.2) THEN
        src=2 ; srcno=2
        cnam(40)="Two-curve RCS" 
      ELSEIF (ref1.EQ.3) THEN
        src=2 ; srcno=3
        cnam(40)="Three-curve RCS" 
      ENDIF 
      CALL detrend()                       
      w=cyr(35)
      crn(1:w,1:st*2)=0.D0 ; num(1:w,1:st*2)=0  
      cfy(1:st)=w ; cly(1:st)=-w  
      DO i=1,st                            ! Each sites
        k=i+st
        DO j=sit(i-1)+1,sit(i)             ! Each tree at site
          p=ad(j) ; r=yr(j) ; q=p+r-1      ! Ring address 
          u=fy(j)-cfy(35)+1 ; v=u+r-1      ! Chronology address
          cfy(i)=MIN(cfy(i),u)
          cly(i)=MAX(cly(i),v)
          WHERE (xok(p:q))
            crn(u:v,i)=crn(u:v,i)+dx(p:q)  ! Site CRN
            num(u:v,i)=num(u:v,i)+1        ! Sig free Indices
            crn(u:v,k)=crn(u:v,k)+dx(p:q)/crn(u:v,35)
          END WHERE
        ENDDO
        r=SUM(num(1:w,i))
        crn(i,26)=SUM(crn(1:w,i))/DBLE(r)   ! Mean index
        crn(k,26)=SUM(crn(1:w,35)*DBLE(num(1:w,i)))/DBLE(r)  ! Mean CRN (count weighted)
        crn(i,27)=SUM(crn(1:w,k))/DBLE(r)   ! Mean sig-free index 
        crn(k,27)=crn(i,26)/crn(k,26)       ! Ratio Site/CRN
      ENDDO
      cyr(1:st)=cly(1:st)-cfy(1:st)+1 
      WHERE (num(1:w,1:st).GT.1) &         ! Mean chronologies
        crn(1:w,1:st)=crn(1:w,1:st)/DBLE(num(1:w,1:st))
      DO i=1,st
        p=cfy(i) ; r=cyr(i) ; q=p+r-1
        u=ad(sit(i-1)+1)                   ! First ring of site
        v=ad(sit(i))+yr(sit(i))-1          ! Last ring of site
        qx(u:v)=dx(u:v)/crn(i,27)          ! Scaled tree indices
        crn(p:q,i+st)=crn(p:q,i)/crn(i,27) ! Scaled chronologies
        CALL splinet(r,crn(p:q,i),20,crn(p:q,i))
        CALL splinet(r,crn(p:q,i+st),20,crn(p:q,i+st))
      ENDDO 
      OPEN(19,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      DO i=1,st                            ! Each sites
        k=i+2*st
        r=SUM(num(1:w,i))
        WRITE(19,'(2I6)') i,r 
        crn(k,26)=SUM(crn(1:w,29)*DBLE(num(1:w,i)))/DBLE(r)  ! Mean CRN (weighted)
        crn(k,27)=SUM(crn(1:w,32)*DBLE(num(1:w,i)))/DBLE(r)  ! Mean adj CRN (weighted)
      ENDDO
      WRITE(19,*)
      WRITE(19,'(" First  Last Years   Index  SF Ind     CRN   Ratio")')
      DO i=1,st
        WRITE(19,'(3I6,6F8.3,"  ",A20)') cfy(i)-1+cfy(35),cly(i)-1+cfy(35),&
          cyr(i),crn(i,26:27),crn(i+st,26:27),crn(i+2*st,26:27),wnam(i+20) 
      ENDDO
      CLOSE(19)
      RETURN 
      END SUBROUTINE yml_stit
!------------------------------------------------------------------------
      SUBROUTINE read_yml(st,sit)   ! Read the Yamal sites
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)                  :: st     ! number of sites
      INTEGER,DIMENSION(0:st),INTENT(OUT) :: sit    ! site tree address
      INTEGER  :: i
      cnam(1)="../../raw/yam/yml-sub.rwl"  ; wnam(21)="SUB site"
      cnam(2)="../../raw/yam/ccc.rwl"      ; wnam(22)="CCC site"
      cnam(3)="../../raw/yam/hdt.rwl"      ; wnam(23)="HDT site"
      cnam(4)="../../raw/yam/jahm.raw"     ; wnam(24)="JAH site"
      cnam(5)="../../raw/yam/pm0.rwl"      ; wnam(25)="PM0 site"
      cnam(6)="../../raw/yam/por.raw"      ; wnam(26)="POR site"
      cnam(7)="../../raw/yam/pvx.rwl"      ; wnam(27)="PVX site"
      cnam(8)="../../raw/yam/tnl.rwl"      ; wnam(28)="TNL site"
      cnam(9)="../../raw/yam/yad.raw"      ; wnam(29)="YAD site"
      cnam(10)="../../raw/yam/yx0.rwl"     ; wnam(30)="YX0 site"
      cnam(11)="../../raw/yam/yml-old.raw" ; wnam(31)="Old site"
      cnam(12)="../../raw/yam/khad.raw"    ; wnam(32)="KHAD site"
      nc=0 ; sit(0)=0                 
      DO i=1,st                    ! Read all sites
        CALL read_rft(cnam(i)) ; sit(i)=nc
      ENDDO
      RETURN 
      END SUBROUTINE read_yml
!------------------------------------------------------------------------
      SUBROUTINE pol_compd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL NAME('','X')               ! Axis name
      CALL NAME('Index Values','Y')   ! Axis name
      p=cfy(2)-cfy(1)
      CALL plot_treesq(p,num(1:p,1),159)  
      CALL tombox(cfy(1),cfy(2)-1,0.25D0,1.9D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL thickthin(p,wka(1:p),crn(1:p,4),num(1:p,1),5)
      CALL MESSAG(cnam(40),grl+200,grt-45)
      CALL SETCLR(blue)
      CALL thickthin(p,wka(1:p),crn(1:p,10),num(1:p,1),5)
      CALL MESSAG(cnam(41),grl+800,grt-45)
      CALL SETCLR(red)
      CALL thickthin(p,wka(1:p),crn(1:p,16),num(1:p,1),5)
      CALL MESSAG(cnam(42),grl+1400,grt-45)
      CALL SETCLR(black)
      CALL MESSAG(wnam(20),grl+700,grt+30)
      CALL ENDGRF() 

      grt=620 ; grb=1020
      r=cyr(2) ; p=cfy(2)-cfy(1)+1 
      num(cyr(1)+1:p+r,1)=0
      CALL LABELS('NONE','X')
      CALL plot_treesq(r,num(p:p+r-1,1),159)  
      CALL tombox(cfy(2),cly(2),0.25D0,1.9D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; q=cyr(1) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,4),num(p:q,1),5)
      CALL SETCLR(blue)
      CALL thickthin(r,wka(p:q),crn(p:q,10),num(p:q,1),5)
      CALL SETCLR(red)
      CALL thickthin(r,wka(p:q),crn(p:q,16),num(p:q,1),5)
      CALL SETCLR(black)
      CALL MESSAG(wnam(21),grl+700,grt+30)
      CALL ENDGRF() 

      r=cyr(2) ; wka(1:r)=(/(DBLE(i),i=cfy(2),cly(2))/) 
      grt=1030 ; grb=1430
      CALL NAME('Index Values','Y')   ! Axis name
      CALL plot_treesq(r,num(1:r,2),159)  
      CALL tombox(cfy(2),cly(2),0.25D0,1.9D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(1:r,5),num(1:r,2),5)
      CALL SETCLR(blue)
      CALL thickthin(r,wka(1:r),crn(1:r,11),num(1:r,2),5)
      CALL SETCLR(red)
      CALL thickthin(r,wka(1:r),crn(1:r,17),num(1:r,2),5)
      CALL SETCLR(black)
      CALL MESSAG(wnam(22),grl+700,grt+30)
      CALL ENDGRF() 

      p=cfy(2)-cfy(3)+1 ; q=cly(2)-cfy(3)+1 ; r=q-p+1
      grt=1440 ; grb=1840
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')               ! Axis name
      CALL NAME('Index Values','Y')   ! Axis name
      CALL plot_treesq(r,num(p:q,3),159)  
      CALL tombox(cfy(2),cly(2),0.85D0,1.18D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(p:q,6),num(p:q,3),5)
      CALL SETCLR(blue)
      CALL thickthin(r,wka(1:r),crn(p:q,12),num(p:q,3),5)
      CALL SETCLR(red)
      CALL thickthin(r,wka(1:r),crn(p:q,18),num(p:q,3),5)
      CALL SETCLR(black)
      CALL MESSAG(wnam(23),grl+700,grt+30)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE pol_compd
!-------------------------------------------------------------------
      SUBROUTINE pol_comp()   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      INTEGER  :: j,r
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(20)="a) Yamal TRW"
      wnam(21)="b) Yamal TRW"
      wnam(22)="c) Polar TRW"
      wnam(23)="d) Polar MXD"
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2                ! RCS - Sig free ON
      DO j=1,3
        nc=0 ; CALL read_rft(cnam(j))
        src=1 ; srcno=1
        cnam(40)="One-curve RCS, Ratio" 
        cf=j ; CALL detrend() ; r=cyr(cf)
        crn(1:r,cf+3)=xcsm(1:r,mx)
        src=2 ; srcno=2
        cnam(41)="Two-curve RCS, Ratio" 
        cf=cf+6 ; CALL detrend() 
        crn(1:r,cf+3)=xcsm(1:r,mx)
        src=2 ; srcno=3
        cnam(42)="Three-curve RCS, Ratio" 
        cf=cf+6 ; CALL detrend() 
        crn(1:r,cf+3)=xcsm(1:r,mx)
      ENDDO  
      RETURN 
      END SUBROUTINE pol_comp
!------------------------------------------------------------------------
      SUBROUTINE Fig9d(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1
      REAL(8),DIMENSION(4)   :: boxx,boxy 
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8)                :: tk,bk  
      INTEGER                :: i=1,j=1,n1,n2,m,p,q,r,u,v
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grl=200 ; grr=2000 ; grt=110 ; grb=410
      CALL NAME('','X')               ! Axis name
      CALL NAME('Indices','Y')   ! Axis name
      p=cfy(2)-cfy(1) ; q=-500-cfy(1)+1 
      CALL plot_treesq(p-q+1,num(q:p,1),159)  
      CALL tombox(-500,cfy(2)-1,-1.2D0,1.2D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan)
      DO i=q,p
        boxx=(/wka(i)-0.5D0,wka(i)+0.5D0,wka(i)+0.5D0,wka(i)-0.5D0/)
        boxy=(/crn(i,34),crn(i,34),-crn(i,34),-crn(i,34)/)
        CALL RLAREA(boxx,boxy,4)
      ENDDO
      CALL SETCLR(black)
      CALL thickthin(p,wka(1:p),crn(1:p,4),num(1:p,1),5)
      CALL MESSAG(cnam(40),grl,grt-45)
      IF (ref1.EQ.2) THEN
        CALL SETCLR(blue)
        CALL thickthin(p,wka(1:p),crn(1:p,10),num(1:p,1),5)
        CALL MESSAG(cnam(41),grl+900,grt-45)
      ENDIF
      CALL SETCLR(red)
      CALL thickthin(p,wka(1:p),crn(1:p,16),num(1:p,1),5)
      CALL MESSAG(cnam(42),grl+450,grt-45)
      CALL SETCLR(cyan)
      CALL MESSAG("Two Std Errors",grl+1400,grt-45)
      CALL SETCLR(black)
      CALL MESSAG(wnam(20),grl+600,grt+30)
      CALL ENDGRF() 

      r=cyr(2) ; wka(1:r+3)=(/(DBLE(i),i=cfy(2),cly(2)+3)/) 
      grt=grt+60 ; grb=grb+60
      CALL LABELS('NONE','X')
      DO j=1,3
        grt=grt+310 ; grb=grb+310
        p=cfy(2)-cfy(j)+1 ; q=cly(2)-cfy(j)+1 ; r=q-p+1
        CALL plot_treesq(r,num(p:q,j),159)  
        IF (j.EQ.3) THEN
          CALL LABELS('FLOAT','X')
          CALL tombox(cfy(2),cly(2),-0.8D0,0.8D0)
        ELSE
          CALL tombox(cfy(2),cly(2),-1.2D0,1.2D0)
        ENDIF
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(cyan)
        DO i=p,q
          u=i-p+1
          boxx=(/wka(u)-0.5D0,wka(u)+0.5D0,wka(u)+0.5D0,wka(u)-0.5D0/)
          boxy=(/crn(i,33+j),crn(i,33+j),-crn(i,33+j),-crn(i,33+j)/)
          CALL RLAREA(boxx,boxy,4)
        ENDDO
        CALL SETCLR(black)
        CALL thickthin(r,wka(1:r),crn(p:q,j+3),num(p:q,j),5)
        IF (ref1.EQ.2) THEN
          CALL SETCLR(blue)
          CALL thickthin(r,wka(1:r),crn(p:q,j+9),num(p:q,j),5)
        ENDIF
        CALL SETCLR(red)
        CALL thickthin(r,wka(1:r),crn(p:q,j+15),num(p:q,j),5)
        CALL SETCLR(black)
        CALL MESSAG(wnam(20+j),grl+600,grt+30)
        CALL ENDGRF() 
      ENDDO
      grt=grt+370 ; grb=grb+370
      CALL TICKS(0,'X')        ! X ticks 
      DO j=1,3
        IF (j.EQ.1) THEN
          grl=200 ; grr=790 ; m=300      
          u=200 ; v=359 ; p=u-cfy(1)+1 ; q=v-cfy(1)+1
          CALL NAME('','X')                 ! Axis name
          CALL NAME('z-score','Y')    ! Axis name
        ELSEIF (j.EQ.2) THEN
          grl=805 ; grr=1395 ; m=300      
          CALL LABELS('NONE','Y')
          CALL NAME('','Y')            ! Axis name
          CALL NAME('Calendar Year','X')    ! Axis name
          u=960 ; v=1119 ; p=u-cfy(1)+1 ; q=v-cfy(1)+1
        ELSE
          grl=1410 ; grr=2000 ; m=50      
          CALL NAME('','X')                 ! Axis name
          u=1846 ; v=2005 ; p=u-cfy(1)+1 ; q=cyr(1)
        ENDIF
        r=v-u+1 ; wka(1:r)=(/(DBLE(i),i=u,v)/) 
        CALL AXSPOS(grl,grb)
        CALL AXSLEN(grr-grl,grb-grt)
        CALL HEIGHT(18) ; CALL SETCLR(black)
        CALL xticks(u,v,n1,n2)
        CALL yticks(-1.99D0,1.99D0,tk,bk)
        CALL GRAF(DBLE(u),DBLE(v),DBLE(n1),40.D0,-1.99D0,1.99D0,tk,bk)
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(red)   ; CALL CURVE(wka(1:r),crn(p:q,13),r)
        CALL SETCLR(black) ; CALL CURVE(wka(1:r),crn(p:q,4),r)
        CALL MESSAG(wnam(j+23),grl+m,grt+30)
        CALL ENDGRF() 
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(10,'X')        ! Y ticks 
      RETURN 
      END SUBROUTINE Fig9d
!-------------------------------------------------------------------
      SUBROUTINE Fig9()   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      INTEGER  :: i,j,p,q,r,u,v
      OPEN(79,FILE="yamal/Fig9.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig9.col")) STOP
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(20)="a) Yamal TRW"
      wnam(21)="b) Yamal TRW"
      wnam(22)="c) Polar TRW"
      wnam(23)="d) Polar MXD"
      wnam(24)="e) Yamal TRW"
      wnam(25)="f) Yamal TRW"
      wnam(26)="g) Yamal TRW"
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2 ; idb=2        ! RCS, Sig free, normal
      DO j=1,3
        nc=0 ; CALL read_rft(cnam(j))
        src=1 ; srcno=1
        cnam(40)="One-curve Normal" 
        cf=j ; CALL detrend() ; r=cyr(cf)
        crn(1:r,cf+3)=xcsm(1:r,mx)
        src=2 ; srcno=3
        cnam(41)="Three-curve Normal" 
        cf=cf+6 ; CALL detrend() ; r=cyr(cf) 
        crn(1:r,cf+3)=xcsm(1:r,mx)
        src=2 ; srcno=2
        cnam(42)="Two-curve Normal" 
        cf=cf+6 ; CALL detrend() ; r=cyr(cf) 
        crn(1:r,cf+3)=xcsm(1:r,mx)
        r=cyr(cf) ; crn(1:r,31:33)=0.D0 
        DO i=1,nc     ! For each tree
          p=ad(i) ; r=yr(i) ; q=p+r-1
          u=fy(i)-cfy(cf)+1 ; v=u+r-1
          CALL splinet(r,dx(p:q),50,ax(p:q))  ! Smooth tree
          WHERE (xok(p:q))
            crn(u:v,32)=crn(u:v,32)+ax(p:q)
            crn(u:v,33)=crn(u:v,33)+ax(p:q)**2
          END WHERE 
        ENDDO  
        r=cyr(cf)
        WHERE (num(1:r,cf).GE.1) &
          crn(1:r,31)=crn(1:r,32)/DBLE(num(1:r,cf))   ! Mean
        WHERE (num(1:r,cf).GT.3) 
          crn(1:r,32)=SQRT(MAX(crn(1:r,33)-crn(1:r,32)* &  
            crn(1:r,31),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
          crn(1:r,33+j)=2.D0*crn(1:r,32)/SQRT(DBLE(num(1:r,cf)))
        ELSEWHERE 
          crn(1:r,32)=0.D0 ; crn(1:r,33+j)=1.99D0
        END WHERE   
        WRITE(79,'(A9)') wnam(20+j)(4:12)
        WRITE(79,'("Sample Counts")') 
        WRITE(79,'("One-curve Chronology")') 
        WRITE(79,'("One-curve Smoothed")') 
        WRITE(79,'("Two-curve Chronology")') 
        WRITE(79,'("Two-curve Smoothed")') 
        WRITE(79,'("Two-curve 2 Std. Error")') 
        DO i=1,r
          WRITE(79,'(2I6,5F8.3)') cfy(j)-1+i,num(i,j),crn(i,j), &
            crn(i,j+3),crn(i,j+12),crn(i,j+15),crn(i,33+j)
        ENDDO
        WRITE(79,*)
      ENDDO
      idb=1 ; CLOSE(79) 
      RETURN 
      END SUBROUTINE Fig9
!------------------------------------------------------------------------
      SUBROUTINE PU_indivd(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8)                :: r1,r2,r3,r4,r5
      INTEGER                :: i=1,p,q,r,u,v
      IF (ref1.EQ.1) THEN    ! TRW
        r1=0.3D0 ; r2=2.3D0 ; r3=1.7D0 ; r4=0.0D0 ; r5=2.9D0
      ELSE                   ! MXD 
        r1=0.6D0 ; r2=1.3D0  ; r3=0.45D0 ; r4=0.6D0 ; r5=1.3D0
      ENDIF 
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=650
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(p,q,r1,r2)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1
        u=fy(i)-cfy(1)+1 ; v=u+r-1
        CALL SETCLR(num(i,3))
        CALL line_miss(r,wka(u:v),ax(p:q),xok(p:q))
      ENDDO 
      CALL SETCLR(cyan) 
      CALL MESSAG(cnam(21),grl+20,grt-40)
      CALL SETCLR(green)
      CALL MESSAG(cnam(22),grl+470,grt-40)
      CALL SETCLR(blue)
      CALL MESSAG("Update Stem",grl+1020,grt-40)
      CALL SETCLR(red)
      CALL MESSAG("Update Root",grl+1470,grt-40)
      CALL SETCLR(5)
      CALL MESSAG("Sub-fossil Root",grl+1800,grt-40)
      CALL SETCLR(black)
      CALL MESSAG("a) Mean Value",grl+1560,grt+30)
      CALL ENDGRF()

      grt=660 ; grb=1160
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      CALL tombox(p,q,r4,r5)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1
        u=fy(i)-cfy(1)+1 ; v=u+r-1
        CALL SETCLR(num(i,3))
        CALL line_miss(r,wka(u:v),dx(p:q),xok(p:q))
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) 100-year Smoothed",grl+1600,grt+30)
      CALL ENDGRF()

      grt=1170 ; grb=1670
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      CALL plot_trees(r,num(1:r,1))  
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')

      CALL tombox(p,q,0.0D0,r3)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(red)
      CALL line_miss(r,wka(1:r),xcsd(1:r,mx),num(1:r,1).GE.4)
      CALL MESSAG("c) Standard Deviation",grl+1600,grt+30)
      CALL SETCLR(black) ; CALL ENDGRF()
      RETURN 
      END SUBROUTINE PU_indivd
!-------------------------------------------------------------------
      SUBROUTINE PU_indiv(ref1) 
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1
      CHARACTER(8) :: xnam
      CHARACTER(4) :: stem
      INTEGER  :: i=1,p,q,r
      cnam(30)="One-curve Sig-free RCS" 
      CALL det_default()
      sfo=2 ; idt=-2  ! RCS - Sig free OFF  
      IF (ref1.EQ.1) THEN    ! TRW
        cnam(1)="../../raw/polar/poula/pou_la_mod.raw" 
        cnam(21)="TRW Polar Modern"
        cnam(2)="../../raw/polar/poula/pou_la_sub.raw"
        cnam(22)="TRW Polar Sub-fossil"
        cnam(3)="../../raw/polar/poula/polurula.raw"
        cnam(23)="TRW Polar Update"
      ELSE                   ! MXD 
        cnam(1)="../../raw/polar/poula/pou_la_mod.mxd"
        cnam(21)="MXD Polar Modern"
        cnam(2)="../../raw/polar/poula/pou_la_sub.mxd"
        cnam(22)="MXD Polar Sub-fossil"
        cnam(3)="../../raw/polar/poula/polurula.mxd"
        cnam(23)="MXD Polar Update"
      ENDIF 
      cnam(4)="../../raw/polar/poula/polurula.prn" 
      nc=0    ! Process TRW
      DO i=1,3
        CALL read_rft(cnam(i)) ; num(i,2)=nc
      ENDDO
      cf=1 ; CALL detrend() ; r=cyr(1) 
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1  ! Smooth each series
        ax(p:q)=SUM(dx(p:q),MASK=xok(p:q))/DBLE(COUNT(xok(p:q)))
        CALL splinet(r,dx(p:q),100,dx(p:q))
      ENDDO
      CALL read_open(21,cnam(4))
      DO i=1,4                              ! Read header records
        READ(21,*,IOSTAT=ios)   
        IF (io_err("Read Headers ",cnam(4))) STOP
      ENDDO         
      num(1:num(1,2),3)=cyan
      num(num(1,2)+1:num(2,2),3)=green
      num(num(2,2)-2:num(2,2),3)=5
      DO i=num(2,2)+1,nc                             
        READ(21,'(A8,51X,A4)',IOSTAT=ios)  xnam,stem 
        IF (io_err("Read 2 ",cnam(4))) STOP
        IF (nam(i)(1:8).NE.xnam) CALL out_err("fail "//xnam//nam(i)(1:8)) 
        IF (stem.EQ."stem") THEN
          num(i,3)=blue    ! Stem
        ELSE
          num(i,3)=red    ! Root
        ENDIF  
      ENDDO         
      RETURN 
      END SUBROUTINE PU_indiv
!------------------------------------------------------------------------
      SUBROUTINE PU_sepd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,u,v,w
      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=500
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(p,q,0.2D0,2.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan)
      u=cfy(21)-cfy(1)+1 ; w=cyr(21) ; v=u+w-1
      CALL thickthin(w,wka(u:v),crn(1:w,21),num(1:w,21),3)
      CALL MESSAG("Polar Living",grl+300,grt-45)
      CALL SETCLR(blue)
      u=cfy(22)-cfy(1)+1 ; w=cyr(22) ; v=u+w-1
      CALL thickthin(w,wka(u:v),crn(1:w,22),num(1:w,22),3)
      CALL MESSAG("Polar Sub-fossil",grl+1000,grt-45)
      CALL SETCLR(red)
      u=cfy(23)-cfy(1)+1 ; w=cyr(23) ; v=u+w-1
      CALL thickthin(w,wka(u:v),crn(1:w,23),num(1:w,23),3)
      CALL MESSAG("Polar Update",grl+1700,grt-45)
      CALL SETCLR(black)
      CALL MESSAG("a) TRW Separate Chronologies",grl+600,grt+30)
      CALL ENDGRF() 
 
      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      grt=510 ; grb=860
      CALL tombox(p,q,0.2D0,2.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(4) ; q=cly(4) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,4),num(p:q,4),3)
      CALL SETCLR(blue) ; p=cfy(5) ; q=cly(5) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,5),num(p:q,5),3)
      CALL SETCLR(red) ; p=cfy(6) ; q=cly(6) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,6),num(p:q,6),3)
      CALL SETCLR(black)
      CALL MESSAG("b) TRW one-curve RCS",grl+600,grt+30)
      CALL ENDGRF()  

      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      grt=870 ; grb=1220
      CALL tombox(p,q,0.68D0,1.2D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan)
      u=cfy(24)-cfy(1)+1 ; w=cyr(24) ; v=u+w-1
      CALL thickthin(w,wka(u:v),crn(1:w,24),num(1:w,24),3)
      CALL SETCLR(blue)
      u=cfy(25)-cfy(1)+1 ; w=cyr(25) ; v=u+w-1
      CALL thickthin(w,wka(u:v),crn(1:w,25),num(1:w,25),3)
      CALL SETCLR(red)
      u=cfy(26)-cfy(1)+1 ; w=cyr(26) ; v=u+w-1
      CALL thickthin(w,wka(u:v),crn(1:w,26),num(1:w,26),3)
      CALL SETCLR(black)
      CALL MESSAG("c) MXD Separate Chronologies",grl+600,grt+30)
      CALL ENDGRF()

      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grt=1230 ; grb=1580
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')   ! Axis name
      CALL tombox(p,q,0.68D0,1.2D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(14) ; q=cly(14) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,14),num(p:q,14),3)
      CALL SETCLR(blue) ; p=cfy(15) ; q=cly(15) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,15),num(p:q,15),3)
      CALL SETCLR(red) ; p=cfy(16) ; q=cly(16) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,16),num(p:q,16),3)
      CALL SETCLR(black)
      CALL MESSAG("d) MXD one-curve RCS",grl+600,grt+30)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE PU_sepd
!-------------------------------------------------------------------
      SUBROUTINE PU_sep() 
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,r
      cnam(30)="" 
      CALL det_default()
      sfo=2 ; idt=-2  ! RCS - Sig free ON 
      CALL PU_sepx()
      DO i=3,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL splinet(r,crn(p:q,i),50,crn(p:q,i))
      ENDDO
      DO i=13,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL splinet(r,crn(p:q,i),50,crn(p:q,i))
      ENDDO
      cnam(30)="Separate RCS curves and CRNs" 
      CALL det_default()
      idt=-2 ; sfo=1 ; src=1   ! Simple RCS
      DO i=1,6
        nc=0 ; CALL read_rft(cnam(i))
        cf=i+20 ; CALL detrend() ; r=cyr(cf)                  
        CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf))
      ENDDO
      RETURN 
      END SUBROUTINE PU_sep
!------------------------------------------------------------------------
      SUBROUTINE read_yclim(norm)  ! Read Yamal grid box 
      IMPLICIT NONE
      LOGICAL,INTENT(IN)     :: norm  
      INTEGER,DIMENSION(mmx) :: wk 
      REAL(8)                :: sd,mn 
      INTEGER                :: i,p,q,r,w
      met=0.D0 ; mcf=0
      CALL read_metf("../../raw/yam/clim/AdjvT67.5N67.5E.dat")
      mnam(1:2)="June-July Temp"
      mfy(1:2)=MINVAL(mfy(6:7)) ; mly(1:2)=MAXVAL(mly(6:7))
      myr(1:2)=mly(1)-mfy(1)+1
      w=myr(1) ; wk(1:w)=0 ; met(1:w,1)=0.D0
      DO i=6,7                     ! 1 and 2 are June and July
        p=mfy(i)-mfy(1)+1 ; r=myr(i) ; q=p+r-1
        WHERE (okm(1:r,i))
          met(p:q,1)=met(p:q,1)+met(1:r,i) ; wk(p:q)=wk(p:q)+1
        END WHERE
      ENDDO
      okm(1:w,1)=wk(1:w).GE.1
      WHERE (okm(1:w,1)) 
        met(1:w,1)=met(1:w,1)/(10.D0*DBLE(wk(1:w)))  ! Mean June-July 
      ELSEWHERE
        met(1:w,1)=-999D0
      END WHERE 
      okm(1:w,2)=okm(1:w,1)
      met(1:w,2)=met(1:w,1)
      mnam(3)="June-August Temp"
      mfy(3)=MINVAL(mfy(6:8)) ; mly(3)=MAXVAL(mly(6:8))
      myr(3)=mly(3)-mfy(3)+1
      w=myr(3) ; wk(1:w)=0 ; met(1:w,3)=0.D0
      DO i=6,8               ! 3 is June to August
        p=mfy(i)-mfy(3)+1 ; r=myr(i) ; q=p+r-1
        WHERE (okm(1:r,i))
          met(p:q,3)=met(p:q,3)+met(1:r,i) ; wk(p:q)=wk(p:q)+1
        END WHERE
      ENDDO
      okm(1:w,3)=wk(1:w).GE.1
      WHERE (okm(1:w,3)) 
        met(1:w,3)=met(1:w,3)/(10.D0*DBLE(wk(1:w)))   ! Mean June-August 
      ELSEWHERE
        met(1:w,3)=-999D0
      END WHERE 
      IF (norm) THEN  ! 1=2005 (Yamal), 2 & 3 = 2006 (Polar)
        r=2005-mfy(1)+1 ; w=COUNT(okm(1:r,1))
        mn=SUM(met(1:r,1),MASK=okm(1:r,1))/DBLE(w)    ! Normalise 
        sd=SQRT(SUM((met(1:r,1)-mn)**2,MASK=okm(1:r,1))/DBLE(w-1))
        r=myr(1)
        WHERE (okm(1:r,1)) met(1:r,1)=(met(1:r,1)-mn)/sd
        r=2006-mfy(2)+1 ; w=COUNT(okm(1:r,2))
        mn=SUM(met(1:r,2),MASK=okm(1:r,2))/DBLE(w)    ! Normalise 
        sd=SQRT(SUM((met(1:r,2)-mn)**2,MASK=okm(1:r,2))/DBLE(w-1))
        r=myr(2)
        WHERE (okm(1:r,2)) met(1:r,2)=(met(1:r,2)-mn)/sd
        r=2006-mfy(3)+1 ; w=COUNT(okm(1:r,3))
        mn=SUM(met(1:r,3),MASK=okm(1:r,3))/DBLE(w)    ! Normalise 
        sd=SQRT(SUM((met(1:r,3)-mn)**2,MASK=okm(1:r,3))/DBLE(w-1))
        r=myr(3)
        WHERE (okm(1:r,3)) met(1:r,3)=(met(1:r,3)-mn)/sd
      ENDIF
      DO i=1,3
        r=myr(i)
        CALL spline_miss(r,met(1:r,i),100,met(1:r,i+3),okm(1:r,i))  ! 100yr Low Pass  
        WHERE (okm(1:r,i)) met(1:r,i+6)=met(1:r,i)-met(1:r,i+3)     ! 100yr High Pass - diff
        CALL spline_miss(r,met(1:r,i+6),15,met(1:r,i+9),okm(1:r,i)) ! 100-15yr Band Pass   
        WHERE (okm(1:r,i)) met(1:r,i+12)=met(1:r,i+6)-met(1:r,i+9)  ! Diff 15yr HP
        okm(1:r,i+3)=okm(1:r,i) ; okm(1:r,i+6)=okm(1:r,i)
        okm(1:r,i+12)=okm(1:r,i)
        WHERE (.NOT.okm(1:r,1))
          met(1:r,i+3)=-999D0 ; met(1:r,i+9)=-999D0 ; met(1:r,i+12)=-999D0
        END WHERE  
      ENDDO
      RETURN
      END SUBROUTINE read_yclim
!--------------------------------------------------------------
      SUBROUTINE climexpd()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: cst=1883  ! First met year
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER,DIMENSION(4)   :: refa,refb
      INTEGER                :: i=1,j=1,n,m,p,q,r
      wnam(31)="All Frequencies"
      wnam(32)="100-yr Low Pass"
      wnam(33)="100-15yr Band Pass"
      wnam(34)="15-yr High Pass"
      refa=(/0,3,9,12/)    ! Chrons
      refb=(/0,3,9,12/)    ! Met  
      grt=180 ; grb=580
      m=myr(1) ; wka(1:m)=(/(DBLE(i),i=mfy(1),mly(1))/) 
      CALL LABELS('NONE','X')
      CALL NAME('','X')        ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL TICKS(0,'X')        ! Y ticks 
      DO j=1,4                 ! Each Figure
        IF (j.EQ.4) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')               ! Axis name
        ENDIF
        grl=240 ; grr=1000 
        DO i=1,3         ! Each site
          IF (i.EQ.1) THEN  
            CALL LABELS('FLOAT','Y')
            CALL NAME(wnam(j+30),'Y')      ! Axis name
          ELSE
            CALL LABELS('NONE','Y')
            CALL NAME('','Y')               ! Axis name
          ENDIF
          p=cst-cfy(i)+1 ; q=cyr(i) ; r=q-p+1     
          CALL tombox(cst,2005,-2.9D0,+2.9D0)   ! TRW
          CALL SETCLR(grey) ; CALL GRID(1,1)     ! Gridlines
          CALL HEIGHT(22) ; CALL LINWID(1)
          IF (j.EQ.1) THEN
            CALL SETCLR(blue) ; CALL MESSAG(wnam(20+i),grl+30,grt-45)
            CALL SETCLR(red)  ; CALL MESSAG(mnam(i),grl+300,grt-45)
            IF (i.EQ.1) THEn
               CALL SETCLR(black) ; CALL MESSAG(cnam(40),grl+500,grt-90)
            ENDIF
          ENDIF
          IF (j.EQ.2.OR.J.EQ.3) CALL LINWID(4)
          CALL SETCLR(blue)
          CALL CURVE(wka(1:r),crn(p:q,i+refa(j)),r)
          CALL SETCLR(red) ; n=i+refb(j)
          CALL line_miss(m,wka(1:m),met(1:m,n),okm(1:m,n))
          CALL SETCLR(black) ; CALL ENDGRF() ; CALL LINWID(1) 
          grl=grl+780 ; grr=grr+780 
        ENDDO
        grt=grt+410 ; grb=grb+410
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL TICKS(10,'X')       ! Y ticks 
      RETURN 
      END SUBROUTINE climexpd
!-------------------------------------------------------------------
      SUBROUTINE climexp(ref1)  ! Distribution of various indices 
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ref1
      INTEGER,PARAMETER  :: cst=1883  ! First met year
      REAL(8)            :: sd,mn 
      INTEGER            :: i,n,p,q,r
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="Yamal TRW"
      wnam(22)="Polar TRW"
      wnam(23)="Polar MXD"
      CALL det_default() ; idt=-2
      src=2 ; srcno=2      ! 2 curve RCS detrend
      IF (ref1.EQ.1) THEN
        idb=1 ; cnam(40)="Two RCS Curve Ratios" 
      ELSE
        idb=2 ; cnam(40)="Two RCS, Normal Distribution CRNs" 
      ENDIF
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend()           
        p=cst-cfy(i)+1 ; q=cyr(i) ; n=q-p+1 ! Normalise common period
        mn=SUM(crn(p:q,i))/DBLE(n)
        sd=SQRT(SUM((crn(p:q,i)-mn)**2)/DBLE(n-1))
        r=cyr(i)
        IF (ref1.EQ.1) THEN     ! Ratios
          CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
          crn(1:r,i+6)=crn(1:r,i)/crn(1:r,i+3)         ! Ratio 100yr High Pass
          CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
          crn(1:r,i+12)=crn(1:r,i+6)/crn(1:r,i+9)      ! Ratio 15yr HP
          crn(1:r,i)=(crn(1:r,i)-mn)/sd                 
          mn=SUM(crn(p:q,i+3))/DBLE(n)                 
          crn(1:r,i+3)=(crn(1:r,i+3)-mn)/sd            ! Remove mean, rescale by SDev
          mn=SUM(crn(p:q,i+6))/DBLE(n)                 
          crn(1:r,i+6)=(crn(1:r,i+6)-mn)/sd            ! Remove mean, rescale by SDev
          mn=SUM(crn(p:q,i+9))/DBLE(n)
          crn(1:r,i+9)=(crn(1:r,i+9)-mn)/sd            ! Remove mean, rescale by SDev
          mn=SUM(crn(p:q,i+12))/DBLE(n)
          crn(1:r,i+12)=(crn(1:r,i+12)-mn)/sd          ! Remove mean, rescale by SDev
        ELSE                    ! Differences
          crn(1:r,i)=(crn(1:r,i)-mn)/sd
          CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
          crn(1:r,i+6)=crn(1:r,i)-crn(1:r,i+3)         ! 100yr High Pass
          CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
          crn(1:r,i+12)=crn(1:r,i+6)-crn(1:r,i+9)      ! 15yr HP
        ENDIF
      ENDDO
      CALL read_yclim(TR)
      OPEN(74,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      WRITE(74,'("CRNs")')
      DO i=0,myr(1)-1
        p=mfy(1)-cfy(1)+1 ; q=mfy(1)-cfy(2)+1 ; r=mfy(1)-cfy(3)+1
        WRITE(74,'(I6,12F8.2)') i+mfy(1)-1,crn(i+p,1),crn(i+q,2), &
          crn(i+r,3),crn(i+p,4),crn(i+q,5),crn(i+r,6),crn(i+p,7), &
          crn(i+q,8),crn(i+r,9),crn(i+p,10),crn(i+q,11),crn(i+r,12)
      ENDDO
      WRITE(74,'("CRNs")')
      DO i=1,myr(1)
        WRITE(74,'(I6,12F8.2)') i+mfy(1)-1,met(i,1:10)
      ENDDO
      CLOSE(74)
      RETURN
      END SUBROUTINE climexp
!--------------------------------------------------------------
      SUBROUTINE climdat()  ! Save Climate data 
      IMPLICIT NONE
      INTEGER            :: i
      CALL read_yclim(FA)
      OPEN(74,FILE="climate.prn",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," climate.prn")) STOP
      WRITE(74,'("Grid 67.5N 67.5E Infilled Temperature Anomaly")')
      WRITE(74,'("1st Calendar Year")')
      WRITE(74,'("2nd June-July")')
      WRITE(74,'("3rd June-July >100 year")')
      WRITE(74,'("4th June-July 100 to 15 year")')
      WRITE(74,'("5th June-July <15 year")')
      WRITE(74,'("6th June-August")')
      WRITE(74,'("7th June-August >100 year")')
      WRITE(74,'("8th June-August 100 to 15 year")')
      WRITE(74,'("9th June-August <15 year")')
      WRITE(74,*)
      DO i=1,myr(1)
        WRITE(74,'(I6,12F8.3)') i+mfy(1)-1,met(i,1),met(i,4),met(i,10), &
          met(i,13),met(i,3),met(i,6),met(i,12),met(i,15)
      ENDDO
      CLOSE(74)
      RETURN
      END SUBROUTINE climdat
!--------------------------------------------------------------
      SUBROUTINE expvard(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1
      REAL(8),DIMENSION(mxy) :: wka
      REAL(8)                :: ra,rb
      INTEGER                :: i=1,j=1,p,q,r
      CALL NAME('Index Values','Y')           ! Axis name
      grl=200 ; grr=2400 ; grt=150 ; grb=500
      DO j=1,3  
        wka(1:cyr(j))=(/(DBLE(i),i=cfy(j),cly(j))/) 
        p=MAX(800,cfy(j))-cfy(j)+1 ; q=cyr(j) ; r=q-p+1     
        IF (j.EQ.1) THEN
          CALL LABELS('NONE','X')
          CALL NAME('','X')            ! Axis name
          ra=0.2D0 ; rb=2.D0           ! TRW
        ELSEIF (j.EQ.3) THEN
          CALL LABELS('FLOAT','X')
          ra=0.6D0 ; rb=1.3D0          ! MXD
        ELSE
          ra=0.2D0 ; rb=2.D0           ! TRW
        ENDIF 
        IF (ref1.EQ.2) THEN
          ra=-1.5D0 ; rb=1.5D0
        ENDIF
        CALL tombox(800,2005,ra,rb)    ! TRW
        CALL SETCLR(grey) ; CALL GRID(1,1)    
        CALL LINWID(1) ; CALL HEIGHT(22)
        IF (j.EQ.1) THEN
          CALL SETCLR(black)
          CALL MESSAG(cnam(40),grl+50,grt-40)
          CALL SETCLR(blue)
          CALL MESSAG("15yr High Pass",grl+1000,grt-40)
          CALL SETCLR(red)
          CALL MESSAG("100-15 Band Pass",grl+1400,grt-40)
          CALL SETCLR(cyan)
          CALL MESSAG("100yr Low Pass",grl+1800,grt-40)
        ENDIF
        CALL SETCLR(blue)
        CALL CURVE(wka(p:q),crn(p:q,j+12),r)
        CALL SETCLR(red) ; CALL LINWID(4)
        CALL CURVE(wka(p:q),crn(p:q,j+9),r)
        CALL SETCLR(cyan)
        CALL CURVE(wka(p:q),crn(p:q,j+3),r)
        CALL SETCLR(black) ; CALL LINWID(1)
        CALL MESSAG(wnam(20+j),grl+500,grt+30)
        CALL ENDGRF()
        grt=grt+360 ; grb=grb+360
      ENDDO
      grt=grt+70 ; grb=grb+70
      CALL NAME('Calendar Year','X')      ! Axis name
      CALL NAME('Anomalies Deg C','Y')    ! Axis name
      r=myr(1) ; wka(1:r)=(/(DBLE(i),i=mfy(1),mly(1))/) 
      grl=220 ; grr=1305 
      CALL tombox(mfy(1),mly(1),-3.9D0,3.8D0) 
      CALL SETCLR(grey) ; CALL GRID(1,1)     
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(blue)
      CALL line_miss(r,wka(1:r),met(1:r,13),okm(1:r,1))
      CALL SETCLR(red) ; CALL LINWID(4)
      CALL line_miss(r,wka(1:r),met(1:r,10),okm(1:r,1))
      CALL SETCLR(cyan)
      CALL line_miss(r,wka(1:r),met(1:r,4),okm(1:r,1))
      CALL SETCLR(black) ; CALL LINWID(1)
      CALL MESSAG("d) "//mnam(1),grl+300,grt+30)
      CALL ENDGRF()

      CALL LABELS('NONE','Y')
      CALL NAME('','Y')                   ! Axis name
      grl=1315 ; grr=2400 
      CALL tombox(mfy(1),mly(1),-3.9D0,3.8D0)  
      CALL SETCLR(grey) ; CALL GRID(1,1)    
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(blue)
      CALL line_miss(r,wka(1:r),met(1:r,15),okm(1:r,3))
      CALL SETCLR(red) ; CALL LINWID(4)
      CALL line_miss(r,wka(1:r),met(1:r,12),okm(1:r,3))
      CALL SETCLR(cyan)
      CALL line_miss(r,wka(1:r),met(1:r,6),okm(1:r,3))
      CALL SETCLR(black) ; CALL LINWID(1)
      CALL MESSAG("e) "//mnam(3),grl+300,grt+30)
      CALL ENDGRF() 
      CALL LABELS('FLOAT','Y')
      RETURN 
      END SUBROUTINE expvard
!-------------------------------------------------------------------
      SUBROUTINE expvar(ref1)  ! Frequency split 
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ref1
      INTEGER :: i,r,w
      REAL(8) :: mn
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="a) Yamal TRW"
      wnam(22)="b) Polar TRW"
      wnam(23)="c) Polar MXD"
      CALL det_default() ; idt=-2
      src=2 ; srcno=2        ! 2 curve RCS detrend
      IF (ref1.EQ.2) THEN
        idb=2 ; cnam(40)="Two-curve RCS, Normal Distribution" 
      ELSE
        idb=1 ; cnam(40)="Two-curve RCS, Ratios" 
      ENDIF
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend() ; r=cyr(i)
        IF (ref1.EQ.1) THEN     ! Ratios
          CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
          crn(1:r,i+6)=crn(1:r,i)/crn(1:r,i+3)         ! Ratio 100yr High Pass
          CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
          crn(1:r,i+12)=crn(1:r,i+6)/crn(1:r,i+9)      ! Ratio 15yr HP
        ELSE                    ! Differences
          CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
          crn(1:r,i+6)=crn(1:r,i)-crn(1:r,i+3)         ! 100yr High Pass
          CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
          crn(1:r,i+12)=crn(1:r,i+6)-crn(1:r,i+9)      ! 15yr HP
        ENDIF
      ENDDO
      CALL read_yclim(FA)                              ! Read met data
      r=myr(1) ; w=COUNT(okm(1:r,1)) 
      mn=SUM(met(1:r,3),MASK=okm(1:r,1))/DBLE(w)
      WHERE (okm(1:r,1)) met(1:r,3)=met(1:r,3)-mn       ! Remove mean
      r=myr(2)  ; w=COUNT(okm(1:r,2))
      mn=SUM(met(1:r,4),MASK=okm(1:r,2))/DBLE(w)
      WHERE (okm(1:r,2)) met(1:r,4)=met(1:r,4)-mn       ! Remove mean
      RETURN
      END SUBROUTINE expvar
!--------------------------------------------------------------
      SUBROUTINE end_dipd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r
      grl=200 ; grr=2400 ; grt=150 ; grb=500
      r=400 ; wka(1:r)=(/(DBLE(i),i=-r,-1)/) 
      q=1000 ; p=q-r+1
      DO j=1,3
        CALL plot_trees(r,num(p:q,j+3))  
        IF (j.EQ.1) THEN
          CALL NAME('SF Index ','Y')   ! Axis name
          CALL LABELS('NONE','X')
          CALL NAME('','X')                  ! Axis name
          CALL tombox(-400,-1,0.4D0,2.0D0)
        ELSEIF (j.EQ.2) THEN
          CALL tombox(-400,-1,0.4D0,2.0D0)
        ELSEIF (j.EQ.3) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('End Align Year','X')               ! Axis name
          CALL tombox(-400,-1,0.6D0,1.39D0)
        ENDIF
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! GRIDLINES
        CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(black) 
        CALL thickthin(r,wka(1:r),crn(p:q,j+3),num(p:q,j+3),4)
        IF (j.EQ.1) CALL MESSAG("All trees",grl+100,grt-45)
        CALL SETCLR(red) 
        CALL thickthin(r,wka(1:r),crn(p:q,j+6),num(p:q,j+6),4)
        IF (j.EQ.1) CALL MESSAG("Modern",grl+500,grt-45)
        CALL SETCLR(blue) 
        CALL thickthin(r,wka(1:r),crn(p:q,j+9),num(p:q,j+9),4)
        IF (j.EQ.1) CALL MESSAG("Sub-fossil",grl+900,grt-45)
        CALL SETCLR(black) 
        CALL MESSAG(wnam(20+j),grl+1400,grt+30)
        CALL ENDGRF() ; CALL LINWID(1) 
        grt=grt+360 ; grb=grb+360
      ENDDO  
      RETURN 
      END SUBROUTINE end_dipd
!-------------------------------------------------------------------
      SUBROUTINE end_dip() 
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxt) :: zx
      INTEGER :: i,j,p,q,r,u,v,w
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="a) Yamal TRW"
      wnam(22)="b) Polar TRW"
      wnam(23)="c) Polar MXD"
      CALL det_default() ; idt=-2 ; w=1000
      src=2 ; srcno=2
      DO j=1,3
        nc=0 ; CALL read_rft(cnam(j))
        cf=j ; CALL detrend()
        cyr(j+3)=w ; crn(1:w,j+3)=0.D0 ; num(1:w,j+3)=0
        crn(1:w,j+6)=0.D0 ; num(1:w,j+6)=0
        crn(1:w,j+9)=0.D0 ; num(1:w,j+9)=0
        DO i=1,nc   
          p=ad(i) ; r=yr(i) ; q=p+r-1 
          u=fy(i)-cfy(j)+1 ; v=u+r-1
          zx(1:r)=dx(p:q)/crn(u:v,j)      ! Signal free indices
          v=w-r+1
          WHERE (xok(p:q))
            crn(v:w,j+3)=crn(v:w,j+3)+zx(1:r)          
            num(v:w,j+3)=num(v:w,j+3)+1        
          END WHERE
          IF (ly(i).GT.1950) THEN    ! Modern trees
            WHERE (xok(p:q))
              crn(v:w,j+6)=crn(v:w,j+6)+zx(1:r)          
              num(v:w,j+6)=num(v:w,j+6)+1        
            END WHERE
          ELSE                       ! Sub-fossil
            WHERE (xok(p:q))
              crn(v:w,j+9)=crn(v:w,j+9)+zx(1:r)          
              num(v:w,j+9)=num(v:w,j+9)+1        
            END WHERE
          ENDIF
        ENDDO
        WHERE (num(1:w,j+3).GT.1) & 
          crn(1:w,j+3)=crn(1:w,j+3)/DBLE(num(1:w,j+3))
        WHERE (num(1:w,j+6).GT.1) & 
          crn(1:w,j+6)=crn(1:w,j+6)/DBLE(num(1:w,j+6))
        WHERE (num(1:w,j+9).GT.1) & 
          crn(1:w,j+9)=crn(1:w,j+9)/DBLE(num(1:w,j+9))
      ENDDO
      RETURN 
      END SUBROUTINE end_dip
!------------------------------------------------------------------------
      SUBROUTINE rcs_compd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r
      grl=200 ; grr=2400 ; grt=150 ; grb=700
      r=400 ; wka(1:r)=(/(DBLE(i),i=1,400)/) 
      CALL NAME('Ring Age','X')          ! Axis name
      CALL NAME('Ring Width (mm)','Y')    ! Axis name
      CALL tombox(1,400,0.D0,1.45D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! GRIDLINES
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(red) ; p=cfy(3) ; q=MIN(cly(3),400)
      CALL thickthin(q-p+1,wka(p:q),crn(p:q,3),num(p:q,3),4)
      CALL MESSAG("Yamal Slow",grl+650,grt-45)
      CALL SETCLR(brown) ; p=cfy(5) ; q=MIN(cly(5),400)
      CALL thickthin(q-p+1,wka(p:q),crn(p:q,5),num(p:q,5),4)
      CALL MESSAG("Yamal Fast",grl+1050,grt-45)
      CALL SETCLR(blue) ; p=cfy(4) ; q=MIN(cly(4),400)
      CALL thickthin(q-p+1,wka(p:q),crn(p:q,4),num(p:q,4),4)
      CALL MESSAG("Polar Slow",grl+1450,grt-45)
      CALL SETCLR(cyan) ; p=cfy(6) ; q=MIN(cly(6),400)
      CALL thickthin(q-p+1,wka(p:q),crn(p:q,6),num(p:q,6),4)
      CALL MESSAG("Polar Fast",grl+1850,grt-45)
      CALL SETCLR(black) 
      CALL MESSAG("RCS Curves Compared",grl+50,grt-45)
      CALL ENDGRF() ; CALL LINWID(1) 
      RETURN 
      END SUBROUTINE rcs_compd
!-------------------------------------------------------------------
      SUBROUTINE rcs_comp() 
      IMPLICIT NONE                 
      INTEGER :: i,j,m,p,q,r
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      wnam(21)="Yamal TRW"
      wnam(22)="Polar TRW"
      CALL det_default() ; idt=-2
      src=2 ; srcno=2
      crn(1:1000,3:6)=0.D0
      DO j=1,2
        nc=0 ; CALL read_rft(cnam(j))
        cf=j ; CALL detrend()
        DO i=1,2
          p=sfy(i) ; q=sly(i) ; r=q-p+1 ; m=j+i*2
          cfy(m)=p ; cly(m)=q ; cyr(m)=r
          crn(1:q,m)=msmo(1:q,i)
          num(1:q,m)=mcnt(1:q,i)
        ENDDO
      ENDDO
      RETURN 
      END SUBROUTINE rcs_comp
!------------------------------------------------------------------------
      SUBROUTINE pycrnsd(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1    ! Which sites 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER,DIMENSION(4)   :: refa
      INTEGER,PARAMETER      :: start=900  ! 1st year to process
      INTEGER,PARAMETER      :: fini=2005   ! last year to process
      INTEGER                :: i=1,j=1,p,q,r,f1,f2
      IF     (ref1.EQ.1) THEN
        f1=1 ; f2=2
      ELSEIF (ref1.EQ.2) THEN
        f1=1 ; f2=3
      ELSEIF (ref1.EQ.3) THEN
        f1=2 ; f2=3
      ENDIF 
      cnam(31)="a) All Frequencies"
      cnam(32)="b) 100-yr Low Pass"
      cnam(33)="c) 100-15yr Band Pass"
      cnam(34)="d) 15-yr High Pass"
      refa=(/0,3,9,12/)    ! Chrons
      grt=180 ; grb=580 ;  grl=240 ; grr=2400 
      r=fini-start+1 ; wka(1:r)=(/(DBLE(i),i=start,fini)/) 
      CALL LABELS('NONE','X')
      CALL NAME('z-score','Y') ! Axis name
      CALL NAME('','X')        ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL TICKS(0,'X')        ! Y ticks 
      DO j=1,4                 ! Each Figure
        IF (j.EQ.4) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')               ! Axis name
        ENDIF
        i=ref1
        p=start-cfy(f1)+1 ; q=fini-cfy(f1)+1    
        CALL tombox(start,fini,-2.9D0,+2.9D0)  
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        IF (j.EQ.1.OR.j.EQ.4) THEN
          CALL LINWID(1)

        ELSE
          CALL LINWID(4)
        ENDIF         
        CALL HEIGHT(22) ; CALL SETCLR(blue)
        CALL CURVE(wka(1:r),crn(p:q,f1+refa(j)),r)
        IF (j.EQ.1) CALL MESSAG(wnam(20+f1),grl+1000,grt-45)
        CALL SETCLR(red) 
        p=start-cfy(f2)+1 ; q=fini-cfy(f2)+1      
        CALL CURVE(wka(1:r),crn(p:q,f2+refa(j)),r)
        IF (j.EQ.1) CALL MESSAG(wnam(20+f2),grl+1500,grt-45)
        CALL SETCLR(black) ; CALL LINWID(1)
        IF (j.EQ.1) CALL MESSAG(cnam(40),grl+100,grt-45)
        CALL MESSAG(cnam(30+j),grl+400,grt+30)
        CALL ENDGRF()
        grt=grt+410 ; grb=grb+410
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL TICKS(10,'X')       ! Y ticks 
      RETURN 
      END SUBROUTINE pycrnsd
!-------------------------------------------------------------------
      SUBROUTINE pycrns()  ! Distribution of various indices 
      IMPLICIT NONE
      REAL(8)            :: sd,mn 
      INTEGER,PARAMETER  :: start=900   ! 1st year to process
      INTEGER,PARAMETER  :: fini=2005   ! last year to process
      INTEGER            :: i,n,p,q,r,ref1
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="Yamal TRW"
      wnam(22)="Polar TRW"
      wnam(23)="Polar MXD"
      CALL det_default() ; idt=-2
      src=2 ; srcno=2      ! 2 curve RCS detrend
      ref1=1 
      IF (ref1.EQ.2) THEN
        idb=1 ; cnam(40)="Two RCS Curve Ratios" 
      ELSE 
        idb=2 ; cnam(40)="Two RCS, Normal Distribution CRNs" 
      ENDIF
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend() ; r=cyr(i)          
        p=start-cfy(i)+1 ; q=fini-cfy(i)+1 ; n=q-p+1 ! Normalise 
        mn=SUM(crn(p:q,i))/DBLE(n)
        sd=SQRT(SUM((crn(p:q,i)-mn)**2)/DBLE(n-1))
        r=cyr(i)
        IF (ref1.EQ.2) THEN     ! Ratios
          CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
          crn(1:r,i+6)=crn(1:r,i)/crn(1:r,i+3)         ! Ratio 100yr High Pass
          CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
          crn(1:r,i+12)=crn(1:r,i+6)/crn(1:r,i+9)      ! Ratio 15yr HP
          crn(1:r,i)=(crn(1:r,i)-mn)/sd                 
          mn=SUM(crn(p:q,i+3))/DBLE(n)                 
          crn(1:r,i+3)=(crn(1:r,i+3)-mn)/sd            ! Remove mean, rescale by SDev
          mn=SUM(crn(p:q,i+6))/DBLE(n)                 
          crn(1:r,i+6)=(crn(1:r,i+6)-mn)/sd            ! Remove mean, rescale by SDev
          mn=SUM(crn(p:q,i+9))/DBLE(n)
          crn(1:r,i+9)=(crn(1:r,i+9)-mn)/sd            ! Remove mean, rescale by SDev
          mn=SUM(crn(p:q,i+12))/DBLE(n)
          crn(1:r,i+12)=(crn(1:r,i+12)-mn)/sd          ! Remove mean, rescale by SDev
        ELSE                    ! Differences
          crn(1:r,i)=(crn(1:r,i)-mn)/sd
          CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
          crn(1:r,i+6)=crn(1:r,i)-crn(1:r,i+3)         ! 100yr High Pass
          CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
          crn(1:r,i+12)=crn(1:r,i+6)-crn(1:r,i+9)      ! 15yr HP
        ENDIF
      ENDDO
      idb=1
      RETURN
      END SUBROUTINE pycrns
!--------------------------------------------------------------
      SUBROUTINE grid_comp()  ! Read Yamal grid box 
      IMPLICIT NONE
      LOGICAL :: covok
      REAL(8),DIMENSION(3) :: mn,sd,vv
      INTEGER :: i,j,k,r,m,p,q,s,t,u,v
      metn(1)="../../raw/yam/clim/4vT67.5N67.5E.dat"
      metn(2)="../../raw/yam/clim/4vT62.5N67.5E.dat"
      metn(3)="../../raw/yam/clim/4vT62.5N72.5E.dat"
      metn(4)="../../raw/yam/clim/4T67.5N62.5E.dat"
      metn(5)="../../raw/yam/clim/4T67.5N72.5E.dat"
      metn(6)="../../raw/yam/clim/4T72.5N67.5E.dat"
      metn(7)="../../raw/yam/clim/4T72.5N72.5E.dat" 
      metn(8)="../../raw/yam/clim/AdjvT67.5N67.5E.dat"
      met=0.D0 ; mcf=0
      OPEN(74,FILE="PY_Clim.prn",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," PY_Clim.prn")) STOP
      DO i=1,7 ; CALL read_metf(metn(i)) ; ENDDO
      crn(1:144,1:7)=0.D0
      num(1:144,1:7)=0
      DO k=1,12               ! For each month 
        DO j=k,60+k,12        ! For each site 
          DO i=j+12,72+k,12   ! For each other site 
            p=MAX(mfy(j),mfy(i))            
            q=MIN(mly(j),mly(i))            
            r=q-p+1  
            u=p-mfy(j)+1 ; v=u+r-1
            s=p-mfy(i)+1 ; t=s+r-1
            m=(j-k)+(i-k)/12+1
            CALL covmiss(met(u:v,j),met(s:t,i), &
              okm(u:v,j).AND.okm(s:t,i),r,crn(m,k),covok) 
            num(m,k)=r 
            q=(i-k)+(j-k)/12+1
            crn(q,k)=crn(m,k) 
            num(q,k)=r 
          ENDDO
        ENDDO
      ENDDO
      DO j=1,mcf,12
        WRITE(74,'("  From    To Years Count     GridBox.Month")')     
        DO i=j,MIN(j+11,mcf)  
          WRITE(74,'(4I6,"  ",A20)') mfy(i),mly(i),myr(i), &
            COUNT(okm(1:myr(i),i)),mnam(i) 
        ENDDO
        WRITE(74,*)
      ENDDO
      mess(1:54)=" (Cross correlations - 7x Counts - 7x values)"
      DO j=1,12    ! Each month
        WRITE(74,'(A3,A54)') mth(j),mess(1:54)
        DO i=1,73,12  
          WRITE(74,'(7I4,7F7.2,"  ")') num(i:i+6,j),crn(i:i+6,j)
        ENDDO
        WRITE(74,*)
      ENDDO
      WRITE(74,'("Infilling Report")')
      DO i=1,12     ! For each month
        u=1900-mfy(i)+1 ; v=1940-mfy(i)+1 
        DO j=1,3    ! Mean and SDev 1900-1940
          k=(j-1)*12+i  
          p=1900-mfy(k)+1 ; q=1940-mfy(k)+1 
          okm(p:q,150)=okm(p:q,k).AND.okm(u:v,i)
          r=COUNT(okm(p:q,150))  ! Common period years
          mn(j)=SUM(met(p:q,k),MASK=okm(p:q,150))/DBLE(r)
          sd(j)=SQRT(SUM((met(p:q,k)-mn(j))**2, &
                MASK=okm(p:q,150))/DBLE(r-1))
        ENDDO
        WRITE(74,*)
        WRITE(74,'(A3,"   mn1   mn2   mn3   sd1   sd2   sd3",A13)') &
          mth(i),"  (1900-1940)"
        WRITE(74,'(3X,6F6.1)') mn,sd
        WRITE(74,*)
        WRITE(74,'("  Year  Insert     67E     72E")')
        DO j=1,myr(i)
          IF (.NOT.okm(j,i)) THEN
            vv=-999.D0
            k=j+mfy(i)-mfy(i+12) 
            IF (k.GT.0.AND.okm(k,i+12)) THEN
              vv(2)=met(k,i+12)
            ELSE 
              vv(2)=-999.D0       ! Value missing
            ENDIF
            k=j+mfy(i)-mfy(i+24)  ! 2 starts later
            IF (k.GT.0.AND.okm(k,i+24)) THEN
              vv(3)=met(k,i+24)
            ELSE 
              vv(3)=-999.D0       ! Value missing
            ENDIF
            IF (vv(2).NE.-999.D0.AND.vv(3).NE.-999.D0) THEN  ! Estimate from both
              vv(1)= ((vv(2)-mn(2))/sd(2)+(vv(3)-mn(3))/ &
                 sd(3))*sd(1)/2.D0+mn(1)
            ELSEIF (vv(2).NE.-999.D0) THEN    ! Estimate from first
              vv(1)= ((vv(2)-mn(2))/sd(2))*sd(1)+mn(1)
            ELSEIF (vv(3).NE.-999.D0) THEN    ! Estimate from second
              vv(1)= ((vv(3)-mn(3))/sd(3))*sd(1)+mn(1)
            ELSE
              vv(1)=-999.D0    ! Value still missing
            ENDIF  
            IF (vv(1).NE.-999.D0) THEN  ! Insert estimate
              okm(j,i)=TR ; met(j,i)=vv(1) 
            ENDIF
            WRITE(74,'(I6,3F8.1)') j+mfy(i)-1,vv
          ENDIF
        ENDDO
      ENDDO
      CLOSE(74)             ! Save adjusted data
      OPEN(56,FILE=metn(8),IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open ",metn(8))) STOP
      WRITE(56,'(A48,8X,2I4)',IOSTAT=ios) &
        " T67.5N  67.5E  CRUTEM4  Temperature Anomaly Adj", &
        mfy(1),mly(1) ! Read header first/last year
      IF (io_err("Write1 ",metn(8))) STOP
      DO i=1,myr(1)            ! Write each year
        WRITE(56,'(I4,12I5)',IOSTAT=ios) i-1+mfy(1),NINT(met(i,1:12))
        IF (io_err("Write2 ",metn(8))) STOP
      ENDDO
      CLOSE(56)
      RETURN
      END SUBROUTINE grid_comp
!--------------------------------------------------------------
      SUBROUTINE py_statd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy)   :: wka
      INTEGER                  :: i=1,j=1,p,q,r
      CHARACTER(6),DIMENSION(6:8) :: month
      month=(/"June  ","July  ","August"/)
      grl=200 ; grr=2400 ; grt=140 ; grb=540
      p=MINVAL(mfy(1:24)) ; q=MAXVAL(mly(1:24))
      r=q-p+1
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME("Degrees C/10",'Y')  ! Axis name
      DO j=6,8                       ! Summer months
        IF (j.EQ.8) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')               ! Axis name
        ENDIF
        CALL tombox(p,q,-60.D0,+65.D0) ! Degrees C anomaly
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        CALL LINWID(4) ; CALL HEIGHT(22)
        CALL SETCLR(blue)
        r=myr(j) ; wka(1:r)=(/(DBLE(i),i=mfy(j),mly(j))/) 
        CALL line_miss(r,wka(1:r),met(1:r,j),okm(1:r,j))
        IF (j.EQ.6) CALL MESSAG("Grid Box Data",grl+400,grt-45)
        CALL SETCLR(red)
        r=myr(j+12) ; wka(1:r)=(/(DBLE(i),i=mfy(j+12),mly(j+12))/) 
        CALL line_miss(r,wka(1:r),met(1:r,j+12),okm(1:r,j+12))
        IF (j.EQ.6) CALL MESSAG("Salekhard",grl+1200,grt-45)
        CALL SETCLR(black)
        CALL MESSAG(month(j),grl+800,grt+30)
        CALL ENDGRF() ; CALL LINWID(1) 
        grt=grt+410 ; grb=grb+410
      ENDDO
      RETURN 
      END SUBROUTINE py_statd
!-------------------------------------------------------------------
      SUBROUTINE py_stat()  ! Grid v Station data 
      IMPLICIT NONE
      REAL(8) :: mn
      INTEGER :: i=1,r
      metn(1)="../../raw/yam/clim/AdjvT67.5N67.5E.dat"
      metn(2)="../../raw/yam/clim/Salehard.dat"
      met=0.D0 ; mcf=0
      DO i=1,2 ; CALL read_metf(metn(i)) ; ENDDO
      DO i=1,24   ! Anomalies from mean
        r=myr(i) 
        mn=SUM(met(1:r,i),MASK=okm(1:r,i))/ &
           DBLE(COUNT(okm(1:r,i)))
        WHERE (okm(1:r,i)) met(1:r,i)=met(1:r,i)-mn
      ENDDO
      RETURN
      END SUBROUTINE py_stat
!--------------------------------------------------------------
      SUBROUTINE py_colsd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER,PARAMETER      :: start=900  ! 1st year to process
      INTEGER,PARAMETER      :: fini=2006  ! last year to process
      INTEGER                :: i=1,j=1,p,q,r
      cnam(31)="a) All Frequencies"
      cnam(32)="b) 15-yr High Pass"
      cnam(33)="c) 100-15yr Band Pass"
      cnam(34)="d) 100-yr Low Pass"
      grt=180 ; grb=580 ;  grl=240 ; grr=2400 
      r=fini-start+1 ; wka(1:r)=(/(DBLE(i),i=start,fini)/) 
      CALL LABELS('NONE','X')
      CALL NAME('','X')        ! Axis name
      CALL NAME('z-score','Y')         ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL TICKS(0,'X')        ! Y ticks 
      DO j=1,4                 ! Each Figure
        IF (j.EQ.4) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')  ! Axis name
        ENDIF
        CALL tombox(start,fini,-1.9D0,+1.9D0)  
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        IF (j.EQ.1.OR.j.EQ.2) THEN
          CALL LINWID(1)
        ELSE
          CALL LINWID(4)
        ENDIF         
        CALL HEIGHT(22) ; CALL SETCLR(blue)
        p=start-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 
        CALL CURVE(wka(1:r),crn(p:q,1+j*4),r)
        IF (j.EQ.1) CALL MESSAG(wnam(1),grl+100,grt-45)
        CALL SETCLR(red) 
        p=start-cfy(2)+1 ; q=cyr(2) ; r=q-p+1 
        CALL CURVE(wka(1:r),crn(p:q,2+j*4),r)
        IF (j.EQ.1) CALL MESSAG(wnam(2),grl+600,grt-45)
        CALL SETCLR(cyan) 
        p=start-cfy(3)+1 ; q=cyr(3) ; r=q-p+1 
        CALL CURVE(wka(1:r),crn(p:q,3+j*4),r)
        IF (j.EQ.1) CALL MESSAG(wnam(3),grl+1100,grt-45)
        CALL SETCLR(black) ; CALL LINWID(1)
        CALL MESSAG(cnam(j+30),grl+400,grt+30)
        CALL ENDGRF() 
        grt=grt+410 ; grb=grb+410
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL TICKS(10,'X')       ! Y ticks 
      RETURN 
      END SUBROUTINE py_colsd
!-------------------------------------------------------------------
      SUBROUTINE py_cols()  ! Save output series
      IMPLICIT NONE
      REAL(8),DIMENSION(mxd) :: zx
      INTEGER                :: i,j,k,n,m
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(1)="Yamal TRW"
      wnam(2)="Polar TRW"
      wnam(3)="Polar MXD"
      wnam(4)="Yamalia TRW"
      CALL det_default() ; idt=-2 ; isb=1 ; sfo=2 ; tst=4
      src=2 ; srcno=2 ; idb=2    ! 2 curve RCS detrend - normal dist
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend()
        CALL py_cols2()          ! Uses dx 
        IF (i.EQ.1) THEN
          n=ad(nc)+yr(nc)-1      ! Yamal indices added to Yamalia
          zx(1:n)=dx(1:n)
        ELSEIF (i.EQ.2) THEN
          m=ad(nc)+yr(nc)-1      ! Polar indices added to Yamalia
          zx(n+1:n+m)=dx(1:m)
        ENDIF 
      ENDDO
      nc=0 ; CALL read_rft(cnam(1)) 
      CALL read_rft(cnam(2))     ! Read tree data
      cf=4 ; CALL det_crnfy()    ! Set up chronology
      dx(1:n+m)=zx(1:n+m)        ! Use previously saved tree indices  
      CALL arith_mean(dx)        ! Create chronology
      k=cyr(cf) ; crn(1:k,cf)=xcrn(1:k,mx)
      CALL py_cols2() ; append=FA ! Uses dx 
      CALL write_index("YamPol.crn") ; append=TR
      cf=1 ; CALL write_index("YamPol.crn")
      cf=2 ; CALL write_index("YamPol.crn")
      cf=3 ; CALL write_index("YamPol.crn")
      OPEN(19,FILE="PY_Chrons.prn",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," PY_Chrons.prn")) STOP
      DO i=1,4
        WRITE(19,'(A12,4A14,"  Filtered Chronology")') &
          wnam(i)(1:12),"    Chronology", &
          "    High Pass","    Band Pass","     Low Pass"
        WRITE(19,'("  Year Count",4("  Index   2*SE"),A21)') &
          "   High   Band    Low"
        DO j=1,cyr(i)
          WRITE(19,'(2I6,12F7.3)') j-1+cfy(i),num(j,i),crn(j,4+i), &
            crn(j,20+i),crn(j,8+i),crn(j,24+i),crn(j,12+i), &
            crn(j,28+i),crn(j,16+i),crn(j,32+i), &
            crn(j,36+i),crn(j,40+i),crn(j,44+i)
        ENDDO 
        WRITE(19,*)
      ENDDO
      CLOSE(19) ; idb=1
      RETURN
      END SUBROUTINE py_cols
!--------------------------------------------------------------
      SUBROUTINE py_cols2()  ! Save output series
      IMPLICIT NONE
      REAL(8),DIMENSION(mxd) :: zx
      INTEGER,PARAMETER      :: wk=70       ! Working storage offset  
      REAL(8)                :: sd,mn 
      INTEGER                :: i,p,q,r,u,v
      crn(1:mxy,wk:wk+12)=0.D0
      num(1:mxy,wk:wk+12)=0
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1   ! Ring address
        u=fy(i)-cfy(cf)+1 ; v=u+r-1   ! Chronology address 
        IF (idb.EQ.1) THEN     ! Ratios
          CALL splinet(r,dx(p:q),100,zx(p:q))      ! 100yr Low Pass   
          tx(p:q)=dx(p:q)/zx(p:q)                  ! Ratio 100yr High Pass
          CALL splinet(r,tx(p:q),15,cx(p:q))       ! 100-15yr Band Pass   
          ax(p:q)=tx(p:q)/cx(p:q)                  ! Ratio 15yr HP
        ELSE                    ! Normal distribution (differences)
          CALL splinet(r,dx(p:q),100,zx(p:q))      ! 100yr Low Pass   
          tx(p:q)=dx(p:q)-zx(p:q)                  ! Difference 100yr High Pass
          CALL splinet(r,tx(p:q),15,cx(p:q))       ! 100-15yr Band Pass   
          ax(p:q)=tx(p:q)-cx(p:q)                  ! Difference 15yr HP
        ENDIF
        WHERE (xok(p:q))
          crn(u:v,wk+1)=crn(u:v,wk+1)+dx(p:q)      ! Full CRN 
          crn(u:v,wk+2)=crn(u:v,wk+2)+dx(p:q)**2
          crn(u:v,wk+4)=crn(u:v,wk+4)+ax(p:q)      ! 15yr High pass 
          crn(u:v,wk+5)=crn(u:v,wk+5)+ax(p:q)**2
          crn(u:v,wk+7)=crn(u:v,wk+7)+cx(p:q)      ! 100-15 Band pass 
          crn(u:v,wk+8)=crn(u:v,wk+8)+cx(p:q)**2
          crn(u:v,wk+10)=crn(u:v,wk+10)+zx(p:q)    ! 100yr Low pass 
          crn(u:v,wk+11)=crn(u:v,wk+11)+zx(p:q)**2
        END WHERE
      ENDDO
      r=cyr(cf)
      WHERE (num(1:r,cf).GE.1) 
        crn(1:r,cf+4)=crn(1:r,wk+1)/DBLE(num(1:r,cf))   ! Chronology  
        crn(1:r,cf+8)=crn(1:r,wk+4)/DBLE(num(1:r,cf))   ! 15yr High pass  
        crn(1:r,cf+12)=crn(1:r,wk+7)/DBLE(num(1:r,cf))  ! 100-15 Band pass  
        crn(1:r,cf+16)=crn(1:r,wk+10)/DBLE(num(1:r,cf)) ! 100yr Low pass   
      END WHERE
      WHERE (num(1:r,cf).GT.3) 
        crn(1:r,cf+20)=SQRT(MAX(crn(1:r,wk+2)-crn(1:r,cf+4)* &  
          crn(1:r,wk+1),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
        crn(1:r,cf+24)=SQRT(MAX(crn(1:r,wk+5)-crn(1:r,cf+8)* &  
          crn(1:r,wk+4),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
        crn(1:r,cf+28)=SQRT(MAX(crn(1:r,wk+8)-crn(1:r,cf+12)* &  
          crn(1:r,wk+7),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
        crn(1:r,cf+32)=SQRT(MAX(crn(1:r,wk+11)-crn(1:r,cf+16)* &  
          crn(1:r,wk+10),0.001D0)/DBLE(num(1:r,cf)-1))   ! SDev 
      END WHERE
      crn(1:r,wk+1)=SQRT(DBLE(num(1:r,cf)))/2.D0
      WHERE (num(1:r,cf).GE.3) 
        crn(1:r,cf+20)=crn(1:r,cf+20)/crn(1:r,wk+1) ! Standard Error
        crn(1:r,cf+24)=crn(1:r,cf+24)/crn(1:r,wk+1) ! Standard Error
        crn(1:r,cf+28)=crn(1:r,cf+28)/crn(1:r,wk+1) ! Standard Error
        crn(1:r,cf+32)=crn(1:r,cf+32)/crn(1:r,wk+1) ! Standard Error
      ELSEWHERE
        crn(1:r,cf+20)=0.D0
        crn(1:r,cf+24)=0.D0
        crn(1:r,cf+28)=0.D0
        crn(1:r,cf+32)=0.D0
      END WHERE
      r=cyr(cf) ; mn=SUM(crn(1:r,cf))/DBLE(r)    ! Normalise full period
      sd=SQRT(SUM((crn(1:r,cf)-mn)**2)/DBLE(r-1))
      IF (idb.EQ.1) THEN     ! Ratios
        CALL splinet(r,crn(1:r,cf),100,crn(1:r,cf+44)) ! 100yr Low Pass   
        crn(1:r,wk)=crn(1:r,cf)/crn(1:r,cf+44)         ! Ratio 100yr High Pass
        CALL splinet(r,crn(1:r,wk),15,crn(1:r,cf+40))  ! 100-15yr Band Pass   
        crn(1:r,cf+36)=crn(1:r,wk)/crn(1:r,cf+40)      ! Ratio 15yr HP
        crn(1:r,cf)=(crn(1:r,cf)-mn)/sd                 
        mn=SUM(crn(1:r,cf+44))/DBLE(r)                 
        crn(1:r,cf+44)=(crn(1:r,cf+44)-mn)/sd          ! Remove mean, rescale by SDev
        mn=SUM(crn(p:q,cf+40))/DBLE(r)                 
        crn(1:r,cf+40)=(crn(1:r,cf+40)-mn)/sd          ! Remove mean, rescale by SDev
        mn=SUM(crn(p:q,cf+36))/DBLE(r)
        crn(1:r,cf+36)=(crn(1:r,cf+36)-mn)/sd          ! Remove mean, rescale by SDev
      ELSE                    ! Differences
        CALL splinet(r,crn(1:r,cf),100,crn(1:r,cf+44)) ! 100yr Low Pass   
        crn(1:r,wk)=crn(1:r,cf)-crn(1:r,cf+44)         ! 100yr High Pass
        CALL splinet(r,crn(1:r,wk),15,crn(1:r,cf+40))  ! 100-15yr Band Pass   
        crn(1:r,cf+36)=crn(1:r,wk)-crn(1:r,cf+40)      ! 15yr HP
      ENDIF
      RETURN
      END SUBROUTINE py_cols2
!--------------------------------------------------------------
      SUBROUTINE py_sits2d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER,PARAMETER      :: start=900  ! 1st year to process
      INTEGER,PARAMETER      :: fini=2006  ! last year to process
      INTEGER                :: i=1,j=1,n,p,q,r
      wnam(31)="All Frequencies"
      wnam(32)="15-yr High Pass"
      wnam(33)="100-15yr Band Pass"
      wnam(34)="100-yr Low Pass"
      wnam(41)="a)" ; wnam(42)="b)" ; wnam(43)="c)" ; wnam(44)="d)"
      grt=180 ; grb=580 ;  grl=240 ; grr=2400 
      r=fini-start+1 ; wka(1:r)=(/(DBLE(i),i=start,fini)/) 
      CALL LABELS('NONE','X')
      CALL LABELS('NONE','Y')
      CALL NAME('','X')        ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL TICKS(0,'X')        ! Y ticks 
      DO j=1,4                 ! Each Figure
        IF (j.EQ.4) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')  ! Axis name
        ENDIF
        CALL NAME(wnam(j+30),'Y')         ! Axis name
        CALL tombox(start,fini,-1.D0,+7.D0)  
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22) 
        IF (j.EQ.1) THEN
          CALL SETCLR(black) ; CALL MESSAG("Two Standard Errors",grl+20,grt-45)
          CALL SETCLR(blue)  ; CALL MESSAG(wnam(1),grl+600 ,grt-45)
          CALL SETCLR(red)   ; CALL MESSAG(wnam(2),grl+1000,grt-45)
          CALL SETCLR(cyan)  ; CALL MESSAG(wnam(3),grl+1400,grt-45)
          CALL SETCLR(green) ; CALL MESSAG(wnam(4),grl+1800,grt-45)
        ENDIF
        CALL LINWID(4) ; CALL SETCLR(blue) ; n=j*4+16
        p=start-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 
        DO i=p,q
          CALL RLINE(wka(i-p+1),crn(i,n+1),wka(i-p+1),-crn(i,n+1))
        ENDDO
        p=start-cfy(2)+1 ; q=cyr(2) ; r=q-p+1 
        CALL SETCLR(red)
        DO i=p,q
          CALL RLINE(wka(i-p+1),crn(i,n+2)+2.D0,wka(i-p+1),-crn(i,n+2)+2.D0)
        ENDDO
        p=start-cfy(3)+1 ; q=cyr(3) ; r=q-p+1 
        CALL SETCLR(cyan)
        DO i=p,q
          CALL RLINE(wka(i-p+1),crn(i,n+3)+4.D0,wka(i-p+1),-crn(i,n+3)+4.D0)
        ENDDO
        p=start-cfy(4)+1 ; q=cyr(4) ; r=q-p+1 
        CALL SETCLR(green)
        DO i=p,q
          CALL RLINE(wka(i-p+1),crn(i,n+4)+6.D0,wka(i-p+1),-crn(i,n+4)+6.D0)
        ENDDO
        CALL SETCLR(black) ; CALL LINWID(1)
        CALL MESSAG(wnam(40+j),grl+20,grt+100)
        CALL ENDGRF() ; grt=grt+410 ; grb=grb+410
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL TICKS(10,'X')       ! Y ticks 
      RETURN 
      END SUBROUTINE py_sits2d
!-------------------------------------------------------------------
      SUBROUTINE expvrepd()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: cst=1883  ! First met year
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER,DIMENSION(4)   :: refa,refb
      INTEGER                :: i=1,j=1,m,n,p,q,r
      wnam(31)="All Frequencies"
      wnam(32)="15-yr High Pass"
      wnam(33)="100-15yr Band Pass"
      wnam(34)="100-yr Low Pass"
      wnam(36)="Normal RCS"
      wnam(37)="Temperature"
      refa=(/15,18,21,24/)    ! Chrons
      refb=(/0,12,9,3/)       ! Met  
      grt=180 ; grb=580
      m=myr(1) ; wka(1:m)=(/(DBLE(i),i=mfy(1),mly(1))/) 
      CALL LABELS('NONE','X')
      CALL NAME('','X')        ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL TICKS(0,'X')        ! Y ticks 
      DO j=1,4                 ! Each Figure
        IF (j.EQ.4) THEN  
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')               ! Axis name
        ENDIF
        grl=240 ; grr=1000 
        DO i=1,3         ! Each site
          IF (i.EQ.1) THEN  
            CALL LABELS('FLOAT','Y')
            CALL NAME(wnam(j+30),'Y')      ! Axis name
          ELSE
            CALL LABELS('NONE','Y')
            CALL NAME('','Y')               ! Axis name
          ENDIF
          p=cst-cfy(i)+1 ; q=cyr(i) ; r=q-p+1     
          CALL tombox(cst,2005,-2.9D0,+2.9D0)   ! TRW
          CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
          CALL LINWID(4) ; CALL HEIGHT(22)
          CALL SETCLR(blue)
          IF (j.EQ.1.AND.i.EQ.2) CALL MESSAG(wnam(34+i),grl+300,grt-45)
          CALL CURVE(wka(1:r),crn(p:q,i+refa(j)),r)
          CALL SETCLR(red) 
          IF (j.EQ.1.AND.i.EQ.3) CALL MESSAG(wnam(34+i),grl+300,grt-45)
          n=i+refb(j) 
          CALL line_miss(m,wka(1:m),met(1:m,n),okm(1:m,n))
          CALL SETCLR(black)
          IF (j.EQ.1.AND.i.EQ.1) CALL MESSAG(cnam(40),grl+500,grt-90)
          IF (j.EQ.1) CALL MESSAG(wnam(20+i),grl+30,grt-45)
          CALL ENDGRF() ; CALL LINWID(1) 
          grl=grl+780 ; grr=grr+780 
        ENDDO
        grt=grt+410 ; grb=grb+410
      ENDDO
      CALL LABELS('FLOAT','Y')
      CALL TICKS(5,'Y')        ! Y ticks 
      CALL TICKS(10,'X')       ! Y ticks 
      RETURN 
      END SUBROUTINE expvrepd
!-------------------------------------------------------------------
      SUBROUTINE expvdat()  ! Correlation report 
      IMPLICIT NONE
      INTEGER,PARAMETER    :: cst=1883  ! First met year
      REAL(8)              :: sd 
      REAL(8),DIMENSION(4) :: mn 
      INTEGER              :: i,j,k,n,p,q,r
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      CALL det_default() ; idt=-2 ; isb=1 ; sfo=2 ; tst=4
      src=2 ; srcno=2 ; idb=2  ! Two-curve Normal RCS detrend
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend()   ! 1-3 = 2 RCS curve normal distribution 
      ENDDO 
      DO j=1,2
        DO i=1,3
          r=cyr(i)
          IF (j.EQ.1) THEN       ! 4-12 = Normalise full period
            p=1 ; q=r ; n=r                    
          ELSE                   ! 13-21 = Normalise 1883-2005
            p=cst-cfy(i)+1 ; q=cyr(i) ; n=q-p+1 
          ENDIF
          mn(1)=SUM(crn(p:q,i))/DBLE(n)
          sd=SQRT(SUM((crn(p:q,i)-mn(1))**2)/DBLE(n-1))
! Separate filtered versions using differences
          k=(j-1)*12+3+i
          crn(1:r,k)=(crn(1:r,i)-mn(1))/sd
          CALL splinet(r,crn(1:r,k),100,crn(1:r,k+9))  ! 100yr Low Pass   
          crn(1:r,99)=crn(1:r,k)-crn(1:r,k+9)          ! 100yr High Pass
          CALL splinet(r,crn(1:r,99),15,crn(1:r,k+6))  ! 100-15yr Band Pass   
          crn(1:r,k+3)=crn(1:r,99)-crn(1:r,k+6)        ! 15yr HP
        ENDDO
      ENDDO
      CALL read_yclim(TR)  ! Read met data
      idb=1
      RETURN
      END SUBROUTINE expvdat
!--------------------------------------------------------------
      SUBROUTINE expvrep()  ! Correlation report 
      IMPLICIT NONE
      INTEGER,PARAMETER      :: cst=1883, cend=2005 ! First met year
      REAL(8),DIMENSION(3,3) :: corr
      REAL(8),DIMENSION(3,4) :: mcr 
      REAL(8),DIMENSION(3,3) :: mcor
      LOGICAL                :: covok 
      INTEGER                :: i,k,p,q,r,u,v
      OPEN(74,FILE="ClimVar.prn",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," ClimVar.prn")) STOP
      wnam(21)="Yamal TRW"
      wnam(22)="Polar TRW"
      wnam(23)="Polar MXD"
      wnam(27)="JJ-Yam"
      wnam(28)="JJ-Pol"
      wnam(29)="JJA MXD"
      CALL expvdat()
      OPEN(79,FILE="PY_Clim.dat",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," PY_Clim.dat")) STOP
      WRITE(79,'(6X,4A24)') "       Mean Monthly     ", &
        "        High Pass       ","        Band Pass       ", &
        "         Low Pass       "
      WRITE(79,'("  Year",4("  JJ-Yam  JJ-Pol JJA-MXD"))')
      DO i=1,myr(1)
        WRITE(79,'(I6,12F8.3)') i-1+mfy(1), &
          met(i,1:3),met(i,13:15),met(i,10:12),met(i,4:6)
      ENDDO 
      WRITE(79,*) ; CLOSE(79) 

      WRITE(74,'("Common Period     HP      BP      LP     Sum")') 
      WRITE(74,'("Chronologies Internal Variance")') 
      DO i=1,3 
        p=872-cfy(i)+1 ; q=2005-cfy(i)+1 ; r=q-p+1
        CALL cov(crn(p:q,6+i),crn(p:q,3+i),r,corr(i,1))  ! HP 
        CALL cov(crn(p:q,9+i),crn(p:q,3+i),r,corr(i,2))  ! BP
        CALL cov(crn(p:q,12+i),crn(p:q,3+i),r,corr(i,3)) ! LP
        corr(i,1:3)=corr(i,1:3)**2
        WRITE(74,'(2I6,4F8.2,"  ",A20)') 872,2005, &
          corr(i,1:3),SUM(corr(i,1:3)),wnam(20+i)
      ENDDO
      WRITE(74,'("Chronologies Variance Proportion")') 
      DO i=1,3 
        WRITE(74,'(2I6,4F8.2,"  ",A20)') 872,2005, &
          corr(i,1:3)/SUM(corr(i,1:3)),1.D0,wnam(20+i)
      ENDDO
      WRITE(74,*)

      WRITE(74,'("Climate period    HP      BP      LP     Sum")') 
      WRITE(74,'("Chronologies Internal Variance")') 
      DO i=1,3 
        p=cst-cfy(i)+1 ; q=cend-cfy(i)+1 ; r=q-p+1 
        CALL cov(crn(p:q,18+i),crn(p:q,15+i),r,corr(i,1))  ! HP 
        CALL cov(crn(p:q,21+i),crn(p:q,15+i),r,corr(i,2))  ! BP
        CALL cov(crn(p:q,24+i),crn(p:q,15+i),r,corr(i,3))  ! LP
        corr(i,1:3)=corr(i,1:3)**2
        WRITE(74,'(2I6,4F8.2,"  ",A20)') cst,cend, &
          corr(i,1:3),SUM(corr(i,1:3)),wnam(20+i)
      ENDDO
      WRITE(74,'("Chronologies Variance Proportion")') 
      DO i=1,3 
        WRITE(74,'(2I6,4F8.2,"  ",A20)') cst,cend, &
          corr(i,1:3)/SUM(corr(i,1:3)),1.D0,wnam(20+i)
      ENDDO

      WRITE(74,*)
      WRITE(74,'("Climate period    HP      BP      LP     Sum")') 
      WRITE(74,'("Climate Internal Variance")') 
      DO i=1,3
        p=cst-mfy(i)+1 ; q=cend-mfy(i)+1 ; r=myr(i) 
        CALL covmiss(met(p:q,i),met(p:q,12+i),okm(p:q,i),r,mcor(i,1),covok) 
        CALL covmiss(met(p:q,i),met(p:q,9+i) ,okm(p:q,i),r,mcor(i,2),covok) 
        CALL covmiss(met(p:q,i),met(p:q,3+i) ,okm(p:q,i),r,mcor(i,3),covok) 
        mcor(i,1:3)=mcor(i,1:3)**2
        WRITE(74,'(2I6,4F8.2,"  ",A20)') cst,cend, &
              mcor(i,1:3),SUM(mcor(i,1:3)),wnam(26+i)
      ENDDO
      WRITE(74,'("Climate Variance Proportion")') 
      DO i=1,3 
        WRITE(74,'(2I6,4F8.2,"  ",A20)') cst,cend, &
          mcor(i,1:3)/SUM(mcor(i,1:3)),1.D0,wnam(26+i)
      ENDDO

      WRITE(74,*)
      WRITE(74,'("Climate Period   All      HP      BP      LP     Sum")') 
      WRITE(74,'("Trees to Full Climate Variance")') 
      DO i=1,3 
        k=MOD(i-1,3)+1   ! JJ Yam, JJ Pol, JJA MXD 
        p=cst-cfy(i)+1 ; q=cend-cfy(i)+1 ; r=q-p+1 
        u=cst-mfy(i)+1 ; v=cend-mfy(i)+1  
        CALL covmiss(met(u:v,k),crn(p:q,15+i),okm(u:v,k),r,mcr(i,1),covok) ! All
        CALL covmiss(met(u:v,k),crn(p:q,18+i),okm(u:v,k),r,mcr(i,2),covok) ! HP
        CALL covmiss(met(u:v,k),crn(p:q,21+i),okm(u:v,k),r,mcr(i,3),covok) ! BP
        CALL covmiss(met(u:v,k),crn(p:q,24+i),okm(u:v,k),r,mcr(i,4),covok) ! LP
        mcr(i,1:4)=mcr(i,1:4)**2
        WRITE(74,'(2I6,5F8.2,"  ",A20)') cst,cend, &
              mcr(i,1:4),SUM(mcr(i,2:4)),wnam(20+i)
      ENDDO
      WRITE(74,'("Trees to Full Climate Variance Proportion")') 
      DO i=1,3 
        WRITE(74,'(2I6,8X,4F8.2,"  ",A20)') cst,cend, &
              mcr(i,2:4)/SUM(mcr(i,2:4)),1.D0,wnam(20+i)
      ENDDO
      WRITE(74,*)
      WRITE(74,'("Climate Period   All      HP      BP      LP     Sum")') 
      WRITE(74,'("Trees to Climate Sub-sets Variance")') 
      DO i=1,3 
        k=MOD(i-1,3)+1   ! JJ Yam, JJ Pol, JJA MXD 
        p=cst-cfy(i)+1 ; q=cend-cfy(i)+1 ; r=q-p+1 
        u=cst-mfy(i)+1 ; v=cend-mfy(i)+1  
        CALL covmiss(met(u:v,k)  ,crn(p:q,15+i),okm(u:v,k),r,mcr(i,1),covok) ! All
        CALL covmiss(met(u:v,k+6),crn(p:q,18+i),okm(u:v,k),r,mcr(i,2),covok) ! HP
        CALL covmiss(met(u:v,k+9),crn(p:q,21+i),okm(u:v,k),r,mcr(i,3),covok) ! BP
        CALL covmiss(met(u:v,k+3),crn(p:q,24+i),okm(u:v,k),r,mcr(i,4),covok) ! LP
        mcr(i,1:4)=mcr(i,1:4)**2
        WRITE(74,'(2I6,5F8.2,"  ",A18)') cst,cend, &
          mcr(i,1:4),SUM(mcr(i,2:4)),wnam(20+i)(1:9)//" v "//wnam(26+i)(1:6)
      ENDDO
      CLOSE(74)
      RETURN
      END SUBROUTINE expvrep
!--------------------------------------------------------------
      SUBROUTINE py100_compd()  
      IMPLICIT NONE              
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      w=MAXVAL(cyr(4:6)) ; r=(w+1)/2
      wka(1:w)=(/(DBLE(i),i=cfy(4),cfy(4)+w-1)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=850 
      CALL NAME('','X')
      CALL NAME('z-score','Y')   ! Axis name
      CALL tombox(cfy(4),cfy(4)+r-1,-3.D0,3.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue)  ; CALL CURVE(wka(1:r),crn(1:r,4),r) 
      CALL MESSAG(wnam(21),grl+800,grt-45)
      CALL SETCLR(red)   ; CALL CURVE(wka(1:r),crn(1:r,5),r) 
      CALL MESSAG(wnam(22),grl+1250,grt-45)
      CALL SETCLR(black) ; CALL CURVE(wka(1:r),crn(1:r,6),r) 
      CALL MESSAG(wnam(23),grl+1700,grt-45)
      CALL MESSAG("100-yr Spline Chronologies",grl+40,grt-45)
      CALL ENDGRF()
      grt=930 ; grb=1630
      CALL NAME('Calendar Year','X')
      CALL tombox(cfy(4)+w-r,cfy(4)+w-1,-3.D0,3.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(blue) ; p=w-r+1 ; q=cyr(4) 
      CALL CURVE(wka(p:q),crn(p:q,4),q-p+1) 
      CALL SETCLR(red) ; q=cyr(5) 
      CALL CURVE(wka(p:q),crn(p:q,5),q-p+1) 
      CALL SETCLR(black) ; q=cyr(6)
      CALL CURVE(wka(p:q),crn(p:q,6),q-p+1) 
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE py100_compd
!-------------------------------------------------------------------
      SUBROUTINE py100_comp()  ! Frequency split 
      IMPLICIT NONE
      INTEGER :: i,p,q,r,u,v,w
      REAL(8) :: nr,mn,sd
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="Yamal TRW"
      wnam(22)="Polar TRW"
      wnam(23)="Polar MXD"
      CALL det_default() ; idt=100  ! 100-yr spline detrend
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i)) 
        cf=i ; CALL detrend() 
      ENDDO
      p=MAXVAL(cfy(1:3)) ; q=MINVAL(cly(1:3))
      r=q-p+1 ; nr=DBLE(r)
      DO i=1,3     ! Normalise common period
        u=p-cfy(i)+1 ; v=u+r-1
        mn=SUM(crn(u:v,i))/nr                 
        sd=SQRT(SUM((crn(u:v,i)-mn)**2)/(nr-1.D0))
        v=cyr(i) ; w=v-u+1
        cfy(i+3)=p ; cly(i+3)=cly(i) ; cyr(i+3)=w
        crn(1:w,i+3)=(crn(u:v,i)-mn)/sd
        num(1:w,i+3)=num(u:v,i) 
      ENDDO
      RETURN
      END SUBROUTINE py100_comp
!--------------------------------------------------------------
      SUBROUTINE yml_khadd()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=12  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,u,v
      grl=200 ; grr=2400 ; grt=150 ; grb=600
      p=cfy(6) ; q=cly(6) ; r=cyr(6)
      wka(1:r)=(/(DBLE(i),i=cfy(7),cly(7))/) 
      CALL NAME('','X')   ! Axis name
      CALL LABELS('NONE','X')
      CALL NAME('Index Values','Y')   ! Axis name
      CALL plot_trees(r,num(p:q,6))  
      CALL tombox(cfy(7),cly(7),0.D0,2.3D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(red)
      CALL thickthin(r,wka(1:r),crn(p:q,6),num(p:q,6),5)
      CALL MESSAG("a) KHAD Chronology",grl+300,grt+30)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(p:q,1),num(p:q,1),5)
      CALL MESSAG("Yamal Chronology",grl+800,grt+30)
      CALL ENDGRF()

      grt=610 ; grb=1050
      CALL NAME('Calendar Year','X')
      CALL LABELS('FLOAT','X')
      CALL tombox(cfy(7),cly(7),0.D0,2.4D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=num(1,50),num(2,50)   ! Plot KHAD trees 
        p=ad(i) ; r=yr(i) ; q=p+r-1
        u=fy(i)-cfy(7)+1 ; v=u+r-1
        CALL SETCLR(MOD(i,12)+1)
        CALL line_miss(r,wka(u:v),tx(p:q),xok(p:q))
      ENDDO 
      CALL SETCLR(black) ; CALL LINWID(1)
      CALL MESSAG("b) KHAD tree indices",grl+300,grt+30)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE yml_khadd
!-------------------------------------------------------------------
      SUBROUTINE yml_khad()   ! 2 RCS curves compared
      IMPLICIT NONE                 
      INTEGER,PARAMETER        :: st=12  ! number of sites
      INTEGER,DIMENSION(0:st)  :: sit    ! site tree address
      INTEGER                  :: i,j,m,n,p,q,r,u,v,w
      CALL read_yml(st,sit)
      CALL det_default()
      m=21 ; n=20+st ; CDsp=50            ! Chronology Smoothing
      src=2 ; srcno=2 ; sfo=2 ; idt=-2    ! RCS - Sig free ON
      wnam(40)="Simple RCS, 2 curve" 
      cf=1 ; CALL detrend() ; w=sly(mx)
      crn(1:w,m:n)=0.D0 ; num(1:w,m:n)=0  
      cfy(m:n)=w ; cly(m:n)=-w  
      DO i=1,st                           ! Each site
        DO j=sit(i-1)+1,sit(i)            ! Each tree at that site
          p=ad(j) ; r=yr(j) ; q=p+r-1     ! Ring address 
          u=fy(j)-pth(j)+1  ; v=u+r-1     ! RCS address
          cfy(i+20)=MIN(cfy(i+20),u)
          cly(i+20)=MAX(cly(i+20),v)
          WHERE (xok(p:q))
            crn(u:v,20+i)=crn(u:v,20+i)+fx(p:q) ! SF measures 2 RCS
            num(u:v,20+i)=num(u:v,20+i)+1       ! Counts
          END WHERE
        ENDDO
      ENDDO
      cyr(m:n)=cly(m:n)-cfy(m:n)+1 
      WHERE (num(1:w,m:n).GT.1)           ! Mean vaues
        crn(1:w,m:n)=crn(1:w,m:n)/DBLE(num(1:w,m:n))
      END WHERE
      DO i=m,n                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! Age-dep RCS smoothing
        CALL spline3(r,crn(p:q,i),num(p:q,i),10,crn(p:q,i),FA)  
      ENDDO 
      r=cyr(cf) ; crn(1:r,cf+1)=xcsm(1:r,mx)
      crn(1:r,cf+2)=xcsd(1:r,mx)
      crn(1:r,6:10)=0.D0 ; num(1:r,6:10)=0
      cfy(6)=r ; cly(6)=-r
      DO i=sit(11)+1,sit(12)      ! KHAD trees
        p=ad(i) ; r=yr(i) ; q=p+r-1
        u=fy(i)-cfy(1)+1 ; v=u+r-1
        cfy(6)=MIN(cfy(6),u)
        cly(6)=MAX(cly(6),v)
        WHERE (xok(p:q))
          crn(u:v,8)=crn(u:v,8)+dx(p:q)
          crn(u:v,9)=crn(u:v,9)+dx(p:q)**2
          num(u:v,6)=num(u:v,6)+1
        END WHERE
        CALL spline_miss(r,dx(p:q),30,tx(p:q),xok(p:q))
      ENDDO
      p=cfy(6) ; q=cly(6) ; r=q-p+1 ; cyr(6)=r
      WHERE (num(p:q,6).GT.1) &
        crn(p:q,6)=crn(p:q,8)/DBLE(num(p:q,6))  
      WHERE (num(p:q,6).GE.4) 
        crn(p:q,7)=SQRT(MAX(crn(p:q,9)-crn(p:q,8)* &  
          crn(p:q,6),0.001D0)/DBLE(num(p:q,6)-1))   ! SDev 
        crn(p:q,8)=crn(p:q,7)/crn(p:q,1)   ! Scaled by chronology
      ELSEWHERE
        crn(p:q,7)=0.D0 ; crn(p:q,7)=0.D0
      END WHERE
      num(1,50)=sit(11)+1 ; num(2,50)=sit(12)
      cfy(7)=cfy(1)+cfy(6)-1
      cly(7)=cfy(1)+cly(6)-1
      cyr(7)=cly(7)-cfy(7)+1
      RETURN 
      END SUBROUTINE yml_khad
!------------------------------------------------------------------------
      SUBROUTINE Fig5d()   ! PU_sep100d
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8)                :: r1,r2,r3,r4,r5
      INTEGER                :: i=1,p,q,r,u,v
      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2000 ; grt=120 ; grb=400
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(p,q,0.3D0,2.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(4) ; q=cly(4) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,4),num(p:q,4),3)
      CALL MESSAG(cnam(21)(5:20),grl+400,grt-45)
      CALL SETCLR(blue) ; p=cfy(5) ; q=cly(5) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,5),num(p:q,5),3)
      CALL MESSAG(cnam(22)(5:20),grl+800,grt-45)
      CALL SETCLR(red) ; p=cfy(6) ; q=cly(6) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,6),num(p:q,6),3)
      CALL MESSAG(cnam(23)(5:20),grl+1200,grt-45)
      CALL SETCLR(black)
      CALL MESSAG("a) TRW 100-year Spline",grl+650,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
 
      p=cfy(1) ; q=cly(1) ; r=cyr(1)
      grt=410 ; grb=690
      CALL tombox(p,q,0.2D0,2.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(4) ; q=cly(4) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,34),num(p:q,4),3)
      CALL SETCLR(blue) ; p=cfy(5) ; q=cly(5) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,35),num(p:q,5),3)
      CALL SETCLR(red) ; p=cfy(6) ; q=cly(6) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,36),num(p:q,6),3)
      CALL SETCLR(black)
      CALL MESSAG("b) TRW one-curve RCS",grl+650,grt+30)
      CALL ENDGRF() ; CALL LINWID(1) 

      p=cfy(80) ; q=cly(80) ; r=cyr(80)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grt=700 ; grb=980
      CALL tombox(cfy(1),cly(1),0.2D0,2.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(cyan) ; p=cfy(85) ; q=cly(85) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,88),num(p:q,85),3)
      CALL SETCLR(blue) ; p=cfy(83) ; q=cly(83) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,86),num(p:q,83),3)
      CALL SETCLR(red) ; p=cfy(84) ; q=cly(84) ; r=q-p+1
      CALL thickthin(r,wka(p:q),crn(p:q,87),num(p:q,84),3)
      CALL SETCLR(black)
      CALL MESSAG("c) One-curve RCS No Root",grl+650,grt+30)
      CALL ENDGRF() ; CALL LINWID(1) 

      r1=0.3D0 ; r2=2.3D0 ; r3=1.7D0 ; r4=0.0D0 ; r5=2.9D0
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grt=1050 ; grb=1330
      CALL NAME('','X')
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(p,q,r1,r2)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1
        u=fy(i)-cfy(1)+1 ; v=u+r-1
        CALL SETCLR(num(i,3))
        CALL line_miss(r,wka(u:v),ax(p:q),xok(p:q))
      ENDDO 
      CALL SETCLR(cyan) 
      CALL MESSAG("Polar Modern",grl+10,grt-40)
      CALL SETCLR(green)
      CALL MESSAG("Polar Sub-fossil",grl+370,grt-40)
      CALL SETCLR(blue)
      CALL MESSAG("Update Stem",grl+740,grt-40)
      CALL SETCLR(red)
      CALL MESSAG("Update Root",grl+1110,grt-40)
      CALL SETCLR(5)
      CALL MESSAG("Sub-fossil Root",grl+1470,grt-40)
      CALL SETCLR(black)
      CALL MESSAG("d) Mean Value",grl+1300,grt+30)
      CALL ENDGRF()

      grt=1340 ; grb=1620
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      CALL tombox(p,q,r4,r5)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,nc
        p=ad(i) ; r=yr(i) ; q=p+r-1
        u=fy(i)-cfy(1)+1 ; v=u+r-1
        CALL SETCLR(num(i,3))
        CALL line_miss(r,wka(u:v),dx(p:q),xok(p:q))
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("e) 100-year Smoothed",grl+1300,grt+30)
      CALL ENDGRF()

      grt=1630 ; grb=1910
      r=cyr(1) ; p=cfy(1) ; q=cly(1)
      CALL plot_trees(r,num(1:r,1))  
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      CALL tombox(p,q,0.0D0,r3)
      CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(red)
      CALL line_miss(r,wka(1:r),xcsd(1:r,mx),num(1:r,1).GE.4)
      CALL SETCLR(black)  
      CALL MESSAG("f) Standard Deviation",grl+1300,grt+30)
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE Fig5d
!-------------------------------------------------------------------
      SUBROUTINE Fig5()  ! PU_sep and PU_sep100
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,u,v,r
      cnam(1)="../../raw/polar/poula/pou_la_stem.raw" 
      cnam(2)="../../raw/polar/poula/polustem.raw" 
      cnam(3)="../../raw/polar/poula/pou_la_mod.raw"
      nc=0
      DO i=1,3
        CALL read_rft(cnam(i)) ; num(i,82)=nc
      ENDDO
      sfo=2 ; idt=-2 ; src=1
      cf=80 ; CALL detrend() ; r=cyr(cf) 
      crn(1:r,83:85)=0.D0 ; num(1:r,83:85)=0
      cfy(83:85)=3000 ; cly(83:85)=-1000
      DO i=1,nc
        p=ad(i) ; q=p+yr(i)-1
        u=fy(i)-cfy(cf)+1 ; v=u+yr(i)-1
        IF (i.LE.num(1,82)) THEN
          WHERE (xok(p:q))       ! Polar Modern
            crn(u:v,83)=crn(u:v,83)+dx(p:q)
            num(u:v,83)=num(u:v,83)+1
          END WHERE
          cfy(83)=MIN(cfy(83),u)
          cly(83)=MAX(cly(83),v)
        ELSEIF (i.LE.num(2,82)) THEN
          WHERE (xok(p:q))       ! Polar Sub-fos
            crn(u:v,84)=crn(u:v,84)+dx(p:q)
            num(u:v,84)=num(u:v,84)+1
          END WHERE
          cfy(84)=MIN(cfy(84),u)
          cly(84)=MAX(cly(84),v)
        ELSE
          WHERE (xok(p:q))       ! Polar update
            crn(u:v,85)=crn(u:v,85)+dx(p:q)
            num(u:v,85)=num(u:v,85)+1
          END WHERE
          cfy(85)=MIN(cfy(85),u)
          cly(85)=MAX(cly(85),v)
        ENDIF
      ENDDO
      cyr(83:85)=cly(83:85)-cfy(83:85)+1
      okc(1:r,83:85)=num(1:r,83:85).GE.1
      DO i=83,85
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        WHERE (okc(p:q,i)) &
          crn(p:q,i)=crn(p:q,i)/DBLE(num(p:q,i)) 
          CALL splinet(r,crn(p:q,i),50,crn(p:q,i+3))
      ENDDO

      CALL det_default()
      sfo=2 ; idt=-2  ! RCS - Sig free ON 
      CALL PU_sepx()
      DO i=3,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL splinet(r,crn(p:q,i),50,crn(p:q,i+30))
      ENDDO
      DO i=13,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL splinet(r,crn(p:q,i),50,crn(p:q,i+30))
      ENDDO
      cnam(30)="Separate RCS curves and CRNs" 
      CALL det_default()
      idt=-2 ; sfo=2 ; src=1   ! Simple RCS
      DO i=1,6
        nc=0 ; CALL read_rft(cnam(i))
        cf=i+20 ; CALL detrend() ; r=cyr(cf)                  
        CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf))
      ENDDO
      cnam(31)="100-year Spline, Sig free ON" 
      CALL det_default()
      sfo=2 ; idt=100    ! 100-yr spline, sig-free ON
      CALL PU_sepx()
      DO i=3,6
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL spline_miss(r,crn(p:q,i),10,crn(p:q,i),okc(p:q,i))
      ENDDO
      DO i=13,16
        p=cfy(i) ; q=cly(i) ; r=q-p+1
        CALL spline_miss(r,crn(p:q,i),10,crn(p:q,i),okc(p:q,i))
      ENDDO
      CALL PU_indiv(1)

      OPEN(74,FILE="yamal/Fig5.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig5.col")) STOP
      WRITE(74,'("With roots")')
      WRITE(74,'("Year")')
      WRITE(74,'("All Samples Count")')
      WRITE(74,'("Pou_la_stem Count")')
      WRITE(74,'("Polustem Count")')
      WRITE(74,'("Pou_la_mod Count")')
      WRITE(74,'("Pou_la_stem Spline")')
      WRITE(74,'("Polustem Spline")')
      WRITE(74,'("Pou_la_mod Spline")')
      WRITE(74,'("Pou_la_stem RCS")')
      WRITE(74,'("Polustem RCS")')
      WRITE(74,'("Pou_la_mod RCS")')
      WRITE(74,'("Standard Deviation")')
      DO i=1,cyr(1)
        WRITE(74,'(5I6,7F8.3)') i+cfy(1)-1,num(i,1),num(i,4:6), &
          crn(i,4:6),crn(i,34:36),xcsd(i,mx)
      ENDDO
      WRITE(74,'("Without roots")')
      WRITE(74,'("Year")')
      WRITE(74,'("Polustem Count")')
      WRITE(74,'("Pou_la_stem Count")')
      WRITE(74,'("Pou_la_mod Count")')
      WRITE(74,'("Polustem RCS")')
      WRITE(74,'("Pou_la_stem RCS")')
      WRITE(74,'("Pou_la_mod RCS")')
      DO i=1,cyr(80)
        WRITE(74,'(4I6,3F8.3)') i+cfy(80)-1,num(i,83:85),crn(i,86:88)
      ENDDO
      CLOSE(74) 
      CALL write_raw("yamal/Fig5_tree_ho.ind",ax) 
      CALL write_raw("yamal/Fig5_tree_sm.ind",dx) 
      RETURN 
      END SUBROUTINE Fig5
!------------------------------------------------------------------------
      SUBROUTINE FigYd(st)  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: st  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,u,v,r,w
      grl=200 ; grr=2400 ; grt=120 ; grb=470
      wka(1:2010-1600+1)=(/(DBLE(i),i=1600,2010)/) 
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME('Index Values','Y')    ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=5*st+1,6*st
        CALL SETCLR(i-5*st)
        p=MAX(cfy(i),1600)-cfy(i)+1 ; q=cyr(i) ; r=q-p+1
        u=MAX(cfy(i),1600)-1600+1 ; v=u+r-1 
        CALL thickthin(r,wka(u:v),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i-5*st+20)(1:3),grl+(i-5*st)*150+100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      w=cyr(cf)
      wka(1:w)=(/(DBLE(i),i=cfy(cf),cly(cf))/) 
      grt=480 ; grb=830
      CALL NAME('Index Value','Y')   ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=st+1,st+st
        CALL SETCLR(i-st)
        p=MAX(cfy(i),1600-cfy(cf)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(42),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      grt=840 ; grb=1190
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=st+1,st+st
        CALL SETCLR(i-st)
        p=MAX(cfy(i),1600-cfy(cf)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(43),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE FigYd 
!-------------------------------------------------------------------
      SUBROUTINE FigY(st)   ! Was yml_sep3r()
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)      :: st       ! number of sites
      INTEGER,DIMENSION(0:st) :: sit      ! site tree address
      REAL(8),DIMENSION(mxd)  :: qx       ! Raw data storage
      REAL(8),DIMENSION(mxd)  :: yx       ! Raw data storage
      INTEGER  :: i,j,k1,k2,k3,p,q,r,s,t,u,v,w
      CALL read_yml(st,sit)               ! Reads 12 Yamal sites
      CALL det_default()
      cf=80 ; sfo=2 ; idt=-2              ! RCS - Sig free ON
      src=1 ; srcno=1 ; CALL detrend()    ! 1 RCS curve detrend  
      j=ad(nc)+yr(nc)-1       
      yx(1:j)=dx(1:j)                     ! Store tree index values
      qx(1:j)=fx(1:j)                     ! Store signal-free measures 
      cf=81
      src=2 ; srcno=2 ; CALL detrend()    ! 2 RCS curve detrend   
      w=cyr(cf)
      crn(1:w,1:st*4)=0.D0 ; num(1:w,1:st*4)=0  
      cfy(1:st*2)=w ; cly(1:st*2)=-w  
      DO i=1,st                           ! Each site
        k1=i+st ; k2=k1+st ; k3=k2+st
        DO j=sit(i-1)+1,sit(i)            ! Each tree at that site
          p=ad(j) ; r=yr(j) ; q=p+r-1     ! Ring address 
          u=fy(j)-cfy(cf)+1 ; v=u+r-1     ! Chronology address
          s=fy(j)-pth(j)+1  ; t=s+r-1     ! RCS address
          cfy(i)=MIN(cfy(i),s)
          cly(i)=MAX(cly(i),t)
          cfy(k1)=MIN(cfy(k1),u)
          cly(k1)=MAX(cly(k1),v)
          WHERE (xok(p:q))
            crn(s:t,i)=crn(s:t,i)+qx(p:q)    ! SF measures 1 RCS
            crn(s:t,k2)=crn(s:t,k2)+fx(p:q)  ! SF measures 2 RCS
            num(s:t,i)=num(s:t,i)+1
            crn(u:v,k1)=crn(u:v,k1)+yx(p:q)  ! Tree indices 1 RCS
            crn(u:v,k3)=crn(u:v,k3)+dx(p:q)  ! Tree indices 2 RCS
            num(u:v,k1)=num(u:v,k1)+1
          END WHERE
        ENDDO
      ENDDO
      cyr(1:st*2)=cly(1:st*2)-cfy(1:st*2)+1 
      WHERE (num(1:w,1:st).GT.1)           ! Mean vaues
        crn(1:w,1:st)=crn(1:w,1:st)/DBLE(num(1:w,1:st))
        crn(1:w,1+st*2:st*3)=crn(1:w,1+st*2:st*3)/DBLE(num(1:w,1:st))
      END WHERE
      WHERE (num(1:w,st+1:2*st).GT.1)           ! Mean vaues
        crn(1:w,st+1:2*st)=crn(1:w,st+1:2*st)/DBLE(num(1:w,st+1:2*st))
        crn(1:w,1+st*3:4*st)=crn(1:w,1+st*3:4*st)/DBLE(num(1:w,st+1:2*st))
      END WHERE
      DO i=1,st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! Age-dep RCS smoothing
        CALL spline3(r,crn(p:q,i),num(p:q,i),10,crn(p:q,i),FA)  

        CALL spline3(r,crn(p:q,i+2*st),num(p:q,i),10,crn(p:q,i+2*st),FA)  
      ENDDO 
      DO i=st+1,2*st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! 20-year spline smoothing
        CALL splinet(r,crn(p:q,i),20,crn(p:q,i))
        CALL splinet(r,crn(p:q,i+2*st),20,crn(p:q,i+2*st))
      ENDDO 
      cnam(41)="a) Separate RCS Curves" 
      cnam(40)="a) Separate Chronologies" 
      cnam(42)="b) One-curve RCS"
      cnam(43)="c) Two-curve RCS"
      cnam(44)="d) Chronologies"
      CALL det_default()
      sfo=2 ; idt=-2 ; src=1       ! RCS 1 curve, SF ON
      crn(1:3000,82)=0.D0 ; num(1:3000,82)=0  
      DO i=4*st+1,5*st             ! Process each site separately
        nc=0 ; CALL read_rft(cnam(i-4*st))
        cf=i+st ; CALL detrend()  
        p=sfy(mx) ; q=sly(mx) ; r=q-p+1
        cfy(i)=p ; cly(i)=q ; cyr(i)=r
        crn(1:r,i)=msmo(1:r,mx)    ! Separate RCS
        num(1:r,i)=mcnt(1:r,mx)    ! Separate RCS count
        r=cyr(cf) ; p=cfy(cf)-cfy(80)+1 ; q=p+r-1
        crn(p:q,82)=crn(p:q,82)+crn(1:r,cf)*DBLE(num(1:r,cf)) 
        num(p:q,82)=num(p:q,82)+num(1:r,cf) 
        CALL splinet(r,crn(1:r,cf),20,crn(1:r,cf))
      ENDDO
      WHERE (num(1:w,82).GT.1) &          ! Mean vaues
        crn(1:w,82)=crn(1:w,82)/DBLE(num(1:w,82))
      DO i=80,82                  ! Smooth chronologies
        CALL splinet(w,crn(1:w,i),50,crn(1:w,i))
      ENDDO 
      cf=80
      RETURN 
      END SUBROUTINE FigY
!------------------------------------------------------------------------
      SUBROUTINE FigYad(st)  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: st  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,p,q,r,w
      w=MAXVAL(cly(1:st))
      wka(1:w)=(/(DBLE(i),i=1,w)/) 
      grl=200 ; grr=2400 ; grt=120 ; grb=470
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME('Ring Width','Y')    ! Axis name
      CALL tombox(1,w,0.D0,1.8D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1+4*st,st+4*st
        j=i-4*st ; CALL SETCLR(j)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(j+20)(1:3),grl+j*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(41),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      grt=480 ; grb=830
      CALL tombox(1,w,0.D0,1.8D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) One-curve RCS, Site curves",grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=840 ; grb=1190
      CALL LABELS('FLOAT','X')
      CALL NAME('Ring Age','X')
      CALL tombox(1,w,0.D0,1.8D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("c) Two-curve RCS, Site curves",grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE FigYad 
!-------------------------------------------------------------------
      SUBROUTINE Fig10()   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      REAL(8)  :: mn,sd
      INTEGER  :: i,j,p,q,r,w
      cnam(1)="../../raw/yam/yamalad.raw"
      cnam(2)="../../raw/yam/yamal_all.raw"
      cnam(3)="../../raw/yam/yml-all.raw"
      cnam(21)="a) Yamal QSR (2000) and Phil Trans (2008)"
      cnam(22)="b) Yamal (2009)"
      cnam(23)="c) Yamal (2012)"
      cnam(24)="d) Yamal QSR (2000) and Phil Trans (2008)"
      cnam(25)="e) Yamal (2009)"
      cnam(26)="f) Yamal (2012)"
      CALL det_default()     ! Chronology Smoothing
      sfo=2 ; idt=-2         ! RCS - Sig free ON
      DO j=1,3
        nc=0 ; CALL read_rft(cnam(j))
        idb=1 ; src=1 ; srcno=1
        cnam(40)="One-curve RCS" 
        cf=j ; CALL detrend() ; r=cyr(cf)
        p=1-cfy(cf)+1 ; q=1600-cfy(cf)+1 ; w=q-p+1
        mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
        sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
        crn(1:r,cf)=(crn(1:r,cf)-mn)/sd  ! Normal 1-1600
        CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+3))
        src=2 ; srcno=2
        cnam(41)="Two-curve RCS" 
        cf=cf+6 ; CALL detrend() 
        mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
        sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
        crn(1:r,cf)=(crn(1:r,cf)-mn)/sd  ! Normal 1-1600
        CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+3))
        idb=2
        cnam(42)="Two-curve RCS, Normal" 
        cf=cf+6 ; CALL detrend() 
        mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
        sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
        crn(1:r,cf)=(crn(1:r,cf)-mn)/sd  ! Normal 1-1600
        CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+3))
        num(r+1:r+50,j)=0
      ENDDO
      idb=1

      OPEN(74,FILE="yamal/Fig10.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig10.col")) STOP
      DO j=1,3
        WRITE(74,'(A60)') cnam(20+j)
        WRITE(74,'("Year")') 
        WRITE(74,'("Tree Count")') 
        WRITE(74,'("One-curve RCS")') 
        WRITE(74,'("Two-curve RCS")') 
        WRITE(74,'("Two-curve RCS, Normal")') 
        WRITE(74,'("One-curve RCS Smoothed")') 
        WRITE(74,'("Two-curve RCS Smoothed")') 
        WRITE(74,'("Two-curve RCS, Normal Smoothed")') 
        DO i=1,cyr(j)
          WRITE(74,'(2I6,6F8.3)') i-1+cfy(j),num(i,j), &
            crn(i,j),crn(i,j+6),crn(i,j+12),crn(i,j+3),crn(i,j+9),crn(i,j+15)
        ENDDO
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Fig10
!------------------------------------------------------------------------
      SUBROUTINE Fig10d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,p,q,r
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      p=1-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 ; j=2007-cly(1)
      grl=200 ; grr=2000 ; grt=140 ; grb=400
      CALL LABELS('NONE','X')
      CALL NAME('','X')           ! Axis name
      CALL NAME('z scores','Y')   ! Axis name
      CALL plot_treesq(r+j,num(p:q+j,1),159)  
      CALL tombox(1,2007,-2.0D0,5.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; CALL CURVE(wka(p:q),crn(p:q,4),r)
      CALL MESSAG(cnam(40),grl+50,grt-45)
      CALL SETCLR(blue)  ; CALL CURVE(wka(p:q),crn(p:q,10),r)
      CALL MESSAG(cnam(41),grl+600,grt-45)
      CALL SETCLR(red)   ; CALL CURVE(wka(p:q),crn(p:q,16),r)
      CALL MESSAG(cnam(42),grl+1150,grt-45)
      CALL SETCLR(black) ; CALL MESSAG(cnam(21),grl+100,grt+30)
      CALL ENDGRF() 

      r=cyr(2) ; wka(1:r)=(/(DBLE(i),i=cfy(2),cly(2))/) 
      p=1-cfy(2)+1 ; q=cyr(2) ; r=q-p+1 ; j=2007-cly(2)
      grt=410 ; grb=670
      CALL plot_treesq(r+j,num(p:q+j,2),159)  
      CALL tombox(1,2007,-2.0D0,5.50D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; CALL CURVE(wka(p:q),crn(p:q,5),r)
      CALL SETCLR(blue)  ; CALL CURVE(wka(p:q),crn(p:q,11),r)
      CALL SETCLR(red)   ; CALL CURVE(wka(p:q),crn(p:q,17),r)
      CALL SETCLR(black) ; CALL MESSAG(cnam(22),grl+100,grt+30)
      CALL ENDGRF() 

      r=cyr(3) ; wka(1:r)=(/(DBLE(i),i=cfy(3),cly(3))/) 
      p=1-cfy(3)+1 ; q=cyr(3) ; r=q-p+1 ; j=2007-cly(3)
      grt=680 ; grb=940
      CALL LABELS('FLOAT','X')
      CALL plot_treesq(r+j,num(p:q+j,3),159)  
      CALL tombox(1,2007,-2.0D0,5.50D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; CALL CURVE(wka(p:q),crn(p:q,6),r)
      CALL SETCLR(blue)  ; CALL CURVE(wka(p:q),crn(p:q,12),r)
      CALL SETCLR(red)   ; CALL CURVE(wka(p:q),crn(p:q,18),r)
      CALL SETCLR(black) ; CALL MESSAG(cnam(23),grl+100,grt+30)
      CALL ENDGRF() 

      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      p=1800-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 ; j=2007-cly(1)
      grt=1010 ; grb=1270
      CALL LABELS('NONE','X')
      CALL plot_treesq(r+j,num(p:q+j,1),159)  
      CALL tombox(1800,2007,-3.0D0,5.99D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; CALL CURVE(wka(p:q),crn(p:q,1),r)
      CALL SETCLR(blue)  ; CALL CURVE(wka(p:q),crn(p:q,7),r)
      CALL SETCLR(red)   ; CALL CURVE(wka(p:q),crn(p:q,13),r)
      CALL SETCLR(black) ; CALL MESSAG(cnam(24),grl+100,grt+30)
      CALL ENDGRF() 

      r=cyr(2) ; wka(1:r)=(/(DBLE(i),i=cfy(2),cly(2))/) 
      p=1800-cfy(2)+1 ; q=cyr(1) ; r=q-p+1 ; j=2007-cly(2)
      grt=1280 ; grb=1540
      CALL plot_treesq(r+j,num(p:q+j,2),159)  
      CALL tombox(1800,2007,-3.0D0,5.99D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; CALL CURVE(wka(p:q),crn(p:q,2),r)
      CALL SETCLR(blue)  ; CALL CURVE(wka(p:q),crn(p:q,8),r)
      CALL SETCLR(red)   ; CALL CURVE(wka(p:q),crn(p:q,14),r)
      CALL SETCLR(black) ; CALL MESSAG(cnam(25),grl+100,grt+30)
      CALL ENDGRF() 

      r=cyr(3) ; wka(1:r)=(/(DBLE(i),i=cfy(3),cly(3))/) 
      p=1800-cfy(3)+1 ; q=cyr(3) ; r=q-p+1 ; j=2007-cly(3)
      grt=1550 ; grb=1810
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')               ! Axis name
      CALL plot_treesq(r+j,num(p:q+j,3),159)  
      CALL tombox(1800,2007,-3.0D0,5.99D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black) ; CALL CURVE(wka(p:q),crn(p:q,3),r)
      CALL SETCLR(blue)  ; CALL CURVE(wka(p:q),crn(p:q,9),r)
      CALL SETCLR(red)   ; CALL CURVE(wka(p:q),crn(p:q,15),r)
      CALL SETCLR(black) ; CALL MESSAG(cnam(26),grl+100,grt+30)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE Fig10d
!-------------------------------------------------------------------
      SUBROUTINE plot_treesnl(cnt,trees)
      IMPLICIT NONE   ! Shaded tree count area
      INTEGER,INTENT(IN)                :: cnt    ! Data count
      INTEGER,DIMENSION(cnt),INTENT(IN) :: trees  ! Tree counts
      CHARACTER(5),DIMENSION(4)         :: labs
      REAL(8)                           :: yscal  ! Y scale
      REAL(8)                           :: xscal  ! X scale
      INTEGER,DIMENSION(0:cnt+1)        :: zz4,zz5
      INTEGER                           :: i,p,lab
      p=MAXVAL(trees(1:cnt))
      SELECT CASE (p)  ! Select suitable yscale
        CASE (   : 50)  ; lab=50
        CASE (51 :100)  ; lab=100
        CASE (101:160)  ; lab=160
        CASE (161:300)  ; lab=300
        CASE (301:500)  ; lab=500
        CASE (501:900)  ; lab=900
        CASE (901:1200) ; lab=1200
        CASE (1201:)    ; lab=(p/500+1)*500
      END SELECT
      CALL SETCLR(silver) ; CALL HEIGHT(18) ; CALL LINWID(1)
      yscal=DBLE(grb-grt)/DBLE(lab)
      xscal=DBLE(grr-grl)/DBLE(cnt)
      DO i=1,4 ; WRITE(labs(i),'(I5)') (lab*i)/4 ; ENDDO
      zz4(1:cnt)=grb-NINT(DBLE(trees)*yscal)
      zz4(0)=grb ; zz4(cnt+1)=grb
      zz5(1:cnt)=grl+NINT(xscal*(/(DBLE(i),i=1,cnt)/))
      zz5(0)=zz5(1) ; zz5(cnt+1)=zz5(cnt)
      CALL AREAF(zz5,zz4,cnt+2)
      CALL SETCLR(black)
      RETURN
      END SUBROUTINE plot_treesnl
!--------------------------------------------------------------------
      SUBROUTINE Fig4d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,p,q,r
      r=cyr(3) ; wka(1:r)=(/(DBLE(i),i=cfy(3),cly(3))/) 
      j=2007-cly(3) ; num(r+1:j,3)=0
      p=-500-cfy(3)+1 ; q=r ; r=q-p+1 
      grl=200 ; grr=1890 ; grt=200 ; grb=700
      CALL NAME('','X')               ! Axis name
      CALL plot_treesnl(r+1,num(p:q+1,3))  
      CALL NAME('z score','Y')            ! Axis name
      CALL tombox(-500,2006,-2.0D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl+200,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,6),r)
      CALL SETCLR(blue)
      CALL MESSAG(cnam(41),grl+800,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,12),r)
      CALL SETCLR(red)
      CALL MESSAG(cnam(42),grl+1400,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,18),r)
      CALL SETCLR(black)
      CALL MESSAG("a) Yamal All Smoothed",grl+200,grt+35)
      CALL ENDGRF() 

      p=1901-cfy(3)+1 ; r=q-p+1
      grl=1900 ; grr=2400 ; grt=200 ; grb=700
      CALL TICKS(2,'X')        ! No Y ticks
      CALL LABELS('FLOAT','X')
      CALL LABELS('NONE','Y')
      CALL NAME('','Y')               ! Axis name
      CALL NAME('','X')               ! Axis name
      CALL plot_trees(r+j,num(p:q+j,3))  
      CALL tombox(1901,2006,-2.0D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL CURVE(wka(p:q),crn(p:q,6),r)
      CALL SETCLR(blue)
      CALL CURVE(wka(p:q),crn(p:q,12),r)
      CALL SETCLR(red)
      CALL CURVE(wka(p:q),crn(p:q,18),r)
      CALL SETCLR(black)
      CALL MESSAG("b)",grl+50,grt+35)
      CALL ENDGRF() 
      CALL TICKS(10,'X')        ! No Y ticks

      p=1801-cfy(3)+1 ; r=q-p+1
      grl=200 ; grr=2400 ; grt=780 ; grb=1280
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')      ! Axis name
      CALL LABELS('FLOAT','Y')
      CALL NAME('z score','Y')            ! Axis name
      CALL plot_trees(r+j,num(p:q+j,3))  
      CALL tombox(1801,2006,-3.5D0,4.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL CURVE(wka(p:q),crn(p:q,3),r)
      CALL SETCLR(blue)
      CALL CURVE(wka(p:q),crn(p:q,9),r)
      CALL SETCLR(red)
      CALL CURVE(wka(p:q),crn(p:q,15),r)
      CALL SETCLR(black)
      CALL MESSAG("c) Yamal All",grl+200,grt+45)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE Fig4d
!-------------------------------------------------------------------
      SUBROUTINE fig4()   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      REAL(8)  :: mn,sd
      INTEGER  :: i,p,q,r,w
      cnam(3)="../../raw/yam/yml-all.raw"
      CALL det_default()     ! Chronology Smoothing
      sfo=2 ; idt=-2         ! RCS - Sig free ON
      nc=0 ; CALL read_rft(cnam(3))
      idb=1 ; src=1 ; srcno=1
      cnam(40)="One-curve RCS" 
      cf=3 ; CALL detrend() ; r=cyr(cf)
      p=1-cfy(cf)+1 ; q=1600-cfy(cf)+1 ; w=q-p+1
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd  ! Normal 1-1600
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+3))
      src=2 ; srcno=2
      cnam(41)="Two-curve RCS" 
      cf=cf+6 ; CALL detrend() 
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd  ! Normal 1-1600
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+3))
      cnam(42)="Two-curve RCS, Normal" 
      idb=2 ; cf=cf+6 ; CALL detrend() 
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd  ! Normal 1-1600
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+3))
      num(r+1:r+50,3)=0 ; idb=1

      OPEN(74,FILE="yamal/Fig4.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig4.col")) STOP
      WRITE(74,'("Yamal TRW")') 
      WRITE(74,'("Year")') 
      WRITE(74,'("Tree Count")') 
      WRITE(74,'("One-curve RCS")') 
      WRITE(74,'("Two-curve RCS")') 
      WRITE(74,'("Two-curve RCS, Normal")') 
      WRITE(74,'("One-curve RCS Smoothed")') 
      WRITE(74,'("Two-curve RCS Smoothed")') 
      WRITE(74,'("Two-curve RCS, Normal Smoothed")') 
      DO i=1,cyr(3)
        WRITE(74,'(2I6,6F8.3)') i-1+cfy(3),num(i,3), &
          crn(i,3),crn(i,9),crn(i,15),crn(i,6),crn(i,12),crn(i,18)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE fig4
!------------------------------------------------------------------------
      SUBROUTINE compnormd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER                :: j=1,m,r
      CALL TICKS(0,'Y')        ! No Y ticks
      grl=200 ; grr=2400 ; grt=150 ; grb=500
      r=cyr(1) ; wka(1:r)=(/(DBLE(j),j=cfy(1),cly(1))/) 
      CALL NAME('z score','Y')            ! Axis name
      DO j=1,4  
        CALL NAME(wnam(25+j),'Y')           ! Axis name
        IF (j.EQ.1) THEN ; m=1
          CALL LABELS('NONE','X')
          CALL NAME('','X')               ! Axis name
        ELSEIF (j.EQ.2) THEN ; m=3
        ELSEIF (j.EQ.3) THEN ; m=7
        ELSEIF (j.EQ.4) THEN ; m=9
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')  ! Axis name
        ENDIF 
        CALL tombox(cfy(1),cly(1)+3,-2.9D0,+2.9D0) 
        CALL SETCLR(grey) ; CALL GRID(1,1)    
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(blue) ; CALL CURVE(wka(1:r),crn(1:r,m),r)
        CALL SETCLR(red)  ; CALL CURVE(wka(1:r),crn(1:r,m+1),r)
        IF (j.EQ.1) THEN
          CALL SETCLR(blue) ; CALL MESSAG(cnam(42),grl+700,grt-45)
          CALL SETCLR(red)  ; CALL MESSAG(cnam(41),grl+1400,grt-45)
          CALL SETCLR(black) ; CALL MESSAG(wnam(25),grl+100,grt-45)
        ENDIF 
        CALL SETCLR(black) ; CALL ENDGRF()
        grt=grt+360 ; grb=grb+360
      ENDDO
      CALL TICKS(5,'Y')        ! Y ticks
      RETURN 
      END SUBROUTINE compnormd
!-------------------------------------------------------------------
      SUBROUTINE compnorm(ref1)  ! Frequency split 
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ref1
      INTEGER :: r
      REAL(8) :: nr,mn,sd
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="Yamal TRW"
      wnam(22)="Polar TRW"
      wnam(23)="Polar MXD"
      wnam(25)=wnam(20+ref1)
      cnam(41)="Two RCS, Normal Distribution CRNs" 
      cnam(42)="Two RCS Curve Ratios" 
      wnam(26)="a) All Frequencies"
      wnam(27)="b) 100yr Low Pass"
      wnam(28)="c) 100-15 Band Pass"
      wnam(29)="d) 15yr High Pass"
      CALL det_default() ; idt=-2
      src=2 ; srcno=2                                ! 2 curve RCS detrend
      nc=0 ; CALL read_rft(cnam(ref1))
      cf=1 ; CALL detrend() ; r=cyr(1)               ! Standard is ratios
      nr=DBLE(COUNT(okc(1:r,cf)))
      CALL splinet(r,crn(1:r,cf),100,crn(1:r,cf+2))  ! 100yr Low Pass +2 
      crn(1:r,cf+4)=crn(1:r,cf)/crn(1:r,cf+2)        ! Ratio 100yr High Pass +4
      CALL splinet(r,crn(1:r,cf+4),15,crn(1:r,cf+6)) ! 100-15yr Band Pass +6   
      crn(1:r,cf+8)=crn(1:r,cf+4)/crn(1:r,cf+6)     ! Ratio 15yr HP +8
      mn=SUM(crn(1:r,cf),MASK=okc(1:r,cf))/nr                 
      sd=SQRT(SUM((crn(1:r,cf)-mn)**2,MASK=okc(1:r,cf))/(nr-1.D0))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd                ! Full chronology
      mn=SUM(crn(1:r,cf+2),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+2)=(crn(1:r,cf+2)-mn)/sd            
      mn=SUM(crn(1:r,cf+4),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+4)=(crn(1:r,cf+4)-mn)/sd            
      mn=SUM(crn(1:r,cf+6),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+6)=(crn(1:r,cf+6)-mn)/sd            
      mn=SUM(crn(1:r,cf+8),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+8)=(crn(1:r,cf+8)-mn)/sd          

      cf=2 ; idb=2 ; CALL detrend() ; idb=1          ! Normal is differences
      CALL splinet(r,crn(1:r,cf),100,crn(1:r,cf+2))  ! 100yr Low Pass   
      crn(1:r,cf+4)=crn(1:r,cf)-crn(1:r,cf+2)        ! 100yr High Pass
      CALL splinet(r,crn(1:r,cf+4),15,crn(1:r,cf+6)) ! 100-15yr Band Pass   
      crn(1:r,cf+8)=crn(1:r,cf+4)-crn(1:r,cf+6)      ! 15yr HP
      mn=SUM(crn(1:r,cf),MASK=okc(1:r,cf))/nr                 
      sd=SQRT(SUM((crn(1:r,cf)-mn)**2,MASK=okc(1:r,cf))/(nr-1.D0))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd                ! Full chronology
      mn=SUM(crn(1:r,cf+2),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+2)=(crn(1:r,cf+2)-mn)/sd            
      mn=SUM(crn(1:r,cf+4),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+4)=(crn(1:r,cf+4)-mn)/sd            
      mn=SUM(crn(1:r,cf+6),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+6)=(crn(1:r,cf+6)-mn)/sd            
      mn=SUM(crn(1:r,cf+8),MASK=okc(1:r,cf))/nr                 
      crn(1:r,cf+8)=(crn(1:r,cf+8)-mn)/sd          
      RETURN
      END SUBROUTINE compnorm
!--------------------------------------------------------------
      SUBROUTINE PY_corrd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r
      grl=200 ; grr=2400 ; grt=150 ; grb=500
      r=cyr(6) ; wka(1:r)=(/(DBLE(i),i=cfy(6),cly(6))/) 
      p=cfy(6)-24 ; q=cly(6)+25 
      CALL NAME('Correlation','Y')   ! Axis name
      DO j=1,3
        IF (j.EQ.1) THEN
          CALL LABELS('NONE','X')
          CALL NAME('','X')                  ! Axis name
        ELSEIF (j.EQ.2) THEN
        ELSEIF (j.EQ.3) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('End Align Year','X')               ! Axis name
        ENDIF
        CALL tombox(p,q,0.D0,1.0D0)
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! GRIDLINES
        CALL LINWID(1) ; CALL HEIGHT(22) ; CALL SETCLR(blue) 
        CALL RLINE(DBLE(p),crn(j,5),DBLE(q),crn(j,5))
        CALL SETCLR(red) ; CALL CURVE(wka(1:r),crn(1:r,j+5),r)
        CALL SETCLR(black) ; CALL MESSAG(cnam(j+20),grl+100,grt+30)
        IF (j.EQ.1) THEN 
          CALL SETCLR(red) 
          CALL MESSAG("50-year Running Correlation",grl+1600,grt-45)
          CALL SETCLR(blue) 
          CALL MESSAG("1100-year Correlation",grl+900,grt-45)
          CALL SETCLR(black) 
          CALL MESSAG(cnam(40),grl+50,grt-45)
        ENDIF
        CALL SETCLR(black) ; CALL ENDGRF()
        grt=grt+360 ; grb=grb+360
      ENDDO  
      RETURN 
      END SUBROUTINE PY_corrd
!-------------------------------------------------------------------
      SUBROUTINE PY_corr(ref1)  ! Inter typre correlations 
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ref1
      INTEGER :: i,p,q,r,s,t,u,v
      OPEN(79,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      cnam(21)="a) Yamal TRW v Polar TRW"
      cnam(22)="b) Yamal TRW v Polar MXD"
      cnam(23)="c) Polar TRW v Polar MXD"
      CALL det_default() ; idt=-2
      src=2 ; srcno=2        ! 2 curve RCS detrend
      IF (ref1.EQ.2) THEN
        idb=2 ; cnam(40)="Two RCS, Normal Distribution CRNs" 
      ELSE
        idb=1 ; cnam(40)="Two RCS Curve Ratios" 
      ENDIF
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend() ; r=cyr(i)
      ENDDO
      r=1100 ; q=MINVAL(cly(1:3)) ; p=q-r+1
      u=p-cfy(1)+1 ; v=u+r-1
      s=p-cfy(2)+1 ; t=u+r-1   ! 1100 year correlation
      CALL cov(crn(u:v,1),crn(s:t,2),r,crn(1,5)) 
      s=p-cfy(3)+1 ; t=u+r-1
      CALL cov(crn(u:v,1),crn(s:t,3),r,crn(2,5)) 
      u=p-cfy(2)+1 ; v=u+r-1
      CALL cov(crn(u:v,2),crn(s:t,3),r,crn(3,5)) 
      cfy(6:8)=p+24 ; cly(6:8)=q-25
      cyr(6:8)=cly(6)-cfy(6)+1 ; r=50
      DO i=p,q-50+1    ! For each other 50-year period 
        u=i-cfy(1)+1 ; v=u+r-1
        s=i-cfy(2)+1 ; t=s+r-1   ! 1200 year correlation
        CALL cov(crn(u:v,1),crn(s:t,2),r,crn(i-p+1,6)) 
        s=i-cfy(3)+1 ; t=s+r-1
        CALL cov(crn(u:v,1),crn(s:t,3),r,crn(i-p+1,7)) 
        u=i-cfy(2)+1 ; v=u+r-1
        CALL cov(crn(u:v,2),crn(s:t,3),r,crn(i-p+1,8)) 
      ENDDO
       idb=1
      WRITE(79,'("Correlation YTRW - PTRW ",F8.3)') crn(1,5) 
      WRITE(79,'("Correlation YTRW - PMXD ",F8.3)') crn(2,5) 
      WRITE(79,'("Correlation PTRW - PMXD ",F8.3)') crn(3,5) 
      CLOSE(79)
      RETURN
      END SUBROUTINE PY_corr
!--------------------------------------------------------------
      SUBROUTINE Fig3d()   ! 2-RCS yml_growthd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      INTEGER,DIMENSION(3) :: col
      col=(/blue,red,black/)
      w=cly(4) ; wka(1:w)=(/(DBLE(i),i=1,w)/) 
      grl=200 ; grr=2400 ; grt=150 ; grb=550
      CALL NAME('Ring Age','X')
      CALL NAME('Ring Width','Y')    ! Axis name
      CALL plot_trees(w,mcnt(1:w,mx))  
      CALL tombox(1,w,0.D0,1.5D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=2,4
        CALL SETCLR(col(i-1))
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),7)
        CALL MESSAG(wnam(i),grl+i*550-1000,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("a) Two-curve RCS, Sig-free",grl+1000,grt+30)
      CALL ENDGRF() 

      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grt=700 ; grb=1050
      p=1-cfy(1)+1 ; q=cyr(1) ; r=q-p+1 
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')    ! Axis name
      CALL plot_trees(r,num(p:q,1))  
      CALL tombox(1,cly(1),0.3D0,2.2D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=6,7
        CALL SETCLR(col(i-5))
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),7)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) Chronology means 1.0",grl+1000,grt+44)
      CALL ENDGRF() 

      grt=1060 ; grb=1410
      CALL NAME('Index Value','Y')    ! Axis name
      CALL plot_trees(r,num(p:q,1))  
      CALL tombox(1,cly(1),0.3D0,2.2D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=16,17
        CALL SETCLR(col(i-15))
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),7)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("c) One-curve Means",grl+1000,grt+44)
      CALL ENDGRF()

      grt=1420 ; grb=1770
      CALL LABELS('FLOAT','X')
      CALL LABDIG(-1,'Y')
      CALL NAME('Calendar Year','X')
      CALL NAME('Sample Count','Y')    ! Axis name
      CALL tombox(1,cly(1),0.D0,98.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=6,7
        CALL SETCLR(col(i-5))
        CALL thickthin(r,wka(p:q),DBLE(num(p:q,i+10)),num(p:q,i),7)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("d) Sample Counts Each RCS Chronology",grl+1000,grt+37)
      CALL LABDIG(-1,'Y')
      CALL ENDGRF()
      RETURN 
      END SUBROUTINE Fig3d
!-------------------------------------------------------------------
      SUBROUTINE Fig3()  ! 2 RCS yml_growth() 
      IMPLICIT NONE                 
      INTEGER  :: i,j,k,p,q,r,w
      cnam(1)="../../raw/yam/yml-all.raw"
      wnam(2)="Slowest Growth"
      wnam(3)="Fastest Growth"
      wnam(4)="All trees"
      CALL det_default() ; CDsp=50   ! Chronology Smoothing
      tst=4 ; sfo=2                  ! Sort on growth rate 
      idt=-2 ; src=2 ; srcno=2       ! 2 curve RCS, SF=on  
      nc=0 ; CALL read_rft(cnam(1)) 
      DO k=1,11,10
        IF (k.NE.1) gtr=2        ! Reset means
        cf=k ; CALL detrend()  
        w=cyr(k) ; crn(1:w,k+1:k+7)=0.D0 ; num(1:w,k+1:k+7)=0
        DO j=2,4
          IF (j.EQ.4) THEN ; i=mx ; ELSE ; i=j-1 ; ENDIF
          p=sfy(i) ; q=sly(i) ; r=q-p+1
          cfy(j+k-1)=p ; cly(j+k-1)=q ; cyr(j+k-1)=r 
          crn(1:q,j+k-1)=mval(1:q,i)  ! Store RCS curves and counts
          num(1:q,j+k-1)=mcnt(1:q,i)
          IF (j.LT.4) THEN
            p=xfa(j-1) ; q=xla(j-1) 
            crn(p:q,j+3+k)=xcsm(p:q,i) ! Store Smoothed CRN and counts
            num(p:q,j+3+k)=xnum(p:q,i)
          ENDIF
        ENDDO
      ENDDO 
      OPEN(74,FILE="yamal/Fig3.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig3.col")) STOP
      WRITE(74,'("Ring Age")') 
      WRITE(74,'("Slow Count")') 
      WRITE(74,'("Fast Count")') 
      WRITE(74,'("All Count")') 
      WRITE(74,'("Slow Mean")') 
      WRITE(74,'("Fast Mean")') 
      WRITE(74,'("All Mean")') 
      DO i=1,cly(4)
        WRITE(74,'(4I6,3F8.3)') i,num(i,2:4),crn(i,2:4)
      ENDDO
      WRITE(74,*) 
      WRITE(74,'("Year")') 
      WRITE(74,'("Slow Count")') 
      WRITE(74,'("Fast Count")') 
      WRITE(74,'("Two-curve Slow Chronology")') 
      WRITE(74,'("Two-curve Fast Chronology")') 
      WRITE(74,'("Mean-single Slow Chronology")') 
      WRITE(74,'("Mean-single Fast Chronology")') 
      DO i=1,cyr(1)
        WRITE(74,'(3I6,7F8.3)') i-1+cfy(1),num(i,6:7), &
          crn(i,6:7),crn(i,16:17)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Fig3
!------------------------------------------------------------------------
      SUBROUTINE Fig2d()  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: st=11  ! number of sites
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      INTEGER,PARAMETER      :: fr=1600, to=2006
      w=40 ; p=cfy(w) ; q=cly(w) ; r=cyr(w)
      wka(1:r)=(/(DBLE(i),i=p,q)/) 
      grl=200 ; grr=2200 ; grt=150 ; grb=450
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')        ! Axis name
      CALL tombox(fr,to,0.D0,3.D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=w+1,w+12
        CALL SETCLR(i-w)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i-20)(1:3),grl+(i-40)*150-100,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=460 ; grb=760
      CALL tombox(fr,to,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=w+1,w+12
        CALL SETCLR(i-w)
        p=cfy(i) ; q=cly(i) ; r=cyr(i)
        CALL thickthin(r,wka(p:q),crn(p:q,i+12),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(41),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      w=cyr(80) ; wka(1:w)=(/(DBLE(i),i=cfy(80),cly(80))/) 
      grt=770 ; grb=1070
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL NAME('Index Values','Y')    ! Axis name
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=MAX(cfy(i),1600-cfy(cf)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(42),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=1080 ; grb=1380
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(i)
        p=MAX(cfy(i),1600-cfy(cf)+1)
        r=cyr(i) ; q=p+r-1
        CALL thickthin(r,wka(p:q),crn(p:q,i+st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG(cnam(43),grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=1390 ; grb=1690
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      CALL tombox(1600,2006,0.D0,2.7D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      p=1600-cfy(80)+1 ; q=cyr(80) ; r=q-p+1
      CALL SETCLR(blue)
      CALL thickthin(r,wka(p:q),crn(p:q,80),num(p:q,80),3)
      CALL MESSAG(cnam(44),grl+500,grt+30)
      CALL SETCLR(red)
      CALL thickthin(r,wka(p:q),crn(p:q,81),num(p:q,81),3)
      CALL MESSAG(cnam(45),grl+1100,grt+30)
      CALL SETCLR(black) ; CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE Fig2d 
!-------------------------------------------------------------------
      SUBROUTINE Fig2()   ! Was yml_sep3r()
      IMPLICIT NONE                 
      INTEGER,PARAMETER       :: st=11  ! number of sites
      INTEGER,DIMENSION(0:st) :: sit      ! site tree address
      REAL(8),DIMENSION(mxd)  :: yx       ! Raw data storage
      INTEGER  :: i,j,k1,p,q,r,u,v,w
      cnam(40)="a) 100-year Spline, Sig free ON" 
      cnam(41)="b) As above but 10-year Smoothed" 
      CALL det_default()
      sfo=2 ; idt=100    ! 100-yr spline, sig-free OFF
      CALL yml_sepx(12) ; w=cyr(13)
      cfy(40)=cfy(13) ; cly(40)=cly(13) ; cyr(40)=w
      DO i=1,12
        j=40+i ; p=cfy(i) ; q=cly(i) ; r=q-p+1
        cfy(j)=p ; cly(j)=q ; cyr(j)=r 
        crn(1:w,j)=crn(1:w,i)
        num(1:w,j)=num(1:w,i)
        okc(1:w,j)=okc(1:w,i)
        CALL spline_miss(r,crn(p:q,j),10,crn(p:q,j+12),okc(p:q,i))
      ENDDO

      CALL read_yml(st,sit)               ! Reads 12 Yamal sites
      CALL det_default()
      cf=80 ; sfo=2 ; idt=-2              ! RCS - Sig free ON
      src=1 ; srcno=1 ; CALL detrend()    ! 1 RCS curve detrend  
      j=ad(nc)+yr(nc)-1       
      yx(1:j)=dx(1:j)                     ! Store tree index values
      cf=81 ; src=2 ; srcno=2 ; CALL detrend() ! 2 RCS curve detrend   
      w=cyr(cf)
      crn(1:w,1:st*2)=0.D0 ; num(1:w,1:st*2)=0  
      cfy(1:st)=w ; cly(1:st)=-w  
      DO i=1,st                           ! Each site
        k1=i+st 
        DO j=sit(i-1)+1,sit(i)            ! Each tree at that site
          p=ad(j) ; r=yr(j) ; q=p+r-1     ! Ring address 
          u=fy(j)-cfy(80)+1 ; v=u+r-1     ! Chronology address
          cfy(i)=MIN(cfy(i),u)
          cly(i)=MAX(cly(i),v)
          WHERE (xok(p:q))
            crn(u:v,i)=crn(u:v,i)+yx(p:q)   ! Tree indices 1 RCS
            crn(u:v,k1)=crn(u:v,k1)+dx(p:q) ! Tree indices 2 RCS
            num(u:v,i)=num(u:v,i)+1
          END WHERE
        ENDDO
      ENDDO
      cyr(1:st)=cly(1:st)-cfy(1:st)+1 
      WHERE (num(1:w,1:st).GT.1)           ! Mean vaues
        crn(1:w,1:st)=crn(1:w,1:st)/DBLE(num(1:w,1:st))
        crn(1:w,1+st:st+st)=crn(1:w,1+st:st+st)/DBLE(num(1:w,1:st))
      END WHERE
      DO i=1,st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! 20-year spline smoothing
        CALL splinet(r,crn(p:q,i),20,crn(p:q,i))
        CALL splinet(r,crn(p:q,i+st),20,crn(p:q,i+st))
      ENDDO 
      cnam(42)="c) One-curve RCS"
      cnam(43)="d) Two-curve RCS"
      cnam(44)="e) One_curve Chronology"
      cnam(45)="Two_curve Chronology"

      OPEN(74,FILE="yamal/Fig2.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig2.col")) STOP
      DO j=1,11
        WRITE(74,'(A20)') wnam(20+j)
        WRITE(74,'("  Year Count  100-yr  Smooth   1-RCS   2-RCS")') 
        DO i=cfy(j),cly(j)
          WRITE(74,'(2I6,4F8.3)') i-1+cfy(80),num(i,40+j), &
            crn(i,40+j),crn(i,52+j),crn(i,j),crn(i,11+j)
        ENDDO
        WRITE(74,*) 
      ENDDO
      WRITE(74,'(A20)') wnam(32)
      WRITE(74,'("  Year Count  100-yr  Smooth")') 
      DO i=cfy(52),cly(52)
        WRITE(74,'(2I6,4F8.3)') i-1+cfy(80),num(i,52), &
          crn(i,52),crn(i,64)
      ENDDO
      WRITE(74,*) 
      WRITE(74,'("Smoothed RCS Chronologies")') 
      WRITE(74,'("  Year Count   1-RCS   2-RCS")') 
      DO i=1,cyr(80)
        WRITE(74,'(2I6,2F8.3)') i-1+cfy(80),num(i,80), &
          crn(i,80),crn(i,81)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Fig2
!------------------------------------------------------------------------
      SUBROUTINE Runmnd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r
      grl=200 ; grr=2000 ; grt=110 ; grb=410
      CALL NAME('Index','Y')
      CALL NAME('','X')
      CALL LABELS('FLOAT','X')
      DO j=1,4
        p=cfy(j) ; q=cly(j) ; r=q-p+1
        wka(1:r)=(/(DBLE(i),i=p,q)/) 
        CALL plot_trees(r,num(1:r,j))  
        IF (j.EQ.3) THEN
          CALL tombox(p,q,-0.8D0,0.8D0)
        ELSEIF (j.EQ.4) THEN
          CALL NAME('Calendar Year','X')
          CALL tombox(p,q,-1.2D0,1.2D0)
        ELSE
          CALL tombox(p,q,-1.2D0,1.2D0)
        ENDIF
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        IF (j.EQ.1) THEN
          CALL SETCLR(blue)
          CALL MESSAG("25-year Mean Index",grl+100,grt-45)
          CALL SETCLR(red)
          CALL MESSAG("50-year Mean Index",grl+700,grt-45)
          CALL SETCLR(black)
          CALL MESSAG("100-year Mean index",grl+1300,grt-45)
        ENDIF 
        CALL SETCLR(blue)
        p=cfy(j+8) ; q=cly(j+8) ; r=q-p+1
        CALL CURVE(wka(p:q),crn(p:q,j+8),r)
        CALL SETCLR(red)
        p=cfy(j+16) ; q=cly(j+16) ; r=q-p+1
        CALL CURVE(wka(p:q),crn(p:q,j+16),r)
        CALL SETCLR(black)
        p=cfy(j+24) ; q=cly(j+24) ; r=q-p+1
        CALL CURVE(wka(p:q),crn(p:q,j+24),r)
        CALL MESSAG(wnam(20+j),grl+300,grt+30)
        CALL ENDGRF() 
        grt=grt+370 ; grb=grb+370
      ENDDO
      RETURN 
      END SUBROUTINE Runmnd
!-------------------------------------------------------------------
      SUBROUTINE Runmn1d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r
      grl=200 ; grr=2000 ; grt=110 ; grb=410
      CALL NAME('Std. Dev.','Y')
      CALL NAME('','X')
      CALL LABELS('FLOAT','X')
      DO j=1,4
        p=cfy(j) ; q=cly(j) ; r=q-p+1
        wka(1:r)=(/(DBLE(i),i=p,q)/) 
        CALL plot_trees(r,num(1:r,j))  
        IF (j.EQ.3) THEN
          CALL tombox(p,q,0.D0,1.2D0)
        ELSEIF (j.EQ.4) THEN
          CALL NAME('Calendar Year','X')
          CALL tombox(p,q,0.D0,1.2D0)
        ELSE
          CALL tombox(p,q,0.D0,1.2D0)
        ENDIF
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        IF (j.EQ.1) THEN
          CALL SETCLR(blue)
          CALL MESSAG("25-year Mean SDev",grl+100,grt-45)
          CALL SETCLR(red)
          CALL MESSAG("50-year Mean SDev",grl+700,grt-45)
          CALL SETCLR(black)
          CALL MESSAG("100-year Mean SDev",grl+1300,grt-45)
        ENDIF 
        CALL SETCLR(blue)
        p=cfy(j+8) ; q=cly(j+8) ; r=q-p+1
        CALL CURVE(wka(p:q),crn(p:q,j+12),r)
        CALL SETCLR(red)
        p=cfy(j+16) ; q=cly(j+16) ; r=q-p+1
        CALL CURVE(wka(p:q),crn(p:q,j+20),r)
        CALL SETCLR(black)
        p=cfy(j+24) ; q=cly(j+24) ; r=q-p+1
        CALL CURVE(wka(p:q),crn(p:q,j+28),r)
        CALL MESSAG(wnam(20+j),grl+300,grt+30)
        CALL ENDGRF() 
        grt=grt+370 ; grb=grb+370
      ENDDO
      RETURN 
      END SUBROUTINE Runmn1d
!-------------------------------------------------------------------
      SUBROUTINE Runmn()   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxd) :: zx
      INTEGER,DIMENSION(1)   :: k
      INTEGER                :: i,j,n,m,p,q,r,w
      OPEN(19,FILE="Table1.prn",IOSTAT=ios,STATUS="REPLACE")
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(21)="a) Yamal TRW"
      wnam(22)="b) Polar TRW"
      wnam(23)="c) Polar MXD"
      wnam(24)="d) Yamalia TRW"
      CALL det_default() ; idt=-2 ; isb=1 ; sfo=2 ; tst=4
      src=2 ; srcno=2 ; idb=2    ! 2 curve RCS detrend - normal dist
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend() ; r=cyr(cf)
        IF (i.EQ.1) THEN      ! Yamal indices added to Yamalia
          n=ad(nc)+yr(nc)-1 ; zx(1:n)=dx(1:n)
        ELSEIF (i.EQ.2) THEN  ! Polar indices added to Yamalia
          m=ad(nc)+yr(nc)-1 ; zx(n+1:n+m)=dx(1:m)
        ENDIF 
      ENDDO
      nc=0 ; CALL read_rft(cnam(1)) 
      CALL read_rft(cnam(2))     ! Read tree data
      cf=4 ; CALL det_crnfy()    ! Set up chronology
      dx(1:n+m)=zx(1:n+m)        ! Use previously saved tree indices  
      CALL arith_mean(dx)        ! Create chronology
      r=cyr(cf) ; crn(1:r,cf)=xcrn(1:r,mx)

      num(1:3,100)=(/24,49,99/)
      DO i=1,4
        r=cyr(i)
        DO n=1,3 
          p=i+n*8 ; q=p+4 ; w=num(n,100) 
          crn(1:r,p)=0.D0 ; crn(1:r,q)=0.D0
          DO j=1,r-w     
            crn(j+w/2,p)=SUM(crn(j:j+w,i))/DBLE(w+1)     ! Mean   
            crn(j+w/2,q)=SQRT(SUM((crn(j:j+w,i)- &
              crn(j+w/2,p))**2)/DBLE(w))
          ENDDO
          cfy(p)=1+w/2 ; cly(p)=cfy(p)+r-w-1
          cyr(p)=cly(p)-cfy(p)+1
        ENDDO
      ENDDO 
      DO i=1,4    ! For each chronology
        r=cyr(i)
        DO n=1,3  ! 25, 50 and 100yr 
          p=i+n*8 ; q=p+4 ; w=num(n,100) 
          WRITE(19,'(I3," year for ",A18)') w+1,wnam(20+i)(3:18)
          WRITE(19,'(6X,"  From    To    Mean  St.Dev")')
          crn(1:r,100)=crn(w/2+1:w/2+r,p) ! Shift left for dates
          DO j=1,10  
            k=MINLOC(crn(1:r,100)) ; m=k(1)-1+cfy(i)
            WRITE(19,'(I2," Cold",2I6,2F8.4)') j,m,m+w, &
              crn(k(1),100),crn(k(1)+w/2,4+p)
            crn(MAX(1,k(1)-w):k(1)+w,100)=0.D0
          ENDDO
          WRITE(19,*)
          crn(1:r,100)=crn(w/2+1:w/2+r,p) ! Shift left for dates
          DO j=1,10  
            k=MAXLOC(crn(1:r,100)) ; m=k(1)-1+cfy(i)
            WRITE(19,'(I2," Warm",2I6,2F8.4)') j,m,m+w, &
              crn(k(1),100),crn(k(1)+w/2,4+p)
            crn(MAX(1,k(1)-w):k(1)+w,100)=0.D0
          ENDDO
          WRITE(19,*)
        ENDDO
      ENDDO
      CLOSE(19) 
      RETURN 
      END SUBROUTINE Runmn
!------------------------------------------------------------------------
      SUBROUTINE Fig8d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r,u,v
      num(1:8,10)=(/900,1200,1200,1500,1500,1800,1706,2006/)
      grl=200 ; grr=2000 ; grt=140 ; grb=440
      CALL NAME('','X')
      CALL NAME('Index','Y')
      DO j=1,8,2
        p=num(j,10) ; q=num(j+1,10) ; r=q-p+1
        wka(1:r)=(/(DBLE(i),i=p,q)/) 
        u=p-cfy(1)+1 ; v=u+r-1 
        IF (j.EQ.7) THEN
          CALL NAME('Calendar Year','X')
        ELSEIF (j.EQ.1) THEN
          CALL SETCLR(blue)
          CALL MESSAG(wnam(20),grl+200,grt-45)
          CALL SETCLR(red)
          CALL MESSAG(wnam(21),grl+700,grt-45)
          CALL SETCLR(black)
          CALL MESSAG(wnam(22),grl+1200,grt-45)
        ENDIF
        CALL tombox(p,q,-2.0D0,2.0D0)
        CALL SETCLR(grey)  ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1)     ; CALL HEIGHT(22)
        CALL SETCLR(blue)  ; CALL CURVE(wka(1:r),crn(u:v,1),r)
        CALL SETCLR(red)   ; CALL CURVE(wka(1:r),crn(u:v,2),r)
        CALL SETCLR(black) ; CALL CURVE(wka(1:r),crn(u:v,3),r)
        CALL ENDGRF() ; grt=grt+360 ; grb=grb+360
      ENDDO
      RETURN 
      END SUBROUTINE Fig8d
!-------------------------------------------------------------------
      SUBROUTINE Fig8()   ! Yam/Pol/ MXD compared
      IMPLICIT NONE                 
      INTEGER  :: j,p,q,r
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(20)="Yamal TRW"
      wnam(21)="Polar TRW"
      wnam(22)="Polar MXD"
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2 ; idb=2        ! RCS, Sig free, normal
      src=2 ; srcno=2 
      DO j=1,3
        nc=0 ; CALL read_rft(cnam(j))
        cnam(42)="Two-curve Normal" 
        cf=j ; CALL detrend()
      ENDDO
      p=cfy(2)-cfy(1)+1 ; q=p+cyr(2)-1 ; r=q-p+1
      crn(p:q,2)=crn(1:r,2) ; crn(1:p-1,2)=0.D0
      num(p:q,2)=num(1:r,2) ; num(1:p-1,2)=0
      p=cfy(3)-cfy(1)+1 ; q=p+cyr(3)-1 ; r=q-p+1
      crn(p:q,3)=crn(1:r,3) ; crn(1:p-1,3)=0.D0
      num(p:q,3)=num(1:r,3) ; num(1:p-1,3)=0
      crn(cyr(1)+1,1)=0.D0 ; idb=1
      OPEN(74,FILE="yamal/Fig8.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig8.col")) STOP
      WRITE(74,'("Year")') 
      WRITE(74,'("Count ",A20)') wnam(20)
      WRITE(74,'("Count ",A20)') wnam(21)
      WRITE(74,'("Count ",A20)') wnam(22)
      WRITE(74,'("Chronology ",A20)') wnam(20)
      WRITE(74,'("Chronology ",A20)') wnam(21)
      WRITE(74,'("Chronology ",A20)') wnam(22)
      DO j=1,cyr(1)+1
        WRITE(74,'(4I6,3F8.3)') j-1+cfy(1),num(j,1:3),crn(j,1:3)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Fig8
!------------------------------------------------------------------------
      SUBROUTINE PY25()   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      INTEGER  :: r
      cnam(1)="../../raw/yam/yml-all.raw"
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2 ; idb=2        ! RCS, Sig free, normal
      nc=0 ; CALL read_rft(cnam(1))
      cf=1 ; src=2 ; srcno=2
      cnam(42)="Two-curve Normal" 
      CALL detrend() ; r=cyr(cf) 
      crn(1:r,2)=xcsm(1:r,mx) ; idb=1  
      RETURN 
      END SUBROUTINE PY25
!------------------------------------------------------------------------
      SUBROUTINE PY25d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r,u,v
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grl=200 ; grr=1600 ; grt=140 ; grb=440
      CALL NAME('','X')
      DO j=1,5
        p=-700+(j-1)*300 ; q=p+299 ; r=q-p+1
        u=p-cfy(1)+1 ; v=u+r-1 
        CALL plot_treesq(r,num(u:v,1),159)  
        IF (j.EQ.5) THEN
          CALL NAME('Calendar Year','X')
        ELSEIF (j.EQ.1) THEN
          CALL MESSAG("Yamal TRW",grl+500,grt-45)
        ENDIF
        CALL tombox(p,q,-1.9D0,1.9D0)
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(black) ; CALL CURVE(wka(u:v),crn(u:v,1),r)
        CALL SETCLR(red)   ; CALL CURVE(wka(u:v),crn(u:v,2),r)
        CALL SETCLR(black) ; CALL ENDGRF() 
        grt=grt+360 ; grb=grb+360
      ENDDO
      RETURN 
      END SUBROUTINE PY25d
!-------------------------------------------------------------------
      SUBROUTINE PY28(ref1)   ! 1-2-3 RCS curves compared
      IMPLICIT NONE                 
      INTEGER,INTENT(IN) :: ref1
      INTEGER            :: i,r
      IF (ref1.EQ.1) THEN
        cnam(1)="../../raw/yam/yml-all.raw"
        wnam(20)="Yamal TRW"
        wnam(21)="yamal/PY24.col"
      ELSEIF (ref1.EQ.2) THEN
        cnam(1)="../../raw/polar/polar.raw"
        wnam(20)="Polar TRW"
        wnam(21)="yamal/PY25.col"
      ELSEIF (ref1.EQ.3) THEN
        cnam(1)="../../raw/polar/polarxs.mxd"
        wnam(20)="Polar MXD"
        wnam(21)="yamal/PY26.col"
      ENDIF
      wnam(1)=wnam(20)(1:5)//wnam(20)(7:9)//"2013.crn" 
      cnam(42)="Two-curve Normal" 
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2 ; idb=2        ! RCS, Sig free, normal
      nc=0 ; CALL read_rft(cnam(1))
      cf=1 ; src=2 ; srcno=2
      CALL detrend() ; r=cyr(cf) 
      append=FA ; CALL write_index(wnam(1))
      crn(1:r,2)=xcsm(1:r,mx) ; idb=1  
      OPEN(74,FILE=wnam(21),IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open",wnam(21))) STOP
      WRITE(74,'(A20)') wnam(20)
      WRITE(74,'("Year")') 
      WRITE(74,'("Tree Count")') 
      WRITE(74,'("Chronology")') 
      WRITE(74,'("Smoothed chronology")') 
      DO i=1,cyr(1)
        WRITE(74,'(2I6,6F8.3)') i-1+cfy(1),num(i,1),crn(i,1:2)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE PY28
!------------------------------------------------------------------------
      SUBROUTINE PY28d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j=1,p,q,r,u,v
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      grl=200 ; grr=1600 ; grt=1220 ; grb=1520
      CALL NAME('','X')
      q=cly(1) ; r=300 ; p=q-r+1
      u=p-cfy(1)+1 ; v=u+r-1 
      CALL NAME('z-score','X')
      DO j=4,1,-1
        CALL plot_treesq(r,num(u:v,1),159)  
        IF (j.EQ.4) THEN
          CALL NAME('Calendar Year','X')
        ELSEIF (j.EQ.1) THEN
          CALL MESSAG(wnam(20),grl+500,grt-45)
        ELSEIF (j.EQ.3) THEN
          CALL NAME('','X')
        ENDIF
        CALL tombox(p,q,-1.9D0,1.9D0)
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(black) ; CALL CURVE(wka(u:v),crn(u:v,1),r)
        CALL SETCLR(red)   ; CALL CURVE(wka(u:v),crn(u:v,2),r)
        CALL SETCLR(black) ; CALL ENDGRF() 
        u=MAX(u-300,1) ; v=u+299
        p=MAX(p-300,cfy(1)) ; q=p+299
        grt=grt-360 ; grb=grb-360
      ENDDO
      RETURN 
      END SUBROUTINE PY28d
!-------------------------------------------------------------------
      SUBROUTINE read_UUm(st,sit) ! Read Polar MXD adjusted sites
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)                  :: st  ! Number of sites
      INTEGER,DIMENSION(0:st),INTENT(OUT) :: sit ! Site tree address
      INTEGER  :: i
      cnam(1)="../../raw/polar/poula/pou_la_modadj.mxd"
      wnam(21)="Pou_la_mod"   ! 23 trees
      cnam(2)="../../raw/polar/poula/pou_la_stem.mxd"
      wnam(22)="pou_la_stem"  ! 47 trees
      cnam(3)="../../raw/polar/poula/polurulaxadj.mxd"
      wnam(23)="Polurula"     ! 32 trees
      cnam(4)="../../raw/polar/purla/purlaxadj1.mxd"
      wnam(24)="Purlasim"     ! 23 trees
      cnam(5)="../../raw/polar/purla/purlaxadj2.mxd"
      wnam(25)="Purlasi-scm"  ! 16 trees 
      nc=0 ; sit(0)=0                 
      DO i=1,st               ! Read all sites
        CALL read_rft(cnam(i)) ; sit(i)=nc
      ENDDO
      RETURN 
      END SUBROUTINE read_UUm
!------------------------------------------------------------------------
      SUBROUTINE read_UU(st,sit)  ! Read Polar TRW no roots sites
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)                  :: st  ! Number of sites
      INTEGER,DIMENSION(0:st),INTENT(OUT) :: sit ! Site tree address
      INTEGER  :: i
      cnam(1)="../../raw/polar/poula/pou_la_mod.raw"
      wnam(21)="Pou_la_mod"
      cnam(2)="../../raw/polar/poula/pou_la_stem.raw"
      wnam(22)="pou_la_stem"
      cnam(3)="../../raw/polar/poula/polustem.raw"
      wnam(23)="Polustem"
      cnam(4)="../../raw/polar/purla/purlasim.raw"
      wnam(24)="Purlasim"
      cnam(5)="../../raw/polar/purla/purlasi_scm.raw"
      wnam(25)="Purlasi-scm"
      cnam(6)="../../raw/ural/russ001.rwl"
      wnam(26)="Russ001"
      nc=0 ; sit(0)=0                 
      DO i=1,st                    ! Read all sites
        CALL read_rft(cnam(i)) ; sit(i)=nc
      ENDDO
      RETURN 
      END SUBROUTINE read_UU
!------------------------------------------------------------------------
      SUBROUTINE FigUU(ref1)   ! Was yml_sep3r()
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)          :: ref1  ! TRW=1, MXD=2
      INTEGER,DIMENSION(0:7-ref1) :: sit   ! site tree address
      REAL(8),DIMENSION(mxd)      :: qx    ! Raw data storage
      REAL(8),DIMENSION(mxd)      :: yx    ! Raw data storage
      INTEGER  :: i,j,k1,k2,k3,p,q,r,s,t,u,v,w,st
      st=7-ref1 
      IF (ref1.EQ.1) THEN
        CALL read_UU(st,sit)      ! Reads 6 Polar sites
        cnam(41)="a) TRW Separate Chronologies" 
        cnam(44)="d) TRW Chronologies"
      ELSE
        CALL read_UUm(st,sit)     ! Reads 6 Polar sites
        cnam(41)="a) MXD Separate Chronologies" 
        cnam(44)="d) MXD Chronologies"
      ENDIF
      cnam(42)="b) One-curve RCS"
      cnam(43)="c) Two-curve RCS"
      CALL det_default()
      cf=80 ; sfo=2 ; idt=-2              ! RCS - Sig free ON
      src=1 ; srcno=1 ; CALL detrend()    ! 1 RCS curve detrend  
      j=ad(nc)+yr(nc)-1       
      yx(1:j)=dx(1:j)                     ! Store tree index values
      qx(1:j)=fx(1:j)                     ! Store signal-free measures 
      cf=81
      src=2 ; srcno=2 ; CALL detrend()    ! 2 RCS curve detrend   
      w=cyr(cf)
      crn(1:w,1:st*4)=0.D0 ; num(1:w,1:st*4)=0  
      cfy(1:st*2)=w ; cly(1:st*2)=-w  
      DO i=1,st                           ! Each site
        k1=i+st ; k2=k1+st ; k3=k2+st
        DO j=sit(i-1)+1,sit(i)            ! Each tree at that site
          p=ad(j) ; r=yr(j) ; q=p+r-1     ! Ring address 
          u=fy(j)-cfy(cf)+1 ; v=u+r-1     ! Chronology address
          s=fy(j)-pth(j)+1  ; t=s+r-1     ! RCS address
          cfy(i)=MIN(cfy(i),s)
          cly(i)=MAX(cly(i),t)
          cfy(k1)=MIN(cfy(k1),u)
          cly(k1)=MAX(cly(k1),v)
          WHERE (xok(p:q))
            crn(s:t,i)=crn(s:t,i)+qx(p:q)    ! SF measures 1 RCS
            crn(s:t,k2)=crn(s:t,k2)+fx(p:q)  ! SF measures 2 RCS
            num(s:t,i)=num(s:t,i)+1
            crn(u:v,k1)=crn(u:v,k1)+yx(p:q)  ! Tree indices 1 RCS
            crn(u:v,k3)=crn(u:v,k3)+dx(p:q)  ! Tree indices 2 RCS
            num(u:v,k1)=num(u:v,k1)+1
          END WHERE
        ENDDO
      ENDDO
      cyr(1:st*2)=cly(1:st*2)-cfy(1:st*2)+1 
      WHERE (num(1:w,1:st).GT.1)           ! Mean vaues
        crn(1:w,1:st)=crn(1:w,1:st)/DBLE(num(1:w,1:st))
        crn(1:w,1+st*2:st*3)=crn(1:w,1+st*2:st*3)/DBLE(num(1:w,1:st))
      END WHERE
      WHERE (num(1:w,st+1:2*st).GT.1)      ! Mean vaues
        crn(1:w,st+1:2*st)=crn(1:w,st+1:2*st)/DBLE(num(1:w,st+1:2*st))
        crn(1:w,1+st*3:4*st)=crn(1:w,1+st*3:4*st)/DBLE(num(1:w,st+1:2*st))
      END WHERE
      DO i=1,st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1      ! Age-dep RCS smoothing
        CALL spline3(r,crn(p:q,i),num(p:q,i),10,crn(p:q,i),FA)  
        CALL spline3(r,crn(p:q,i+2*st),num(p:q,i),10,crn(p:q,i+2*st),FA)  
      ENDDO 
      DO i=st+1,2*st                            
        p=cfy(i) ; r=cyr(i) ; q=p+r-1  ! 20-year spline smoothing
        CALL splinet(r,crn(p:q,i),20,crn(p:q,i))
        CALL splinet(r,crn(p:q,i+2*st),20,crn(p:q,i+2*st))
      ENDDO 
      CALL det_default()
      sfo=2 ; idt=-2 ; src=1       ! RCS 1 curve, SF ON
      crn(1:3000,82)=0.D0 ; num(1:3000,82)=0  
      DO i=4*st+1,5*st             ! Process each site separately
        nc=0 ; CALL read_rft(cnam(i-4*st))
        cf=i+st ; CALL detrend()  
        p=sfy(mx) ; q=sly(mx) ; r=q-p+1
        cfy(i)=p ; cly(i)=q ; cyr(i)=r
        crn(1:r,i)=msmo(1:r,mx)    ! Separate RCS
        num(1:r,i)=mcnt(1:r,mx)    ! Separate RCS count
        r=cyr(cf) ; p=cfy(cf)-cfy(80)+1 ; q=p+r-1
        crn(p:q,82)=crn(p:q,82)+crn(1:r,cf)*DBLE(num(1:r,cf)) 
        num(p:q,82)=num(p:q,82)+num(1:r,cf) 
        CALL splinet(r,crn(1:r,cf),20,crn(1:r,cf))
      ENDDO
      WHERE (num(1:w,82).GT.1) &          ! Mean vaues
        crn(1:w,82)=crn(1:w,82)/DBLE(num(1:w,82))
      DO i=80,82                  ! Smooth chronologies
        CALL splinet(w,crn(1:w,i),50,crn(1:w,i))
      ENDDO 
      cf=80
      RETURN 
      END SUBROUTINE FigUU
!------------------------------------------------------------------------
      SUBROUTINE FigUUcd(ref1)  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1  ! TRW=1, MXD=2
      INTEGER,DIMENSION(6),PARAMETER :: col=(/1,2,3,4,5,red/)
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,m,p,q,u,v,r,w,st
      st=7-ref1 
      grl=200 ; grr=2400 ; grt=120 ; grb=470
      w=cyr(cf) ; wka(1:w)=(/(DBLE(i),i=cfy(cf),cly(cf))/) 
      CALL NAME('Index Values','Y')    ! Axis name
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      DO j=1,3
        IF (j.EQ.1) THEN
          wka(1:2010-1600+1)=(/(DBLE(i),i=1600,2010)/) 
        ELSEIF (j.EQ.2) THEN
        ELSE
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X')
        ENDIF
        IF (ref1.EQ.1) THEN
          CALL tombox(1600,2006,0.D0,2.6D0)
        ELSE
          CALL tombox(1600,2006,0.7D0,1.25D0)
        ENDIF
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(2) ; CALL HEIGHT(22)
        DO i=st+1,st+st
          CALL SETCLR(col(i-st))
          p=MAX(cfy(i),1600-cfy(cf)+1)
          r=cyr(i) ; q=p+r-1
          IF (j.EQ.1) THEN
            m=i+4*st
            p=MAX(cfy(m),1600)-cfy(m)+1 ; q=cyr(m) ; r=q-p+1
            u=MAX(cfy(m),1600)-1600+1 ; v=u+r-1 
            CALL thickthin(r,wka(u:v),crn(p:q,m),num(p:q,m),3)
            CALL MESSAG(wnam(i-st+20)(1:12),grl+(i-st)*350-300,grt-45)
          ELSEIF (j.EQ.2) THEN
            CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
          ELSE
            CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
          ENDIF
        ENDDO 
        CALL SETCLR(black)
        CALL MESSAG(cnam(40+j),grl+500,grt+30)
        CALL ENDGRF() ; CALL LINWID(1)
        grt=grt+360 ; grb=grb+360  
      ENDDO

      w=cyr(80)
      wka(1:w)=(/(DBLE(i),i=cfy(80),cly(80))/) 
      grt=1320 ; grb=1720
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')
      IF (ref1.EQ.1) THEN
        CALL tombox(cfy(80),2006,0.3D0,2.3D0)
      ELSE
        CALL tombox(cfy(80),2006,0.8D0,1.2D0)
      ENDIF
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      p=1 ; q=cyr(80) ; r=q-p+1 
      CALL SETCLR(red)
      CALL thickthin(r,wka(p:q),crn(p:q,82),num(p:q,80),6)
      CALL MESSAG("Separate Sites mean",grl+600,grt+30)
      CALL SETCLR(blue)
      CALL thickthin(r,wka(p:q),crn(p:q,80),num(p:q,80),6)
      CALL MESSAG("One RCS curve",grl+1100,grt+30)
      CALL SETCLR(black)
      CALL thickthin(r,wka(p:q),crn(p:q,81),num(p:q,80),6)
      CALL MESSAG("Two RCS curves",grl+1600,grt+30)
      CALL MESSAG(cnam(44),grl+40,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE FigUUcd 
!-------------------------------------------------------------------
      SUBROUTINE FigUUrd(ref1)  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1  ! TRW=1, MXD=2
      INTEGER,DIMENSION(6),PARAMETER :: col=(/1,2,3,4,5,red/)
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,p,q,r,st
      st=7-ref1
      grl=200 ; grr=2400 ; grt=120 ; grb=470
      wka(1:1000)=(/(DBLE(i),i=1,1000)/) 
      CALL NAME('Ring Width','Y')    ! Axis name
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      DO j=1,3
        IF (j.EQ.3) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Ring Age','X')
        ENDIF
        IF (ref1.EQ.1) THEN
          CALL tombox(1,400,0.D0,1.5D0)
        ELSE
          CALL tombox(1,400,0.55D0,0.85D0)
        ENDIF
        CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
        CALL LINWID(2) ; CALL HEIGHT(22)
        DO i=1,st
          CALL SETCLR(col(i))
          p=cfy(i) ; q=cyr(i) ; r=q-p+1
          IF (j.EQ.1) THEN
            CALL thickthin(r,wka(p:q),crn(p:q,i+4*st),num(p:q,i),3)
            CALL MESSAG(wnam(i+20)(1:12),grl+i*350-300,grt-45)
          ELSEIF (j.EQ.2) THEN
            CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
          ELSE
            CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
          ENDIF
        ENDDO 
        CALL SETCLR(black)
        CALL MESSAG(cnam(40+j),grl+1000,grt+30)
        CALL ENDGRF() ; CALL LINWID(1)
        grt=grt+360 ; grb=grb+360  
      ENDDO
      RETURN 
      END SUBROUTINE FigUUrd 
!-------------------------------------------------------------------
      SUBROUTINE UU_sep100(ref1) 
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)          :: ref1
      INTEGER,DIMENSION(0:7-ref1) :: sit    ! site tree address
      REAL(8),DIMENSION(mxd)      :: zx
      INTEGER                     :: i,j,p,q,r,u,v,st
      CALL det_default() ; sfo=2 ; idt=-2  ! RCS - Sig free ON 
      IF (ref1.EQ.1) THEN
        st=6 ; CALL read_UU(st,sit) ; wnam(41)="TRW"
      ELSE
        st=5 ; CALL read_UUm(st,sit) ; wnam(41)="MXD"
      ENDIF 
      cf=4*st+1 
      CALL detrend() ; i=ad(nc)+yr(nc)-1   ! RCS chronology
      zx(1:i)=dx(1:i) ; idt=100
      cf=cf+1 ; CALL detrend ; r=cyr(cf) ! Spline chronology
      crn(1:r,1:st*4)=0.D0 ; num(1:r,1:st*4)=0
      cfy(1:st)=3000 ; cly(1:st)=-1000
      DO j=1,st                      ! For each site
        DO i=sit(j-1)+1,sit(j)       ! For each tree at site 
          p=ad(i) ; q=p+yr(i)-1
          u=fy(i)-cfy(cf)+1 ; v=u+yr(i)-1
          cfy(j)=MIN(cfy(j),u)
          cly(j)=MAX(cly(j),v)
          WHERE (xok(p:q))         ! Full chronology
            crn(u:v,j)=crn(u:v,j)+dx(p:q)
            crn(u:v,j+st)=crn(u:v,j+st)+zx(p:q)
            num(u:v,j)=num(u:v,j)+1

          END WHERE
        ENDDO
      ENDDO
      cyr(1:st)=cly(1:st)-cfy(1:st)+1
      okc(1:r,1:st)=num(1:r,1:st).GE.1
      DO j=1,st
        p=cfy(j) ; q=cly(j) ; r=q-p+1
        WHERE (okc(p:q,j)) 
          crn(p:q,j)=crn(p:q,j)/DBLE(num(p:q,j)) 
          crn(p:q,j+st)=crn(p:q,j+st)/DBLE(num(p:q,j)) 
        END WHERE
        CALL splinet(r,crn(p:q,j),10,crn(p:q,j+2*st))
        CALL splinet(r,crn(p:q,j+st),10,crn(p:q,j+3*st))
      ENDDO
      RETURN 
      END SUBROUTINE UU_sep100
!------------------------------------------------------------------------
      SUBROUTINE UU_sepd(ref1)  
      IMPLICIT NONE                 
      INTEGER,INTENT(IN)     :: ref1
      INTEGER,PARAMETER      :: fr=1601, to=2005
      INTEGER,DIMENSION(6),PARAMETER :: col=(/1,2,3,4,5,red/)
      REAL(8),DIMENSION(mxy) :: wka 
      REAL(8)                :: ra,rb
      INTEGER                :: i=1,p,q,r,st
      IF (ref1.EQ.1) THEN 
        st=6 ; ra=0.D0 ; rb=3.D0
      ELSE
        st=5 ; ra=0.51D0 ; rb=1.4D0
      ENDIF 
      r=cyr(cf)
      wka(1:r)=(/(DBLE(i),i=cfy(cf),cly(cf))/) 
      grl=200 ; grr=2000 ; grt=150 ; grb=500
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')        ! Axis name
      CALL tombox(fr,to,ra,rb)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(col(i))
        p=MAX(fr-cfy(cf)+1,cfy(i))
        q=MIN(to-cfy(cf)+1,cly(i)) ; r=q-p+1
        CALL thickthin(r,wka(p:q),crn(p:q,i),num(p:q,i),3)
        CALL MESSAG(wnam(i+20)(1:12),grl+i*300-280,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("a) 100-year Spline, Signal Free",grl+500,grt+30)
      CALL MESSAG(wnam(41),grl+250,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=510 ; grb=860
      CALL tombox(fr,to,ra,rb)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(col(i))
        p=MAX(fr-cfy(cf)+1,cfy(i))
        q=MIN(to-cfy(cf)+1,cly(i)) ; r=q-p+1
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) 10-year Low-Pass Smoothed",grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=870 ; grb=1220
      CALL NAME('Index Value','Y')        ! Axis name
      CALL tombox(fr,to,ra,rb)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(col(i))
        p=MAX(fr-cfy(cf)+1,cfy(i))
        q=MIN(to-cfy(cf)+1,cly(i)) ; r=q-p+1
        CALL thickthin(r,wka(p:q),crn(p:q,i+st),num(p:q,i),3)
       ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("c) One-curve Signal-free RCS",grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=1230 ; grb=1580
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')    ! Axis name
      CALL tombox(fr,to,ra,rb)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(col(i))
        p=MAX(fr-cfy(cf)+1,cfy(i))
        q=MIN(to-cfy(cf)+1,cly(i)) ; r=q-p+1
        CALL thickthin(r,wka(p:q),crn(p:q,i+3*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("d) 10-year Low-Pass Smoothed",grl+500,grt+30)
      CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE UU_sepd
!-------------------------------------------------------------------
      SUBROUTINE Fig6d()   ! Polar TRW 1,2,norm
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,p,q,r
      r=cyr(1) ; wka(1:r)=(/(DBLE(i),i=cfy(1),cly(1))/) 
      j=2007-cly(1) ; num(r+1:j,1)=0
      p=1 ; q=r 
      grl=200 ; grr=1890 ; grt=190 ; grb=540
      CALL NAME('','X')               ! Axis name
      CALL NAME('z score','Y')           ! Axis name
      CALL plot_treesnl(r+j,num(p:q+j,1))  
      CALL tombox(cfy(3),2006,-2.0D0,2.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl+200,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,2),r)
      CALL SETCLR(blue)
      CALL MESSAG(cnam(41),grl+800,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,4),r)
      CALL SETCLR(red)
      CALL MESSAG(cnam(42),grl+1400,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,6),r)
      CALL SETCLR(black)
      CALL MESSAG("a) Polar TRW Smoothed",grl+200,grt+35)
      CALL ENDGRF() 

      p=1901-cfy(1)+1 ; r=q-p+1
      grl=1900 ; grr=2400 ; grt=190 ; grb=540
      CALL TICKS(2,'X')        ! No Y ticks
      CALL LABELS('FLOAT','X')
      CALL NAME('','Y')           ! Axis name
      CALL LABELS('NONE','Y')
      CALL NAME('','X')                  ! Axis name
      CALL plot_trees(r+j,num(p:q+j,1))  
      CALL tombox(1901,2006,-2.0D0,2.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL CURVE(wka(p:q),crn(p:q,2),r)
      CALL SETCLR(blue)
      CALL CURVE(wka(p:q),crn(p:q,4),r)
      CALL SETCLR(red)
      CALL CURVE(wka(p:q),crn(p:q,6),r)
      CALL SETCLR(black)
      CALL MESSAG("b)",grl+50,grt+35)
      CALL ENDGRF() 
      CALL TICKS(10,'X')        ! No Y ticks

      p=1801-cfy(1)+1 ; r=q-p+1
      grl=200 ; grr=2400 ; grt=610 ; grb=960
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')               ! Axis name
      CALL LABELS('FLOAT','Y')
      CALL NAME('z score','Y')           ! Axis name
      CALL plot_trees(r+j,num(p:q+j,1))  
      CALL tombox(1801,2006,-3.5D0,4.0D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL CURVE(wka(p:q),crn(p:q,1),r)
      CALL SETCLR(blue)
      CALL CURVE(wka(p:q),crn(p:q,3),r)
      CALL SETCLR(red)
      CALL CURVE(wka(p:q),crn(p:q,5),r)
      CALL SETCLR(black)
      CALL MESSAG("c) Polar TRW",grl+200,grt+45)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE Fig6d
!-------------------------------------------------------------------
      SUBROUTINE Fig6()  ! Ppolar TRW 1-2-norm
      IMPLICIT NONE                 
      REAL(8)  :: mn,sd
      INTEGER  :: i,p,q,r,w
      cnam(1)="../../raw/polar/polar.raw" 
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2         ! RCS - Sig free ON
      nc=0 ; CALL read_rft(cnam(1))
      idb=1 ; src=1 ; srcno=1
      cnam(40)="One-curve RCS" 
      cf=1 ; CALL detrend() ; r=cyr(cf)
      p=900-cfy(cf)+1 ; q=1600-cfy(cf)+1 ; w=q-p+1
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+1))
      src=2 ; srcno=2
      cnam(41)="Two-curve RCS" 
      cf=cf+2 ; CALL detrend() 
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+1))
      idb=2
      cnam(42)="Two-curve RCS, Normal" 
      cf=cf+2 ; CALL detrend() 
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+1))
      idb=1
      OPEN(74,FILE="yamal/Fig6.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig6.col")) STOP
      WRITE(74,'("Polar TRW")') 
      WRITE(74,'("Year")') 
      WRITE(74,'("Tree Count")') 
      WRITE(74,'("One-curve RCS")') 
      WRITE(74,'("Two-curve RCS")') 
      WRITE(74,'("Two-curve RCS, Normal")') 
      WRITE(74,'("One-curve RCS Smoothed")') 
      WRITE(74,'("Two-curve RCS Smoothed")') 
      WRITE(74,'("Two-curve RCS, Normal Smoothed")') 
      DO i=1,cyr(3)
        WRITE(74,'(2I6,6F8.3)') i-1+cfy(1),num(i,1), &
          crn(i,1),crn(i,3),crn(i,5),crn(i,2),crn(i,4),crn(i,6)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Fig6
!------------------------------------------------------------------------
      SUBROUTINE Fig7d()   ! PU_sep100d
      IMPLICIT NONE                 
      INTEGER,PARAMETER      :: fr=778, to=2006, st=5
      INTEGER,DIMENSION(5),PARAMETER :: col=(/1,red,2,cyan,5/)
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,j,p,q,r
      r=cyr(cf) ; wka(1:r)=(/(DBLE(i),i=cfy(cf),cly(cf))/) 
      grl=200 ; grr=2000 ; grt=150 ; grb=500
      CALL LABELS('NONE','X')
      CALL NAME('','X')
      CALL NAME('Index Value','Y')        ! Axis name
      CALL tombox(fr,to,0.51D0,1.3D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(col(i))
        p=MAX(fr-cfy(cf)+1,cfy(i))
        q=MIN(to-cfy(cf)+1,cly(i)) ; r=q-p+1
        CALL thickthin(r,wka(p:q),crn(p:q,i+2*st),num(p:q,i),3)
        CALL MESSAG(wnam(i+20)(1:12),grl+i*300-280,grt-45)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("a) 100-year Spline, Signal Free",grl+100,grt+25)
      CALL MESSAG("10-year Low pass MXD",grl+1000,grt+25)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=510 ; grb=860
      CALL LABELS('FLOAT','X')
      CALL tombox(fr,to,0.51D0,1.3D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(2) ; CALL HEIGHT(22)
      DO i=1,st
        CALL SETCLR(col(i))
        p=MAX(fr-cfy(cf)+1,cfy(i))
        q=MIN(to-cfy(cf)+1,cly(i)) ; r=q-p+1
        CALL thickthin(r,wka(p:q),crn(p:q,i+3*st),num(p:q,i),3)
      ENDDO 
      CALL SETCLR(black)
      CALL MESSAG("b) One-curve Signal-free RCS",grl+300,grt+25)
      CALL MESSAG("10-year Low pass MXD",grl+1000,grt+25)
      CALL ENDGRF() ; CALL LINWID(1)

      r=cyr(71) ; wka(1:r)=(/(DBLE(i),i=cfy(71),cly(71))/) 
      j=2007-cly(71) ; num(r+1:j,71)=0
      p=1 ; q=r 
      grl=200 ; grr=1590 ; grt=990 ; grb=1340
      CALL NAME('','X')               ! Axis name
      CALL NAME('z score','Y')           ! Axis name
      CALL plot_treesnl(r+j,num(p:q+j,71))  
      CALL tombox(cfy(73),2006,-2.0D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL MESSAG(cnam(40),grl,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,72),r)
      CALL SETCLR(blue)
      CALL MESSAG(cnam(41),grl+500,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,74),r)
      CALL SETCLR(red)
      CALL MESSAG(cnam(42),grl+1000,grt-45)
      CALL CURVE(wka(p:q),crn(p:q,76),r)
      CALL SETCLR(black)
      CALL MESSAG("c) Polar MXD Smoothed",grl+200,grt+35)
      CALL ENDGRF() 

      p=1901-cfy(71)+1 ; r=q-p+1
      grl=1600 ; grr=2000 ; grt=990 ; grb=1340
      CALL TICKS(2,'X')        ! No Y ticks
      CALL LABELS('FLOAT','X')
      CALL NAME('','Y')           ! Axis name
      CALL LABELS('NONE','Y')
      CALL NAME('','X')                  ! Axis name
      CALL plot_trees(r+j,num(p:q+j,71))  
      CALL tombox(1901,2006,-2.0D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL CURVE(wka(p:q),crn(p:q,72),r)
      CALL SETCLR(blue)
      CALL CURVE(wka(p:q),crn(p:q,74),r)
      CALL SETCLR(red)
      CALL CURVE(wka(p:q),crn(p:q,76),r)
      CALL SETCLR(black)
      CALL MESSAG("d) Polar MXD",grl+50,grt+35)
      CALL ENDGRF() 
      CALL TICKS(10,'X')        ! No Y ticks

      p=1801-cfy(71)+1 ; r=q-p+1
      grl=200 ; grr=2000 ; grt=1410 ; grb=1760
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')               ! Axis name
      CALL LABELS('FLOAT','Y')
      CALL NAME('z score','Y')           ! Axis name
      CALL plot_trees(r+j,num(p:q+j,71))  
      CALL tombox(1801,2006,-3.9D0,2.6D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(black)
      CALL CURVE(wka(p:q),crn(p:q,71),r)
      CALL SETCLR(blue)
      CALL CURVE(wka(p:q),crn(p:q,73),r)
      CALL SETCLR(red)
      CALL CURVE(wka(p:q),crn(p:q,75),r)
      CALL SETCLR(black)
      CALL MESSAG("e) Polar MXD",grl+200,grt+45)
      CALL ENDGRF() 
      RETURN 
      END SUBROUTINE Fig7d
!-------------------------------------------------------------------
      SUBROUTINE Fig7()  ! PU_sep and PU_sep100
      IMPLICIT NONE                 
      INTEGER,PARAMETER :: st=5
      REAL(8)           :: mn,sd
      INTEGER           :: i=1,j,p,q,r,w
      CALL UU_sep100(2)    ! MXD separate sites
      cnam(1)="../../raw/polar/polarxs.mxd"
      CALL det_default() ; CDsp=50  ! Chronology Smoothing
      sfo=2 ; idt=-2         ! RCS - Sig free ON
      nc=0 ; CALL read_rft(cnam(1))
      idb=1 ; src=1 ; srcno=1
      cnam(40)="One-curve RCS" 
      cf=71 ; CALL detrend() ; r=cyr(cf)
      p=900-cfy(cf)+1 ; q=1600-cfy(cf)+1 ; w=q-p+1
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+1))
      src=2 ; srcno=2
      cnam(41)="Two-curve RCS" 
      cf=cf+2 ; CALL detrend() 
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))

      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+1))
      idb=2
      cnam(42)="Two-curve RCS, Normal" 
      cf=cf+2 ; CALL detrend() 
      mn=SUM(crn(p:q,cf),MASK=okc(p:q,cf))/DBLE(w)                 
      sd=SQRT(SUM((crn(p:q,cf)-mn)**2,MASK=okc(p:q,cf))/DBLE(w-1))
      crn(1:r,cf)=(crn(1:r,cf)-mn)/sd
      CALL splinet(r,crn(1:r,cf),50,crn(1:r,cf+1))
      idb=1
      DO j=1,st
        p=cfy(j) ; q=cly(j) ; r=q-p+1
        CALL splinet(r,crn(p:q,j+st),50,crn(p:q,j+3*st))
      ENDDO

      OPEN(74,FILE="yamal/Fig7.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/Fig7.col")) STOP
      WRITE(74,'("Tree Count ",A20)') wnam(21)
      WRITE(74,'("Tree Count ",A20)') wnam(22)
      WRITE(74,'("Tree Count ",A20)') wnam(23)
      WRITE(74,'("Tree Count ",A20)') wnam(24)
      WRITE(74,'("Tree Count ",A20)') wnam(25)
      WRITE(74,'("100-year Spline ",A20)') wnam(21) 
      WRITE(74,'("100-year Spline ",A20)') wnam(22) 
      WRITE(74,'("100-year Spline ",A20)') wnam(23) 
      WRITE(74,'("100-year Spline ",A20)') wnam(24) 
      WRITE(74,'("100-year Spline ",A20)') wnam(25) 
      WRITE(74,'("One-curve RCS ",A20)') wnam(21)
      WRITE(74,'("One-curve RCS ",A20)') wnam(22)
      WRITE(74,'("One-curve RCS ",A20)') wnam(23)
      WRITE(74,'("One-curve RCS ",A20)') wnam(24)
      WRITE(74,'("One-curve RCS ",A20)') wnam(25)
      DO i=1,cyr(cf)
        WRITE(74,'(6I5,10F8.3)') i-1+cfy(cf),num(i,1:5),crn(i,11:20)
      ENDDO
      WRITE(74,'("Polar MXD")') 
      WRITE(74,'("Year")') 
      WRITE(74,'("Tree Count")') 
      WRITE(74,'("One-curve RCS")') 
      WRITE(74,'("Two-curve RCS")') 
      WRITE(74,'("Two-curve RCS, Normal")') 
      WRITE(74,'("One-curve RCS Smoothed")') 
      WRITE(74,'("Two-curve RCS Smoothed")') 
      WRITE(74,'("Two-curve RCS, Normal Smoothed")') 
      DO i=1,cyr(71)
        WRITE(74,'(2I5,6F8.3)') i-1+cfy(71),num(i,71), &
          crn(i,71),crn(i,73),crn(i,75),crn(i,72),crn(i,74),crn(i,76)
      ENDDO
      CLOSE(74)
      RETURN 
      END SUBROUTINE Fig7
!------------------------------------------------------------------------
      SUBROUTINE yseasons(mf,mon,ran,tabc)  ! seasonal correlations 
      IMPLICIT NONE
      INTEGER,INTENT(IN)      :: mf      ! Met file number
      INTEGER,INTENT(IN)      :: mon     ! Months to plot
      INTEGER,INTENT(IN)      :: ran     ! Max months in mean 
      INTEGER,DIMENSION(mon,ran),INTENT(OUT) :: tabc  ! Correlation table
      REAL(8),DIMENSION(mmx)  :: wka
      INTEGER,DIMENSION(mmx)  :: wno
      LOGICAL,DIMENSION(mmx)  :: wok
      LOGICAL                 :: vok
      REAL(8)                 :: corr
      INTEGER                 :: i,j,k,p,q,r,s,t,u,v,w,m
      w=mf*12-11
      p=MINVAL(mfy(w:w+11))
      q=MAXVAL(mly(w:w+11))
      DO i=w,w+11   ! Align met data
        IF (mfy(i).GT.p) THEN
          r=mly(i)-mfy(i)+1 ; s=mfy(i)-p
          met(1+s:r+s,i)=met(1:r,i)
          okm(1+s:r+s,i)=okm(1:r,i)
          okm(1:s,i)=FA ; okm(r+1:q-p+1,i)=FA
          met(1:s,i)=-999.D0 ; met(r+1:q-p+1,i)=-999.D0
          mfy(i)=p ; mly(i)=q 
        ENDIF
        WRITE(79,'(3I6,6F8.1)') i,p,q,met(1:6,i)
      ENDDO
      p=MAX(cfy(cf),mfy(w))  ! Period of overlap
      q=MIN(cly(cf),MINVAL(mly(w:w+11)))
      m=q-p+1   ! Years in correlations
      IF (m.LT.20) THEN
        WRITE(mess(1:30),'(5I6)') cly(cf),mly(w),cf,w
        CALL out_err(mess(1:30))
        CALL out_err("Insufficient data")
        STOP
      ENDIF
      s=p-cfy(cf)+1 ; t=s+m-1    ! Chronology address
      u=p-mfy(w)+1 ; v=u+m-1     ! Met address 
      DO k=1,ran         ! Months in season
        DO j=1,mon       ! For each month 
          wka(1:m)=0.D0 ; wok(1:m)=FA ; wno(1:m)=0
          DO i=j-k/2,j-k/2+k-1
            IF (i.LT.1) THEN       ! Last year
              WHERE (okm(u:v-1,w-1+i+12))
                wka(2:m)=wka(2:m)+met(u:v-1,w-1+i+12)
                wno(2:m-1)=wno(2:m-1)+1
              END WHERE
              wno(1)=-20  ! First year not available
            ELSEIF (i.GT.12) THEN  ! Next year 
              WHERE (okm(u+1:v,w-1+i-12))
                wka(1:m-1)=wka(1:m-1)+met(u+1:v,w-1+i-12)
                wno(1:m-1)=wno(1:m-1)+1
              END WHERE
              wno(m)=-20  ! Last year not available
            ELSE
              WHERE (okm(1:m,i))
                wka(1:m)=wka(1:m)+met(u:v,w-1+i)
                wno(1:m)=wno(1:m)+1
              END WHERE
            ENDIF
          ENDDO
          wok(1:m)=wno(1:m).GE.1     ! Mean value
          WHERE (wok(1:m)) wka(1:m)=wka(1:m)/DBLE(wno(1:m))
          CALL covmiss(crn(s:t,cf),wka(1:m),okc(s:t,cf).AND.wok(1:m), &
            m,corr,vok)
          IF (vok) THEN
            tabc(j,k)=NINT(corr*100.D0)
          ELSE
            tabc(j,k)=-999    ! Missing value
          ENDIF
        ENDDO
      ENDDO
      WRITE(79,*)
      DO i=1,12
        WRITE(79,'(A3,8I4)') mth(i),tabc(i,1:8)
      ENDDO
      RETURN
      END SUBROUTINE yseasons
!--------------------------------------------------------------
      SUBROUTINE yseasond()  
      IMPLICIT NONE                 
      INTEGER,DIMENSION(1:8),PARAMETER :: col= &
        (/lime,green,yellow,brown,maroon,red,pink,purple/)
      CHARACTER(3) :: lab
      INTEGER      :: ra,rb,rc,rd,yo,xo
      INTEGER      :: i=1,j=1,m,p,q
      CALL HEIGHT(22) ; CALL SETCLR(black) ; CALL LINWID(1)
      DO p=1,3    ! Each crn
        yo=p*20-1
        DO q=2,3  ! Each met 
          xo=q*20-1 
          DO i=1,8
            rc=-400+600*p+(9-i)*50 ; rd=rc-45
            DO j=1,12      
              rb=-2600+1400*q+j*100
              IF (MOD(i,2).EQ.0) rb=rb-50
              ra=rb-90
              m=MAX(1,MIN(8,num(xo+j,yo+i)/10))
              CALL SETCLR(col(m))          ! Background box
              CALL AREAF((/ra,rb,rb,ra/),(/rc,rc,rd,rd/),4)
              CALL SETCLR(black)
              WRITE(lab,'(I3)') num(xo+j,yo+i)
              CALL MESSAG(lab,ra,rd+10)         ! Correlation
              IF (i.EQ.1) CALL MESSAG(mth(j),ra+10,rd+60)
            ENDDO 
            WRITE(lab,'(I3)') i
            CALL MESSAG(lab(3:3),-1360+1400*q,rd+10)
          ENDDO
          CALL MESSAG(wnam(19+p)(1:10)//"  "//TRIM(cnam(q+21)), &
            -2600+1400*q,-450+600*p)
          CALL MESSAG("Length",-1420+1400*q,-450+600*p)
        ENDDO
      ENDDO 
      CALL SETCLR(black) 
      RETURN 
      END SUBROUTINE yseasond
!-------------------------------------------------------------------
      SUBROUTINE yseason()  ! Read Yamal grid box 
      IMPLICIT NONE
      INTEGER,PARAMETER          :: mon=12  ! months to plot
      INTEGER,PARAMETER          :: ran=8   ! max months in mean 
      INTEGER,DIMENSION(mon,ran) :: tabc    ! Correlation table
      INTEGER                    :: i,j,p,r,s
      OPEN(79,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      cnam(1)="../../raw/yam/yml-all.raw"
      cnam(2)="../../raw/polar/polar.raw"
      cnam(3)="../../raw/polar/polarxs.mxd"
      wnam(20)="Yamal TRW"
      wnam(21)="Polar TRW"
      wnam(22)="Polar MXD"
      cnam(23)="15 year High-Pass"
      cnam(24)="15-100 year Band Pass"
      CALL det_default() ; idt=-2 ; src=2 ; srcno=2  ! 2 curve RCS detrend
      idb=2 ; cnam(40)="Two RCS, Normal Distribution CRNs" 
      DO i=1,3
        nc=0 ; CALL read_rft(cnam(i))
        cf=i ; CALL detrend() ; r=cyr(i) 
        CALL splinet(r,crn(1:r,i),100,crn(1:r,i+3))  ! 100yr Low Pass   
        crn(1:r,i+6)=crn(1:r,i)-crn(1:r,i+3)         ! 100yr High Pass
        CALL splinet(r,crn(1:r,i+6),15,crn(1:r,i+9)) ! 100-15yr Band Pass   
        crn(1:r,i+12)=crn(1:r,i+6)-crn(1:r,i+9)      ! 15yr HP
        okc(1:r,i+12)=okc(1:r,i)
        okc(1:r,i+ 9)=okc(1:r,i)
      ENDDO
      cfy(10:12)=cfy(1:3) ;  cfy(13:15)=cfy(1:3)   
      cly(10:12)=cly(1:3) ;  cly(13:15)=cly(1:3)   
      cyr(10:12)=cyr(1:3) ;  cyr(13:15)=cyr(1:3)   

      metn(1)="../../raw/yam/clim/AdjvT67.5N67.5E.dat"
      met=0.D0 ; mcf=0 ; r=1 ; s=12 
      CALL read_metf(metn(1)) ; p=myr(r)
      mly(1:12)=MIN(2005,mly(1:12))   ! Yamal
      myr(1:12)=mly(1:12)-mfy(1:12)+1
      DO i=1,12   ! for each month
        r=myr(i)
        CALL spline_miss(r,met(1:r,i),100,met(1:r,i+48),okm(1:r,i))   ! 100yr Low Pass  
        WHERE (okm(1:r,i)) met(1:r,i+36)=met(1:r,i)-met(1:r,i+48)     ! 100yr High Pass - diff
        CALL spline_miss(r,met(1:r,i+36),15,met(1:r,i+24),okm(1:r,i)) ! 100-15yr Band Pass   
        WHERE (okm(1:r,i)) met(1:r,i+12)=met(1:r,i+36)-met(1:r,i+24)  ! Diff 15yr HP
        okm(1:r,i+12)=okm(1:r,i)
        okm(1:r,i+24)=okm(1:r,i)
        WHERE (.NOT.okm(1:r,1))
          met(1:r,i+24)=-999D0 ; met(1:r,i+12)=-999D0
        END WHERE  
      ENDDO
      mfy(13:24)=mfy(1:12) ; mfy(25:36)=mfy(1:12)   
      mly(13:24)=mly(1:12) ; mly(25:36)=mly(1:12)   
      myr(13:24)=myr(1:12) ; myr(25:36)=myr(1:12)   
      DO i=1,3       ! Each chronology 
        cf=i
        DO j=2,3     ! Each frequency
          cf=i+18-j*3  
          WRITE(79,'(A20,2X,A60)') wnam(i),metn(j)
          CALL yseasons(j,mon,ran,tabc)
          WRITE(79,*)
          num(j*20:j*20+mon-1,i*20:i*20+ran-1)=tabc     
        ENDDO
      ENDDO
      CLOSE(79)
      RETURN
      END SUBROUTINE yseason
!--------------------------------------------------------------
      SUBROUTINE yam_oldd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka
      INTEGER                :: i=1,j=1,m,p,q,r
      grl=200 ; grr=2000 ; grt=140 ; grb=460
      CALL LABELS('NONE','X')
      CALL NAME('','X') ! Axis name
      CALL NAME("z-scores",'Y')       ! Axis name
      DO j=1,5
        m=MAX(1,cfy(j)) 
        p=m-cfy(j)+1 ; q=cyr(j) ; r=q-p+1  
        wka(1:r)=(/(DBLE(i),i=m,cly(j))/) 
        IF (j.EQ.5) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X') ! Axis name
        ENDIF
        CALL plot_treesq(1997,num(p:p+1996,j),159)  
        CALL tombox(0,2008,-2.6D0,4.6D0)     
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(red) ; CALL CURVE(wka(1:r),crn(p:q,j),r)
        CALL LINWID(4) ; CALL SETCLR(black)
        CALL CURVE(wka(1:r),crn(p:q,j+5),r)
        CALL MESSAG(cnam(30+j),grl+30,grt+30)
        CALL ENDGRF() ; CALL LINWID(1) 
        grt=grt+330 ; grb=grb+330
      ENDDO
      RETURN 
      END SUBROUTINE yam_oldd
!-------------------------------------------------------------------
      SUBROUTINE yam_old() 
      IMPLICIT NONE                 
      INTEGER,PARAMETER :: fr=1, to=1996 ! Common period
      REAL(8) :: mn,sd 
      INTEGER :: i=1,j=1,p,q,r
      icf=0 ; num=0 
      CALL read_index("../../raw/yam/supp/Old_Yam.crn")
      cnam(31)="a) TRW 2002" 
      cnam(32)="b) TRW 2000" 
      cnam(33)="c) TRW 2008" 
      cnam(34)="d) TRW 2009" 
      cnam(35)="e) TRW 2013" 
      DO i=1,5   ! Normal and 50-year filter
        p=fr-cfy(i)+1 ; q=to-cfy(i)+1 ; r=q-p+1
        mn=SUM(crn(p:q,i))/DBLE(r)                 
        sd=SQRT(SUM((crn(p:q,i)-mn)**2)/DBLE(r-1))
        r=cyr(i) ; crn(1:r,i)=(crn(1:r,i)-mn)/sd
        CALL splinet(r,crn(1:r,i),50,crn(1:r,i+5))
      ENDDO
      OPEN(74,FILE="yamal/PY30.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/PY30.col")) STOP
      WRITE(74,'("All Normalised common period 1 to 1996")') 
      DO j=1,5
        WRITE(74,'(A12)') cnam(30+j)(1:12)
        WRITE(74,'("  Year Count     CRN  Smooth")') 
        DO i=1,cyr(j)
          WRITE(74,'(2I6,2F8.3)') i+cfy(j)-1, &
            num(i,j),crn(i,j),crn(i,j+5)
        ENDDO
      ENDDO
      CLOSE(74) 
      RETURN 
      END SUBROUTINE yam_old
!------------------------------------------------------------------------
      SUBROUTINE pol_oldd()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy)   :: wka
      INTEGER                  :: i=1,j=1,p,q,r,w
      grl=200 ; grr=2000 ; grt=100 ; grb=350
      CALL LABELS('NONE','X') ; w=2006-778+1
      CALL NAME('','X') ! Axis name
      CALL TICKS(0,'Y')        ! Y ticks 
      CALL NAME("z-score",'Y')       ! Axis name
      DO j=1,7
        p=cfy(j) ; q=cly(j) ; r=cyr(j)  
        wka(1:r)=(/(DBLE(i),i=p,q)/) 
        IF (j.EQ.7) THEN
          CALL LABELS('FLOAT','X')
          CALL NAME('Calendar Year','X') ! Axis name
        ENDIF 
        CALL plot_treesq(w,num(1:w,j),99)  
        CALL tombox(778,2006,-2.7D0,2.5D0)     
        CALL SETCLR(grey) ; CALL GRID(1,1)       ! Gridlines
        CALL LINWID(1) ; CALL HEIGHT(22)
        CALL SETCLR(red) 
        CALL CURVE(wka(1:r),crn(1:r,j),r)
        CALL LINWID(4) ; CALL SETCLR(black)
        CALL CURVE(wka(1:r),crn(1:r,j+8),r)
        CALL MESSAG(cnam(30+j),grl+30,grt+30)
        CALL ENDGRF() ; CALL LINWID(1) 
        grt=grt+260 ; grb=grb+260
      ENDDO
      CALL TICKS(5,'Y')        ! Y ticks 
      RETURN 
      END SUBROUTINE pol_oldd
!-------------------------------------------------------------------
      SUBROUTINE pol_old() 
      IMPLICIT NONE                 
      INTEGER,PARAMETER :: fr=961, to=1969 ! Common period
      REAL(8) :: mn,sd 
      INTEGER :: i=1,j=1,p,q,r
      num=0
      cnam(31)="a) Recon 1989" 
      cnam(32)="b) Recon 1995" 
      cnam(33)="c) TRW 1996" 
      cnam(34)="d) MXD 1996" 
      cnam(35)="e) TRW 2002" 
      cnam(36)="f) TRW 2013" 
      cnam(37)="g) MXD 2013" 
      cnam(40)="../../raw/yam/supp/dongraybill.dat" 
      OPEN(24,FILE=cnam(40),IOSTAT=ios,STATUS="OLD")
      IF (io_err("Open",cnam(40))) RETURN
      READ(24,*)   
      DO i=961,1969
        READ(24,'(5X,F8.3)') crn(i-960,1)
      ENDDO
      cfy(1)=961 ; cly(1)=1969 ; r=cly(1)-cfy(1)+1
      num(1:r,1)=0 ; cyr(1)=r ; CLOSE(24)  

      nc=0 ; CALL read_rft("../../raw/polar/poula/pou_lam.mxd")
      cf=2 ; CALL det_crnfy() 
      cnam(40)="../../raw/yam/supp/polerecon123.dat" 
      OPEN(24,FILE=cnam(40),IOSTAT=ios,STATUS="OLD")
      IF (io_err("Open",cnam(40))) RETURN
      READ(24,*)   
      DO i=914,1990
        READ(24,'(5X,F8.2)') crn(i-913,2)
      ENDDO
      cfy(2)=914 ; cly(4)=1990 ; r=cly(2)-cfy(2)+1
      num(1:r,2)=0 ; cyr(2)=r ; CLOSE(24) 

      nc=0 ; CALL read_rft("../../raw/polar/poula/pou_lam.raw")
      cf=3 ; CALL det_crnfy() 
      cnam(40)="../../raw/yam/supp/polartrw.norm" 
      OPEN(24,FILE=cnam(40),IOSTAT=ios,STATUS="OLD")
      IF (io_err("Open",cnam(40))) RETURN
      DO i=914,1990
        READ(24,'(21X,F8.2)') crn(i-913,3)
      ENDDO
      cfy(3)=914 ; cly(3)=1990 ; cyr(3)=cly(3)-cfy(3)+1
      CLOSE(24) 

      nc=0 ; CALL read_rft("../../raw/polar/poula/pou_lam.mxd")
      cf=4 ; CALL det_crnfy() 
      cnam(40)="../../raw/yam/supp/polarmxd.norm" 
      OPEN(24,FILE=cnam(40),IOSTAT=ios,STATUS="OLD")
      IF (io_err("Open",cnam(40))) RETURN
      DO i=914,1990
        READ(24,'(21X,F8.2)') crn(i-913,4)
      ENDDO
      cfy(4)=914 ; cly(4)=1990 ; cyr(4)=cly(4)-cfy(4)+1
      CLOSE(24) 
      icf=4 ; CALL read_index("../../raw/yam/supp/PolarEsp2002.crn")
      icf=5 ; CALL read_index("../../raw/yam/supp/PolarTRW2013.crn")
      icf=6 ; CALL read_index("../../raw/yam/supp/PolarMXD2013.crn")
      DO i=1,7
        p=fr-cfy(i)+1 ; q=to-cfy(i)+1 ; r=q-p+1
        mn=SUM(crn(p:q,i))/DBLE(r)                 
        sd=SQRT(SUM((crn(p:q,i)-mn)**2)/DBLE(r-1))
        r=cyr(i) ; crn(1:r,i)=(crn(1:r,i)-mn)/sd
        CALL splinet(r,crn(1:r,i),25,crn(1:r,i+8))
        p=cfy(i)-778+1 ; q=p+r-1
        num(p:q,i)=num(1:r,i) ; num(1:p-1,i)=0 
      ENDDO

      OPEN(74,FILE="yamal/PY31.col",IOSTAT=ios,STATUS="REPLACE")
      IF (io_err("Open"," yamal/PY31.col")) STOP
      WRITE(74,'("All Normalised common period 961 to 1969")') 
      DO j=1,7
        WRITE(74,'(A14)') cnam(30+j)(1:14)
        WRITE(74,'("  Year Count     CRN  Smooth")') 
        r=MAX(0,cfy(j)-778)  ! Counts offset for display
        DO i=1,cyr(j)
          WRITE(74,'(2I6,2F8.3)') i+cfy(j)-1, &
            num(i+r,j),crn(i,j),crn(i,j+8)
        ENDDO
      ENDDO
      CLOSE(74) 
      RETURN 
      END SUBROUTINE pol_old
!------------------------------------------------------------------------
      SUBROUTINE FigUUzd()  ! Was yml_sepr3d()  
      IMPLICIT NONE                 
      REAL(8),DIMENSION(mxy) :: wka 
      INTEGER                :: i=1,p,q,r,w
      grl=200 ; grr=2400 ; grt=120 ; grb=570
      w=cly(2)-1600+1 ; wka(1:w)=(/(DBLE(i),i=1600,cly(2))/) 
      CALL NAME('Index Values','Y')  ! Axis name
      CALL LABELS('NONE','X')
      CALL NAME('','X')              ! Axis name
      CALL tombox(1600,2006,0.44D0,1.35D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(red)
      CALL MESSAG("Pou_La Modern",grl+40,grt-45)
      p=cfy(1)-1600+1 ; r=cyr(1) ; q=p+r-1
      CALL thickthin(r,wka(p:q),crn(1:r,1),num(1:r,1),6)
      CALL SETCLR(blue)
      p=1600-cfy(2)+1 ; q=cyr(2) ; r=q-p+1
      CALL MESSAG("Together",grl+1240,grt-45)
      CALL thickthin(r,wka(1:r),crn(p:q,2),num(p:q,2),6)
      CALL SETCLR(black)
      CALL MESSAG("Separate",grl+640,grt-45)
      CALL thickthin(r,wka(1:r),crn(p:q,4),num(p:q,4),6)
      CALL ENDGRF() ; CALL LINWID(1)

      grt=580 ; grb=1030
      w=cly(2)-1600+1 ; wka(1:w)=(/(DBLE(i),i=1600,cly(2))/) 
      CALL NAME('Index Values','Y')  ! Axis name
      CALL LABELS('FLOAT','X')
      CALL NAME('Calendar Year','X')  ! Axis name
      CALL tombox(1600,2006,0.85D0,1.18D0)
      CALL SETCLR(grey) ; CALL GRID(1,1)  ! Gridlines
      CALL LINWID(1) ; CALL HEIGHT(22)
      CALL SETCLR(red)
      p=cfy(1)-1600+1 ; r=cyr(1) ; q=p+r-1
      CALL thickthin(r,wka(p:q),crn(1:r,5),num(1:r,1),6)
      CALL SETCLR(blue)
      p=1600-cfy(2)+1 ; q=cyr(2) ; r=q-p+1
      CALL thickthin(r,wka(1:r),crn(p:q,6),num(p:q,2),6)
      CALL SETCLR(black)
      CALL thickthin(r,wka(1:r),crn(p:q,8),num(p:q,3),6)
      CALL ENDGRF() ; CALL LINWID(1)
      RETURN 
      END SUBROUTINE FigUUzd 
!-------------------------------------------------------------------
      SUBROUTINE FigUUz()  
      IMPLICIT NONE                 
      INTEGER  :: i,p,q,r,w
      cnam(1)="../../raw/polar/poula/pou_la_modadj.mxd"
      cnam(2)="../../raw/polar/poula/pou_la_stem.mxd"
      cnam(3)="../../raw/polar/poula/polurulaxadj.mxd"
      cnam(4)="../../raw/polar/purla/purlaxadj1.mxd"
      cnam(5)="../../raw/polar/purla/purlaxadj2.mxd"
      nc=0 ; CALL read_rft(cnam(1)) 
      CALL det_default()
      sfo=2 ; idt=-2 ; src=1          ! RCS 1 curve, SF ON
      cf=1 ; CALL detrend()           ! Pou_la Mod chronology
      DO i=2,5 ; CALL read_rft(cnam(i)) ; ENDDO  ! Read 4 sites
      src=2 ; srcno=2                 ! Two-curve RCS 
      cf=2 ; CALL detrend() ; nc=0    ! All 5 sites
      DO i=2,5 ; CALL read_rft(cnam(i)) ; ENDDO  ! Read 4 sites
      cf=3 ; CALL detrend()           ! Other 4 sites
      r=cyr(2) ; p=cfy(1)-cfy(2)+1 ; w=cyr(1) ; q=p+w-1
      crn(1:r,4)=crn(1:r,3)*DBLE(num(1:r,3))
      num(1:r,4)=num(1:r,3)
      crn(p:q,4)=crn(p:q,4)+crn(1:w,1)*DBLE(num(1:w,1))
      num(p:q,4)=num(p:q,4)+num(1:w,1)
      WHERE (num(1:r,4).GT.1) &
        crn(1:r,4)=crn(1:r,4)/DBLE(num(1:r,4))
      r=cyr(1) ; CALL splinet(r,crn(1:r,1),50,crn(1:r,5))
      r=cyr(2) ; CALL splinet(r,crn(1:r,2),50,crn(1:r,6))
      CALL splinet(r,crn(1:r,3),50,crn(1:r,7))
      CALL splinet(r,crn(1:r,4),50,crn(1:r,8))
      OPEN(19,FILE="zzz.prn",IOSTAT=ios,STATUS="REPLACE")
      WRITE(19,'(3I5)') cfy(1),cly(1),cyr(1)
      WRITE(19,'(3I5)') cfy(2),cly(2),cyr(2)
      WRITE(19,'(3I5)') cfy(3),cly(3),cyr(3)
      DO i=1,cyr(2)
        WRITE(19,'(5I5,4F7.2)') i-1+cfy(2),num(i,1:4),crn(i,1:4)
      ENDDO 
      CLOSE(19) 
      RETURN 
      END SUBROUTINE FigUUz
!------------------------------------------------------------------------
     END MODULE yamal1 
