!
      PROGRAM cru2nc
!
      IMPLICIT NONE
!
!
!     Program that transforms the data sets available at 
!     http://ipcc-ddc.cru.uea.ac.uk/cru_data/datadownload/download_index.html
!     into netCDF files which follow the COARDS convention.
!
!     This program should be compiled with f90 and linked to netCDF. 
!     For instance :
!
!     f90 -I/usr/local/include -c cru2nc.f90
!     f90 -o cru2nc  cru2nc.o -L/usr/local/lib -lnetcdf
!
!     After unziping the file obtained from the Web execute the following 
!     command :
!
!     cru2nc file.dat
!
!     Good luck !
!
!     Jan Polcher (polcher@lmd.jussieu.fr) 
!
!
      INTEGER, PARAMETER ::  n_months = 12
      INTEGER :: n_cols, n_rows, n_years, n_boxes

      INTEGER, ALLOCATABLE, DIMENSION(:) :: grid
      REAL, ALLOCATABLE, DIMENSION(:,:,:) :: data
      !
      REAL scale, add
      REAL gd_size, xmin, ymin, xmax, ymax
      INTEGER year_min, year_max
      INTEGER ncols, nrows, nmonths, ind, im, ib, iy
      LOGICAL type
      character infl*72,fmt*20

      INTEGER ilon, ilat

      REAL missing_r
      INTEGER missing_i
!
!     netCDF
!
!      INCLUDE "netcdf.inc"
      INTEGER dimlonid, dimlatid, dimtimid
      INTEGER solid, preid, lwid, tid, qid, pid, uid, vid
      INTEGER iret, fid, lonid, latid, timeid, ndim
      INTEGER corner(4), edges(4), dims(4)
      INTEGER yy_e, mm_e, dd_e, leng
      REAL ritau, r_year, r_month, r_day, sec, dt
      CHARACTER*70 str70, var70, version70, grid70, taxe70, gridref70
      CHARACTER*120 orig120
      CHARACTER*4 str4, guess_var
!
      CHARACTER*80 ncfile, var, titre, unit, str80
!
      REAL, ALLOCATABLE, DIMENSION(:) :: lon, lat, mon
!
      INCLUDE "netcdf.inc"
!
!CCCCCCCCCCCCCCCCCCCCCC

      call getarg(1,infl)

      if(infl.eq.' ')then

         write(*,*) 'Enter ascii grid file name'

         read(*,'(a72)')infl

      endif

      IF ( index(infl,'.dat') .GE. 1 ) THEN
         ncfile = infl(1:index(infl,'.dat'))//'nc'
      ELSE
         WRITE(*,*) 'ERROR : The filename provided does not end with .dat'
         STOP
      ENDIF
      WRITE(*,*) 'File to be opened : ', infl
      open(1,file=infl,status='old')

      read(1,'(A70)') orig120
      WRITE(*,*) 'line 1 :', orig120

      read(1,'(A70)') var70
      CALL noblank(var70)
      im=len_trim(var70)
! Guess variable name
      ind = index(var70,'=')
      guess_var=var70(2:ind-1)
! Get titre
      titre=var70(ind+1:im)
      WRITE(*,*) 'guess_var : ', guess_var
      WRITE(*,*) 'titre : ', titre

      read(1,'(A70)') version70
      CALL noblank(version70)
      WRITE(*,*) 'Version :', version70

      read(1,'(A70)') grid70
      CALL noblank(grid70)
! Get lon extreme values
      im=len_trim(grid70)
      ind = index(grid70,'Long=')
      str70=grid70(ind+5:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
      ind = index(str70,',')
      im=len_trim(str70)
      str70=str70(1:ind-1)//' '//str70(ind+1:im)
!      WRITE(*,*) 'Long(str) ', str70(1:len_trim(str70))
      READ(str70,*) xmin,xmax
      WRITE(*,*) 'Long(val) ', xmin,xmax
! Get Lat extreme values
      im=len_trim(grid70)
      ind = index(grid70,'Lati=')
      str70=grid70(ind+5:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
      ind = index(str70,',')
      im=len_trim(str70)
      str70=str70(1:ind-1)//' '//str70(ind+1:im)
!      WRITE(*,*) 'Lati(str) ', str70(1:len_trim(str70))
      READ(str70,*) ymin,ymax
      WRITE(*,*) 'Lati(val) ', ymin,ymax
! Get number of rown and columns
      im=len_trim(grid70)
      ind = index(grid70,'GridX,Y=')
      str70=grid70(ind+8:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
      ind = index(str70,',')
      im=len_trim(str70)
      str70=str70(1:ind-1)//' '//str70(ind+1:im)
!      WRITE(*,*) 'Grid(str) ', str70(1:len_trim(str70))
      READ(str70,*) n_cols, n_rows
      WRITE(*,*) 'Grid(val) ', n_cols, n_rows
!
      read(1,'(A70)') gridref70
      CALL noblank(gridref70)
! Get Year extreme values
      im=len_trim(gridref70)
      ind = index(gridref70,'Boxes=')
      str70=gridref70(ind+6:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
!      WRITE(*,*) 'Boxes(str) ', str70(1:len_trim(str70))
      READ(str70,*) n_boxes
      WRITE(*,*) 'Boxes(val) ', n_boxes
! Get Year extreme values
      im=len_trim(gridref70)
      ind = index(gridref70,'Years=')
      str70=gridref70(ind+6:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
      ind = index(str70,'-')
      im=len_trim(str70)
      str70=str70(1:ind-1)//' '//str70(ind+1:im)
!      WRITE(*,*) 'Years(str) ', str70(1:len_trim(str70))
      READ(str70,*) year_min,year_max
      WRITE(*,*) 'Year(val) ', year_min,year_max
      n_years = (year_max - year_min)+1
! Get Missing value (integer)
      im=len_trim(gridref70)
      ind = index(gridref70,'Missing=')
      str70=gridref70(ind+8:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
!      WRITE(*,*) 'Missing(str) ', str70(1:len_trim(str70))
      READ(str70,*) missing_i
      WRITE(*,*) 'Missing(val) ', missing_i
! Get Scaling factor
      im=len_trim(gridref70)
      ind = index(gridref70,'Multi=')
      str70=gridref70(ind+6:im)
      ind = index(str70,']')
      str70=str70(1:ind-1)
!      WRITE(*,*) 'Multi(str) ', str70(1:len_trim(str70))
      READ(str70,*) scale
      WRITE(*,*) 'Multi(val) ', scale
      !
      !
      ! Set some variable specific variables
      !
      SELECTCASE (guess_var)
      CASE ('pre')
         add = 0.0
         var = 'pre'
         unit = 'mm/month'
         titre = 'Precipitation'
      CASE ('cld')
         add = 0.0
         var = 'cld'
         unit = '%'
         titre = 'Cloud cover'
      CASE ('dtr')
         add = 0.0
         var = 'dtr'
         unit = 'K'
         titre = 'Diurnal temperature range'
      CASE ('rd0')
         add = 0.0
         var = 'rd0'
         unit = 'wet day frequency'
         titre = 'days'
      CASE ('tmp')
         add = 0.0
         var = 'tmp'
         unit = 'C'
         titre = 'Surface air temperature'
      CASE ('vap')
         add = 0.0
         var = 'vap'
         unit = 'hPa'
         titre = 'vapour pressure'
      CASE ('ctmp')
         add = 0.0
         var = 'tmp'
         unit = 'C'
         titre = 'Air temperature'
      CASE ('cpre')
         add = 0.0
         var = 'pre'
         unit = 'mm/d'
         titre = 'Precipitation'
      CASE ('ccld')
         add = 0.0
         var = 'cld'
         unit = '%'
         titre = 'Cloud cover'
      CASE ('cdtr')
         add = 0.0
         var = 'dtr'
         unit = 'C'
         titre = 'Diurnal temperature range'
      CASE ('cfrs')
         add = 0.0
         var = 'frs'
         unit = 'days'
         titre = 'Ground-frost frequency'
      CASE ('crad')
         add = 0.0
         var = 'rad'
         unit = 'W/m^2/sec'
         titre = 'Radiation'
      CASE ('cwet')
         add = 0.0
         var = 'wet'
         unit = 'days'
         titre = 'Wet day frequency'
      CASE ('ctmx')
         add = 0.0
         var = 'tmx'
         unit = 'C'
         titre = 'Maximum temperature'
      CASE ('ctmn')
         add = 0.0
         var = 'tmn'
         unit = 'C'
         titre = 'Minimum temperature'
      CASE ('cvap')
         add = 0.0
         var = 'vap'
         unit = 'hPa'
         titre = 'Vapour pressure'
      CASE ('cwnd')
         add = 0.0
         var = 'wnd'
         unit = 'm/s'
         titre = 'Wind'
      CASE DEFAULT
         WRITE(*,*) 'ERROR : Unknown file, you need to change the program'
         STOP
      END SELECT
      !
      !
      missing_r = 1.e+20
      !
      ! Allocate memory
      !
      write(*,*) 'allocation : ', n_cols, n_rows, n_years*n_months
      ALLOCATE(grid(n_months))
      ALLOCATE(data(n_cols,n_rows,n_years*n_months))
      ALLOCATE(lon(n_cols), lat(n_rows), mon(n_years*n_months))
      !
      ! Build grids
      !
      gd_size=0.5
      lon(1) = xmin + gd_size/2
      !      
      DO ilon = 2, n_cols
         lon(ilon) = lon(ilon-1) + gd_size
      ENDDO
      !
      lat(1) = ymin + gd_size/2
      DO ilat = 2, n_rows
         lat(ilat) = lat(ilat-1) + gd_size
      ENDDO
      !
      dt = 365./FLOAT(n_months)
      !
      ! We create a calendar in month since the 15th of January 1900
      !
      DO im = 1, n_years*n_months
         mon(im) = REAL(im-1)+(year_min-1900)*n_months
      ENDDO
      !
      !
      grid=missing_i
      data=missing_r
      !
      !
      !     Set up the netCDF file
      !
      iret = NF_CREATE(ncfile, NF_CLOBBER, fid)
      iret = NF_DEF_DIM(fid, 'lon', n_cols, dimlonid)
      iret = NF_DEF_DIM(fid, 'lat', n_rows, dimlatid)
      iret = NF_DEF_DIM(fid, 'time', NF_UNLIMITED, dimtimid)
      IF (iret .NE. NF_NOERR) THEN
         PRINT *, NF_STRERROR(iret)
         STOP 'stopped nf_def_dim'
      ENDIF
      !
      !    The longitude
      !
      ndim = 1
      dims(1) = dimlonid
      !
      iret = NF_DEF_VAR(fid, "lon", NF_FLOAT, ndim, dims, lonid)
      iret = NF_PUT_ATT_TEXT(fid, lonid, 'units', 12, "degrees_east")
      iret = NF_PUT_ATT_REAL(fid, lonid, 'valid_min', NF_FLOAT, 1, -180.)
      iret = NF_PUT_ATT_REAL(fid, lonid, 'valid_max', NF_FLOAT, 1, 180.)
      iret = NF_PUT_ATT_TEXT(fid, lonid, 'title', 9, "Longitude")   
      !
      !    The latitude
      !
      ndim = 1
      dims(1) = dimlatid
      !
      iret = NF_DEF_VAR(fid, "lat", NF_FLOAT, ndim, dims, latid)
      iret = NF_PUT_ATT_TEXT(fid, latid, 'units', 12, "degrees_north")
      iret = NF_PUT_ATT_REAL(fid, latid, 'valid_min', NF_FLOAT, 1, -90.)
      iret = NF_PUT_ATT_REAL(fid, latid, 'valid_max', NF_FLOAT, 1, 90.)
      iret = NF_PUT_ATT_TEXT(fid, latid, 'title', 9, "Latitude")
      !
      ndim = 1
      dims(1) = dimtimid
      !
      yy_e = 1900
      mm_e = 1
      dd_e = 15
      WRITE(str70,7000) yy_e, mm_e, dd_e, 0, 0, 0
 7000 FORMAT('months since ', I4.4,'-',I2.2,'-',I2.2,' ',I2.2,':',I2.2,':',I2.2)
      !
      WRITE(*,*) 'Starting time stamp : ', str70
      WRITE(*,*) 'First month in this file : ', mon(1)
      !
      iret = NF_DEF_VAR(fid, 'time', NF_FLOAT, ndim, dims, timeid)
      IF (iret .NE. NF_NOERR) THEN
         PRINT *, NF_STRERROR(iret)
         STOP 'stopped nf_def_var'
      ENDIF
      !
      iret = NF_PUT_ATT_TEXT(fid, timeid, 'units', len_trim(str70), str70)
      !
      iret = NF_PUT_ATT_TEXT(fid, timeid, 'title', 4, 'Time')
      !
      iret = NF_PUT_ATT_TEXT(fid, timeid, 'long_name', 9, 'Time axis')
      WRITE(str70,7001) yy_e, mm_e, dd_e, 0, 0, 0
      leng = LEN_TRIM(str70)
      iret = NF_PUT_ATT_TEXT(fid, timeid,  'time_origin', leng, str70)
7001 FORMAT(' ', I4.4,'-',I2.2,'-',I2.2,' ',I2.2,':',I2.2,':',I2.2)
!
      ndim = 3
      dims(1) = dimlonid
      dims(2) = dimlatid
      dims(3) = dimtimid
!
      iret = NF_DEF_VAR(fid, var, NF_FLOAT, ndim, dims, tid)
      iret = NF_PUT_ATT_TEXT(fid, tid, 'units', len_trim(unit), unit)
      iret = NF_PUT_ATT_TEXT(fid, tid, 'long_name', len_trim(titre), titre)
      iret = NF_PUT_ATT_REAL(fid, tid, 'missing_value', NF_FLOAT, 1, missing_r)
!     
!     Global attributes
!
      str80 = orig120
      iret =NF_PUT_ATT_TEXT(fid, NF_GLOBAL, 'Source', len_trim(str80), str80)
      str80 = version70
      iret =NF_PUT_ATT_TEXT(fid, NF_GLOBAL, 'Version', len_trim(str80), str80)
      iret =NF_PUT_ATT_TEXT(fid, NF_GLOBAL, 'File', len_trim(infl), infl)
!
!  End definition
!
      iret = NF_ENDDEF(fid)
      IF (iret .NE. NF_NOERR) THEN
         PRINT *, NF_STRERROR(iret)
         STOP 'stopped end definition'
      ENDIF
!
      corner(1) = 1
      edges(1) = n_cols
      iret = NF_PUT_VARA_REAL(fid, lonid, corner, edges, lon)
      corner(1) = 1
      edges(1) = n_rows
      iret = NF_PUT_VARA_REAL(fid, latid, corner, edges, lat)
      corner(1) = 1
      edges(1) = n_months*n_years
      iret = NF_PUT_VARA_REAL(fid, timeid, corner, edges, mon)
      IF (iret .NE. NF_NOERR) THEN
         PRINT *, NF_STRERROR(iret)
         STOP 'stopped'
      ENDIF
!
      DO ib=1,n_boxes

         read(1,'(A70)') str70
         CALL noblank(str70)
         im=len_trim(str70)
         ind = index(str70,'=')
         str70=str70(ind+1:im)
         ind = index(str70,',')
         im=len_trim(str70)
         str70=str70(1:ind-1)//' '//str70(ind+1:im)
         READ(str70,*) ilon, ilat
         WRITE(*,*) 'Working on coordinates : ',  lon(ilon), lat(ilat), &
              & NINT((ib/FLOAT(n_boxes))*100), '%'

         DO iy=0,n_years-1
            READ(1,'(12I5)') (grid(im), im = 1, n_months)
            data(ilon, ilat, (iy*n_months)+1:(iy+1)*n_months) = grid(:)*scale + add
         ENDDO

         !
      ENDDO
!
      corner(1) = 1
      edges(1) = n_cols
      corner(2) = 1
      edges(2) = n_rows
      corner(3) = 1
      edges(3) = n_months*n_years
      !
      iret = NF_PUT_VARA_REAL(fid, tid, corner, edges, data)
      !
      iret = NF_CLOSE(fid)
      END
!
!
!
      SUBROUTINE noblank(str)
        !
        IMPLICIT NONE
        !
        CHARACTER(len=*), INTENT(inout) :: str
        !
        INTEGER :: i,ll
        !
        ll=len_trim(str)
        DO i=1,len_trim(str)
           IF ( str(i:i) == ' ' ) THEN
              IF ( i > 1 ) THEN
                 str=str(1:i-1)//str(i+1:ll)
              ELSE
                 str=str(i+1:ll)
              ENDIF
              ll=len_trim(str)
           ENDIF
        ENDDO
        !
        RETURN

      END SUBROUTINE noblank
